/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Position;
import com.uppaal.model.core2.Property;
import java.util.List;

class SnapVisitor
extends AbstractVisitor {
    private List<Position> positions;
    private int diameter;

    SnapVisitor(int diameter, List<Position> positions) {
        this.diameter = diameter;
        this.positions = positions;
    }

    private int snap(float value) {
        return Math.round(value / (float)this.diameter) * this.diameter;
    }

    private void snap(Element element) {
        Integer x = (Integer)element.getPropertyValue("x");
        Integer y = (Integer)element.getPropertyValue("y");
        if (x != null && y != null) {
            this.positions.add(new Position(element, this.snap(x.intValue()), this.snap(y.intValue())));
        }
    }

    @Override
    public void visitProperty(Property property) throws Exception {
        this.snap(property);
    }

    @Override
    public void visitLocation(Location location) throws Exception {
        this.snap(location);
        super.visitLocation(location);
    }

    @Override
    public void visitNail(Nail nail) throws Exception {
        this.snap(nail);
    }
}

