/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Template;
import com.uppaal.model.system.Process;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.Translator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class UppaalSystem {
    private Vector<Process> processes;
    private Vector<String> variables;
    private Vector<String> clocks;
    private Map<String, Template> templates;
    private Document document;
    private SystemState initial;

    public UppaalSystem() {
        this.processes = new Vector();
        this.templates = new HashMap<String, Template>();
        this.clocks = new Vector();
        this.variables = new Vector();
        this.initial = null;
        this.document = null;
    }

    public UppaalSystem(Document aDocument) {
        this.initial = null;
        this.document = aDocument;
        this.clocks = new Vector();
        this.processes = new Vector();
        this.templates = new HashMap<String, Template>();
        this.variables = new Vector();
        for (Node node = this.document.getFirst(); node != null; node = node.getNext()) {
            this.templates.put((String)node.getPropertyValue("name"), (Template)node);
        }
    }

    public void setVariables(Vector<String> value) {
        this.variables = value;
    }

    public void setClocks(Vector<String> value) {
        this.clocks = value;
    }

    public void addProcess(String processName, String templateName, Translator map) {
        Node node;
        templateName = templateName.trim();
        processName = processName.trim();
        for (node = this.document.getFirst(); node != null && !templateName.equals(((String)node.getPropertyValue("name")).trim()); node = node.getNext()) {
        }
        assert (node != null) : "Template " + templateName + " not found.";
        final Process p = new Process(processName, this.processes.size(), (Template)node, map);
        node.acceptSafe(new AbstractVisitor(){

            @Override
            public void visitLocation(Location location) {
                p.addLocation(location);
            }

            @Override
            public void visitEdge(Edge edge) {
                p.addEdge(edge);
            }
        });
        this.processes.add(p);
    }

    public Process getProcess(int process) {
        return this.processes.get(process);
    }

    public SystemEdge getEdge(int process, int edge) {
        return this.getProcess(process).getEdge(edge);
    }

    public SystemLocation getLocation(int process, int edge) {
        return this.getProcess(process).getLocation(edge);
    }

    public int getNoOfProcesses() {
        return this.processes.size();
    }

    public int getProcessIndex(String id) {
        for (int i = 0; i < this.processes.size(); ++i) {
            if (!id.equals(this.getProcess(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public int getNoOfVariables() {
        return this.variables.size();
    }

    public String getVariableName(int i) {
        return this.variables.get(i);
    }

    public int getNoOfClocks() {
        return this.clocks.size();
    }

    public String getClockName(int i) {
        return this.clocks.get(i);
    }

    public String getLocationName(int i, int j) {
        return this.getProcess(i).getLocation(j).getName();
    }

    public Document getDocument() {
        return this.document;
    }

    public SystemState getInitial() {
        return this.initial;
    }

    public void setInitial(SystemState state) {
        this.initial = state;
    }
}

