/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import java.io.IOException;
import java.io.InputStream;

public class LexicalAnalyser {
    public static final int NEWLINE = 0;
    public static final int END = 1;
    public static final int WORD = 2;
    public static final int BLOCK = 3;
    public static final int INT = 4;
    public static final int NONE = 5;
    public static final int ERROR_EOL = 10;
    private static final char EOS = '\u0000';
    private static final char NL = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final char DOT = '.';
    private static String word;
    private int lookahead;
    private char peak;
    private char[] cb = new char[256];
    private byte[] bb = new byte[2048];
    private int offset = 0;
    private int bytes = 0;
    private int value;
    private InputStream in;

    public LexicalAnalyser(InputStream r) {
        this.in = r;
        this.peak = (char)32;
        this.lookahead = 5;
    }

    public int getLookahead() throws IOException {
        if (this.lookahead == 5) {
            this.lookahead = this.nextToken();
        }
        return this.lookahead;
    }

    public String getWord() {
        return word;
    }

    public int getValue() {
        return this.value;
    }

    private void fill() throws IOException {
        this.bytes = this.in.read(this.bb);
        this.offset = 0;
    }

    public String readBlock() throws IOException {
        assert (this.lookahead == 5);
        StringBuffer s = new StringBuffer();
        while (Character.isWhitespace(this.peak)) {
            this.peak = this.read();
        }
        while (true) {
            if (this.peak == '.') {
                this.peak = this.read();
                if (this.peak != '.') break;
            }
            s.append(this.peak);
            this.peak = this.read();
        }
        word = s.toString();
        return word;
    }

    public char read() throws IOException {
        char c;
        do {
            if (this.offset != this.bytes) continue;
            this.fill();
            if (this.bytes != -1) continue;
            return '\u0000';
        } while ((c = (char)this.bb[this.offset++]) == '\r');
        return c;
    }

    public int nextToken() throws IOException {
        if (this.lookahead != 5) {
            int token = this.lookahead;
            this.lookahead = 5;
            return token;
        }
        int sign = 1;
        int i = 0;
        while (Character.isWhitespace(this.peak)) {
            this.peak = this.read();
        }
        switch (this.peak) {
            case '\u0000': {
                throw new IOException("Server connection lost");
            }
            case '.': {
                this.peak = this.read();
                if (Character.isWhitespace(this.peak)) {
                    return 1;
                }
                this.cb[i++] = 46;
                break;
            }
            case '-': {
                sign = -1;
                this.peak = this.read();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.value = 0;
                while (this.peak >= '0' && this.peak <= '9') {
                    this.value = 10 * this.value + (this.peak - 48);
                    this.cb[i++] = this.peak;
                    this.peak = this.read();
                }
                if (this.peak != '\u0000' && !Character.isWhitespace(this.peak)) break;
                this.value = sign * this.value;
                return 4;
            }
        }
        while (this.peak != '\u0000' && !Character.isWhitespace(this.peak)) {
            this.cb[i++] = this.peak;
            this.peak = this.read();
        }
        word = new String(this.cb, 0, i);
        return 2;
    }
}

