/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSToEdit {
    private HashMap<String, String> supportedFormats = new HashMap();
    private boolean multipleFormats = false;
    private Process p;

    public PSToEdit() throws Exception {
        try {
            Process p = Runtime.getRuntime().exec("pstoedit -help");
            this.findSupportedFormats(this.streamToString(p.getInputStream()));
            this.multipleFormats = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.supportedFormats.put("eps", "Encapsulated Post Script");
    }

    private String streamToString(InputStream is) throws Exception {
        int tmp;
        InputStreamReader in = new InputStreamReader(is);
        StringBuffer res = new StringBuffer();
        while ((tmp = in.read()) != -1) {
            res.append((char)tmp);
        }
        return res.toString();
    }

    public boolean multipleFormats() {
        return this.multipleFormats;
    }

    public Set<String> getFormats() {
        return this.supportedFormats.keySet();
    }

    private void findSupportedFormats(String s) {
        int extensionIndex = 1;
        int descriptionIndex = 3;
        s = s.replaceFirst("(?s)^.*Available formats :\n", "");
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] cols;
            String line = lines[i];
            if (line.startsWith("T") || line.startsWith("-") || line.startsWith("[") || (cols = line.split("\\t")).length < descriptionIndex) continue;
            if (descriptionIndex == 3 && cols[descriptionIndex].equals("")) {
                descriptionIndex = 5;
            }
            this.supportedFormats.put(cols[extensionIndex].replaceFirst(":", ""), cols[descriptionIndex].trim());
        }
    }

    public String formatToExtension(String format) {
        HashMap<String, String> converter = new HashMap<String, String>();
        converter.put("xfig", "fig");
        converter.put("java2", "java");
        converter.put("java1", "java");
        converter.put("dxf_s", "dxf");
        converter.put("latex2e", "tex");
        converter.put("tgif", "obj");
        converter.put("idraw", "eps");
        String res = (String)converter.get(format);
        if (res == null) {
            res = format;
        }
        return res;
    }

    public String formatToDescription(String format) {
        HashMap<String, String> converter = new HashMap<String, String>();
        converter.put("latex2e", "Latex2e picture environment");
        String res = (String)converter.get(format);
        if (res == null) {
            res = this.supportedFormats.get(format);
        }
        return res;
    }

    public OutputStream getExportStream(String format, double scale, String filepath) throws Exception {
        if (format.equals("eps")) {
            return new FileOutputStream(filepath);
        }
        this.p = Runtime.getRuntime().exec("pstoedit -f " + format + " -scale " + scale + " - " + filepath);
        return this.p.getOutputStream();
    }
}

