/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.EngineException;
import com.uppaal.engine.EngineStub;
import com.uppaal.engine.Problem;
import com.uppaal.engine.QueryFeedback;
import com.uppaal.model.core2.Document;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.Transition;
import com.uppaal.model.system.UppaalSystem;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    protected EngineStub stub;
    private int version;
    private String options;
    private UppaalSystem system;

    public Engine() {
        this.stub = new EngineStub();
    }

    public Engine(int mode, int port, String host, String path) {
        this.stub = new EngineStub(mode, port, host, path);
    }

    public void setServerPath(String path) {
        this.disconnect();
        this.stub.setServerPath(path);
    }

    public void setServerPort(int port) {
        this.disconnect();
        this.stub.setServerPort(port);
    }

    public void setServerHost(String host) {
        this.disconnect();
        this.stub.setServerHost(host);
    }

    public void setConnectionMode(int mode) {
        this.disconnect();
        this.stub.setConnectionMode(mode);
    }

    public void disconnect() {
        if (this.stub.isConnected()) {
            this.stub.disconnect();
            this.disconnected();
        }
    }

    public void cancel() {
        if (this.stub.isConnected()) {
            this.stub.kill();
            this.disconnected();
        }
    }

    public synchronized String getVersion() throws EngineException, IOException {
        try {
            this.connect();
            return this.stub.getVersion();
        }
        catch (Throwable e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized String getOptionsInfo() throws EngineException, IOException {
        try {
            this.connect();
            return this.stub.getOptionsInfo();
        }
        catch (Throwable e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized Vector<Transition> getTransitions(UppaalSystem system, SystemState state) throws EngineException, IOException {
        try {
            this.activate(system);
            return this.stub.getTransitions(system, state);
        }
        catch (Throwable e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized UppaalSystem getSystem(Document document, Vector<Problem> problems) throws EngineException, IOException {
        try {
            this.connect();
            UppaalSystem s = this.stub.upload(document, problems);
            if (s != null) {
                this.options = null;
                this.version = document.getVersion();
                s.setInitial(this.stub.getInitial(s));
                this.system = s;
            }
            return s;
        }
        catch (Throwable e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    public synchronized char query(UppaalSystem system, String options, String query, QueryFeedback f) throws EngineException, IOException {
        try {
            this.activate(system);
            if (!options.equals(this.options)) {
                this.stub.setOptions(options);
                this.options = options;
            }
            return this.stub.query(system, query, f);
        }
        catch (Throwable e) {
            this.cancel();
            throw new EngineException(e);
        }
    }

    private void activate(UppaalSystem value) throws EngineException, IOException {
        this.connect();
        if (this.system != value || this.version != value.getDocument().getVersion()) {
            if (this.stub.upload(value.getDocument()) == null) {
                throw new EngineException("Could not transfer model to engine due to syntax errors.");
            }
            this.system = value;
            this.version = value.getDocument().getVersion();
            this.options = null;
        }
    }

    private void connect() throws EngineException, IOException {
        if (!this.stub.isConnected()) {
            this.stub.connect();
            this.version = -1;
            this.system = null;
            this.options = null;
            this.connected();
        }
    }

    protected void connected() throws IOException, EngineException {
    }

    protected void disconnected() {
    }
}

