/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.engine.Engine;
import com.uppaal.engine.ProtocolException;
import com.uppaal.gui.Main;
import com.uppaal.gui.ModePanel;
import com.uppaal.gui.SystemInspector;
import com.uppaal.gui.Tab;
import com.uppaal.gui.simulator.ChoiceModel;
import com.uppaal.gui.simulator.JMSCLog;
import com.uppaal.gui.simulator.PTDisplayPanel;
import com.uppaal.gui.simulator.TraceModel;
import com.uppaal.model.core2.Constants;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.io2.PSWriter;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.Process;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.Transition;
import com.uppaal.model.system.Translator;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.util.ObservablePointer;
import com.uppaal.util.error.InfoError;
import com.uppaal.util.files.FileHandle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.Timer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Simulator
extends Tab
implements Constants {
    private static String overwriteWarning = "Warning: this will destroy a part of the current trace! Continue?";
    private static final int DIST = 5;
    private SystemInspector inspector;
    private PTDisplayPanel[] processDisplayPanel = new PTDisplayPanel[0];
    private JPanel mainArea;
    private ModePanel innerPanel;
    private JList choiceList;
    private JList variables;
    private JList traceList;
    private JTextField fileName;
    private JToggleButton randomButton;
    private JToggleButton replayButton;
    private JSlider slider;
    private Timer caller;
    private FileHandle traceFile;
    private FileHandle psFile;
    private boolean showFullDBM = false;
    private boolean[] visible;
    private int noOfProcesses;
    private ObservablePointer system;
    private SystemState currentState;
    private SystemState visibleState;
    private ChoiceModel choices;
    private UpdateThread updater;
    private TraceModel trace;
    private boolean ignore = false;
    private Dimension oldDim;
    public AbstractAction viewProcessesAction = new n(this);
    public AbstractAction viewVariablesAction = new h(this);
    public AbstractAction viewFullDBMAction = new T(this);
    public AbstractAction selectPrevAction = new A(this);
    public AbstractAction selectNextAction = new ai(this);
    public AbstractAction stepAction = new W(this);
    public AbstractAction toggleAction = new ap(this);
    public AbstractAction prevAction = new ck(this);
    public AbstractAction nextAction = new cg(this);
    public AbstractAction firstAction = new b(this);
    public AbstractAction lastAction = new aw(this);
    public AbstractAction replayAction = new bg(this);
    public AbstractAction randomAction = new aT(this);
    public AbstractAction loadTraceAction = new bm(this);
    public AbstractAction saveTraceAction = new cs(this);
    private boolean doUpdateChoices = false;
    private boolean doSelectChoice = false;
    private boolean doUpdateView = false;
    private boolean doUpdateButtons = false;
    private boolean doRandomStep = false;
    private boolean doReplayStep = false;
    private boolean updating = false;
    private boolean updated = true;

    public Simulator(SystemInspector systemInspector, ObservablePointer observablePointer) throws Exception {
        this.inspector = systemInspector;
        this.system = observablePointer;
        this.c(true);
        this.choices = new ChoiceModel(new Vector());
        this.updater = new UpdateThread();
        this.trace = new TraceModel();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPrev", this.selectPrevAction);
        actionMap.put("selectNext", this.selectNextAction);
        actionMap.put("step", this.stepAction);
        actionMap.put("toggle", this.toggleAction);
        actionMap.put("prev", this.prevAction);
        actionMap.put("next", this.nextAction);
        actionMap.put("first", this.firstAction);
        actionMap.put("last", this.lastAction);
        actionMap.put("replay", this.replayAction);
        actionMap.put("random", this.randomAction);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("Z"), "selectPrev");
        inputMap.put(KeyStroke.getKeyStroke("X"), "selectNext");
        inputMap.put(KeyStroke.getKeyStroke("Q"), "prev");
        inputMap.put(KeyStroke.getKeyStroke("A"), "next");
        inputMap.put(KeyStroke.getKeyStroke("P"), "replay");
        inputMap.put(KeyStroke.getKeyStroke("R"), "random");
        inputMap.put(KeyStroke.getKeyStroke("F"), "first");
        inputMap.put(KeyStroke.getKeyStroke("L"), "last");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "step");
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "toggle");
        bb bb2 = new bb(this);
        bb2.insert("xml/Simulator.xml", this);
        ((JSplitPane)bb2.find("mainSplit")).setRightComponent(new JMSCLog(this.system, this.trace, this.traceList.getSelectionModel()));
        JScrollPane jScrollPane = (JScrollPane)bb2.find("scrollPane");
        jScrollPane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(32);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(32);
        this.mainArea.setBackground(PROCESS_FILL_COL);
        this.mainArea.setLayout(new V(0, 5, 5));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(60, new JLabel("Fast", 4));
        ((Dictionary)hashtable).put(120, new JLabel("Slow", 2));
        this.slider.setLabelTable(hashtable);
        z z2 = new z(this);
        this.traceList.setCellRenderer(z2);
        this.traceList.setFixedCellHeight(z2.getPreferredSize().height);
        this.traceList.setModel(this.trace);
        this.choiceList.setCellRenderer(new aa(this));
        this.psFile = new FileHandle(this.inspector);
        this.psFile.a("eps", "Encapsulated PS File", true);
        this.traceFile = new FileHandle(this.inspector);
        this.traceFile.a("xtr", "UPPAAL Trace File", true);
        this.system.addObserver(new bv(this));
        this.choiceList.addListSelectionListener(new bl(this));
        this.choiceList.addMouseListener(new ba(this));
        this.traceList.addListSelectionListener(new bU(this));
        this.slider.addChangeListener(new dh(this));
        this.f();
    }

    private UppaalSystem a() {
        return (UppaalSystem)this.system.a;
    }

    public final void a(String string) {
        int n2 = this.a().getProcessIndex(string);
        if (n2 > -1) {
            this.processDisplayPanel[n2].setVisible(false);
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    public final void a(Vector vector, int n2) {
        this.trace.a(vector, n2);
        this.a(this.trace.a());
        this.j();
    }

    public final void b() {
        PTDisplayPanel[] pTDisplayPanelArray = this.processDisplayPanel;
        int n2 = this.processDisplayPanel.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PTDisplayPanel pTDisplayPanel = pTDisplayPanelArray[i2];
            pTDisplayPanel.a();
        }
        this.mainArea.revalidate();
    }

    public final void c() {
        PTDisplayPanel[] pTDisplayPanelArray = this.processDisplayPanel;
        int n2 = this.processDisplayPanel.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PTDisplayPanel pTDisplayPanel = pTDisplayPanelArray[i2];
            pTDisplayPanel.b();
        }
        this.mainArea.revalidate();
    }

    public final void a(double d2) {
        PTDisplayPanel[] pTDisplayPanelArray = this.processDisplayPanel;
        int n2 = this.processDisplayPanel.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PTDisplayPanel pTDisplayPanel = pTDisplayPanelArray[i2];
            pTDisplayPanel.a(d2);
        }
        this.mainArea.revalidate();
    }

    public final double[] a() {
        double[] dArray = new double[this.processDisplayPanel.length];
        for (int i2 = 0; i2 < this.processDisplayPanel.length; ++i2) {
            dArray[i2] = this.processDisplayPanel[i2].a();
        }
        return dArray;
    }

    private void a(double[] dArray) {
        if (dArray.length == this.processDisplayPanel.length) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.processDisplayPanel[i2].a(dArray[i2]);
            }
        }
    }

    public final void a(Template template, Translator translator) {
        if (this.psFile.a("Save Postscript", "eps")) {
            try {
                FileOutputStream fileOutputStream = this.psFile.a();
                template.accept((Visitor)new PSWriter((OutputStream)fileOutputStream, "", Main.exportColors, Main.b(), translator));
                ((OutputStream)fileOutputStream).close();
                return;
            }
            catch (Exception exception) {
                Main.infoError.a("Error Saving Templates as Postscript: " + exception.getMessage());
            }
        }
    }

    private void d() {
        String[] stringArray = new String[this.noOfProcesses];
        boolean[] blArray = new boolean[this.noOfProcesses];
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            stringArray[i2] = this.a().getProcess(i2).getName();
            blArray[i2] = this.processDisplayPanel[i2].isVisible();
        }
        if (bs.a(this.inspector, "Visible Processes", stringArray, blArray)) {
            this.a(blArray);
        }
    }

    private void e() {
        int n2 = this.a().getNoOfVariables();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.a().getVariableName(i2);
        }
        if (bs.a((Frame)this.getTopLevelAncestor(), "Visible Variables", stringArray, this.visible)) {
            this.g();
        }
    }

    private void a(boolean[] blArray) {
        if (blArray.length == this.processDisplayPanel.length) {
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                this.processDisplayPanel[i2].setVisible(blArray[i2]);
            }
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    private boolean[] a() {
        boolean[] blArray = new boolean[this.noOfProcesses];
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            blArray[i2] = this.processDisplayPanel[i2].isVisible();
        }
        return blArray;
    }

    private void f() {
        double[] dArray = this.a();
        boolean[] blArray = this.a();
        UppaalSystem uppaalSystem = this.a();
        this.trace.a((SystemState)null);
        this.traceList.clearSelection();
        this.mainArea.removeAll();
        this.noOfProcesses = 0;
        this.processDisplayPanel = new PTDisplayPanel[0];
        this.visible = null;
        this.j();
        this.viewVariablesAction.setEnabled(uppaalSystem != null);
        this.viewFullDBMAction.setEnabled(uppaalSystem != null);
        this.viewProcessesAction.setEnabled(uppaalSystem != null);
        if (uppaalSystem != null) {
            int n2;
            this.noOfProcesses = uppaalSystem.getNoOfProcesses();
            this.processDisplayPanel = new PTDisplayPanel[this.noOfProcesses];
            for (n2 = 0; n2 < this.noOfProcesses; ++n2) {
                Process process = uppaalSystem.getProcess(n2);
                this.processDisplayPanel[n2] = new PTDisplayPanel(this, process.getName(), process.getTranslator());
                this.mainArea.add(this.processDisplayPanel[n2]);
                this.processDisplayPanel[n2].a(process.getTemplate());
            }
            n2 = uppaalSystem.getNoOfVariables();
            if (this.visible == null || n2 != this.visible.length) {
                this.visible = new boolean[n2];
            }
            while (n2-- > 0) {
                this.visible[n2] = true;
            }
            EventQueue.invokeLater(new dQ(this, uppaalSystem));
        }
        this.loadTraceAction.setEnabled(uppaalSystem != null);
        this.saveTraceAction.setEnabled(uppaalSystem != null);
        if (this.a()) {
            this.a(0.75);
            this.mainArea.scrollRectToVisible(new Rectangle());
        } else {
            if (dArray != null) {
                this.a(dArray);
            }
            if (blArray != null) {
                this.a(blArray);
            }
            this.mainArea.revalidate();
        }
        this.repaint();
    }

    private boolean a() {
        boolean bl2 = this.oldDim != null && !this.oldDim.equals(this.mainArea.getPreferredSize());
        this.oldDim = this.mainArea.getPreferredSize();
        return bl2;
    }

    private Transition a() {
        int n2 = this.choiceList.getSelectedIndex();
        if (n2 >= 0 && n2 < this.choices.getSize()) {
            return this.choices.a(n2);
        }
        return null;
    }

    private SystemState a() {
        int n2 = this.a();
        if (n2 >= 0 && n2 < this.trace.getSize()) {
            if (TraceModel.b(n2)) {
                --n2;
            }
            return (SystemState)this.trace.getElementAt(n2);
        }
        return null;
    }

    private void a(Vector vector) {
        this.choices = new ChoiceModel(vector);
        this.choiceList.clearSelection();
        this.choiceList.setModel(this.choices);
    }

    private void g() {
        Vector<String> vector = new Vector<String>();
        if (this.visibleState != null) {
            int[] nArray = this.visibleState.getVariables();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (this.visible != null && !this.visible[i2]) continue;
                vector.add(this.a().getVariableName(i2) + " = " + nArray[i2]);
            }
            Polyhedron polyhedron = this.visibleState.getPolyhedron();
            if (this.showFullDBM) {
                polyhedron.getAllConstraints(vector);
            } else {
                polyhedron.getSufficientConstraints(vector);
            }
        }
        this.variables.setListData(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(Transition transition) {
        int n2 = this.a();
        if (n2 >= 0 && !this.trace.d(n2) && !Main.choiceError.a(overwriteWarning)) {
            return false;
        }
        if (TraceModel.b(n2)) {
            --n2;
        }
        this.ignore = true;
        try {
            this.trace.a(n2, transition);
        }
        finally {
            this.ignore = false;
        }
        this.a(this.trace.a());
        return true;
    }

    private int a() {
        return this.traceList.getSelectedIndex();
    }

    private void a(int n2) {
        this.traceList.setSelectedIndex(n2);
        this.traceList.ensureIndexIsVisible(n2);
        this.traceList.revalidate();
    }

    private int b() {
        return (int)Math.pow(2.0, (double)this.slider.getValue() / 10.0);
    }

    private int c() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i2 = 0; i2 < this.choices.getSize(); ++i2) {
            Transition transition = this.choices.a(i2);
            if (transition.getTarget() == null) continue;
            vector.add(i2);
        }
        if (vector.size() == 0) {
            return -1;
        }
        return (Integer)vector.get((int)((double)vector.size() * Math.random()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void h() {
        String string;
        InfoError infoError;
        try {
            if (this.traceFile.a("Open Trace File")) {
                this.fileName.setText(this.traceFile.c());
                FileInputStream fileInputStream = this.traceFile.a();
                if (fileInputStream == null) {
                    throw new FileNotFoundException();
                }
                try {
                    this.trace.a(this.a(), fileInputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
                this.a(0);
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            infoError = Main.infoError;
            string = "File not found: " + this.traceFile.c();
        }
        catch (IOException iOException) {
            infoError = Main.infoError;
            string = iOException.getMessage();
        }
        catch (ProtocolException protocolException) {
            infoError = Main.infoError;
            string = "This is not a valid trace file";
        }
        infoError.a(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void i() {
        block8: {
            String string;
            InfoError infoError;
            try {
                if (this.traceFile.a("Save Trace File", "xtr")) {
                    this.fileName.setText(this.traceFile.c());
                    FileOutputStream fileOutputStream = this.traceFile.a();
                    if (fileOutputStream == null) {
                        throw new FileNotFoundException();
                    }
                    try {
                        this.trace.a(fileOutputStream);
                        break block8;
                    }
                    finally {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                infoError = Main.infoError;
                string = "File not found: " + fileNotFoundException.getMessage();
            }
            catch (IOException iOException) {
                infoError = Main.infoError;
                string = iOException.getMessage();
            }
            infoError.a(string);
        }
    }

    public final void k() {
        this.viewProcessesAction.setEnabled(true);
        this.viewVariablesAction.setEnabled(true);
        this.viewFullDBMAction.setEnabled(true);
    }

    public final void l() {
        this.viewProcessesAction.setEnabled(false);
        this.viewVariablesAction.setEnabled(false);
        this.viewFullDBMAction.setEnabled(false);
    }

    private void j() {
        this.doUpdateChoices = true;
        this.doSelectChoice = true;
        this.doUpdateView = true;
        this.doUpdateButtons = true;
        this.o();
    }

    private void m() {
        this.doSelectChoice = true;
        this.doUpdateChoices = true;
        this.doUpdateButtons = true;
        this.doUpdateView = true;
        this.o();
    }

    private void n() {
        this.doUpdateView = true;
        this.doUpdateButtons = true;
        this.o();
    }

    private void o() {
        if (!this.updating) {
            this.updating = true;
            EventQueue.invokeLater(new cd(this));
        }
    }

    private void p() {
        int n2;
        int n3;
        if (this.doRandomStep && this.updated) {
            n3 = this.c();
            if (n3 == -1 || !this.a(this.choices.a(n3))) {
                this.s();
            }
            this.doRandomStep = false;
        }
        if (this.doReplayStep) {
            if (!this.trace.d(this.a())) {
                int n4;
                int n5;
                Simulator simulator;
                if (TraceModel.a(this.a()) || this.a() == this.trace.getSize() - 2) {
                    simulator = this;
                    n5 = this.a();
                    n4 = 1;
                } else {
                    simulator = this;
                    n5 = this.a();
                    n4 = 2;
                }
                simulator.a(n5 + n4);
            }
            if (this.trace.d(this.a())) {
                this.s();
            }
            this.doReplayStep = false;
        }
        if (this.doUpdateChoices) {
            SystemState systemState = this.a();
            if (this.currentState != systemState) {
                this.currentState = systemState;
                this.a(new Vector());
                if (systemState != null) {
                    this.updated = false;
                    this.updater.a();
                } else {
                    this.updated = true;
                }
            }
            this.doUpdateChoices = false;
            this.doSelectChoice = true;
        }
        if (this.doSelectChoice && this.updated) {
            n3 = this.a();
            if (n3 >= 0 && n3 < this.trace.getSize()) {
                int n6;
                n2 = -1;
                if (this.trace.d(n3)) {
                    n6 = this.c();
                } else if (!TraceModel.a(n3)) {
                    n6 = n2 = this.choices.a(this.trace.a(n3));
                }
                if (n2 >= 0 && n2 < this.choices.getSize()) {
                    this.choiceList.setSelectedIndex(n2);
                    this.choiceList.ensureIndexIsVisible(n2);
                    this.choiceList.revalidate();
                } else {
                    this.choiceList.clearSelection();
                }
            }
            this.doSelectChoice = false;
            this.doUpdateView = true;
            this.doUpdateButtons = true;
        }
        if (this.doUpdateView) {
            int n7;
            int n8;
            PTDisplayPanel[] pTDisplayPanelArray;
            Color color;
            JList jList;
            SystemState systemState;
            n2 = this.choiceList.getSelectedIndex();
            Transition transition = n2 >= 0 && n2 < this.choices.getSize() ? this.choices.a(n2) : null;
            if (transition != null) {
                systemState = transition.getSource();
                jList = this.variables;
                color = new Color(49, 101, 255);
            } else {
                systemState = this.currentState;
                jList = this.variables;
                color = Color.BLACK;
            }
            jList.setForeground(color);
            if (this.visibleState != systemState) {
                this.visibleState = systemState;
                if (this.visibleState != null) {
                    pTDisplayPanelArray = systemState.getLocationVector();
                    for (n8 = 0; n8 < this.noOfProcesses; ++n8) {
                        this.processDisplayPanel[n8].a(pTDisplayPanelArray[n8].getLocation());
                    }
                } else {
                    pTDisplayPanelArray = this.processDisplayPanel;
                    n8 = this.processDisplayPanel.length;
                    for (n7 = 0; n7 < n8; ++n7) {
                        PTDisplayPanel pTDisplayPanel2 = pTDisplayPanelArray[n7];
                        pTDisplayPanel2.a((Location)null);
                    }
                }
                this.g();
            }
            pTDisplayPanelArray = this.processDisplayPanel;
            n8 = this.processDisplayPanel.length;
            for (n7 = 0; n7 < n8; ++n7) {
                PTDisplayPanel pTDisplayPanel = pTDisplayPanelArray[n7];
                pTDisplayPanel.a((Edge)null);
            }
            if (transition != null) {
                for (PTDisplayPanel pTDisplayPanel : transition.getEdges()) {
                    this.processDisplayPanel[pTDisplayPanel.getProcess().getIndex()].a(pTDisplayPanel.getEdge());
                }
            }
            this.doUpdateView = false;
        }
        if (this.doUpdateButtons) {
            int n9 = this.a();
            n2 = this.choiceList.getSelectedIndex();
            this.prevAction.setEnabled(n9 > 0 && this.caller == null);
            this.nextAction.setEnabled(!this.trace.d(n9) && this.caller == null);
            this.stepAction.setEnabled(n2 >= 0 && n2 < this.choices.getSize());
            this.doUpdateButtons = false;
        }
    }

    private void q() {
        if (this.caller == null) {
            this.replayAction.setEnabled(true);
            this.randomAction.setEnabled(false);
            this.loadTraceAction.setEnabled(false);
            this.saveTraceAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.inspector.verifier.setEnabled(false);
            this.caller = new Timer(this.b(), new cV(this, null));
            this.caller.start();
            this.replayButton.setSelected(true);
        }
    }

    private void r() {
        if (this.caller == null) {
            int n2 = this.b();
            this.replayAction.setEnabled(false);
            this.randomAction.setEnabled(true);
            this.loadTraceAction.setEnabled(false);
            this.saveTraceAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.inspector.verifier.setEnabled(false);
            this.caller = new Timer(n2, new bR(this, null));
            this.caller.start();
            this.randomButton.setSelected(true);
        }
    }

    private void s() {
        if (this.caller != null) {
            this.caller.stop();
            this.caller = null;
            this.stepAction.setEnabled(this.a() != null);
            this.inspector.verifier.setEnabled(true);
            this.randomAction.setEnabled(true);
            this.replayAction.setEnabled(true);
            this.loadTraceAction.setEnabled(this.system != null);
            this.saveTraceAction.setEnabled(this.a() != null);
            this.replayButton.setSelected(false);
            this.randomButton.setSelected(false);
            this.doUpdateButtons = true;
            this.o();
        }
    }

    public static /* synthetic */ void a(Simulator simulator) {
        simulator.d();
    }

    public static /* synthetic */ void b(Simulator simulator) {
        simulator.e();
    }

    public static /* synthetic */ boolean a(Simulator simulator, boolean bl2) {
        simulator.showFullDBM = bl2;
        return simulator.showFullDBM;
    }

    public static /* synthetic */ boolean a(Simulator simulator) {
        return simulator.showFullDBM;
    }

    public static /* synthetic */ void c(Simulator simulator) {
        simulator.g();
    }

    public static /* synthetic */ JList a(Simulator simulator) {
        return simulator.choiceList;
    }

    public static /* synthetic */ ChoiceModel a(Simulator simulator) {
        return simulator.choices;
    }

    public static /* synthetic */ Transition a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ boolean a(Simulator simulator, Transition transition) {
        return simulator.a(transition);
    }

    public static /* synthetic */ int a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ TraceModel a(Simulator simulator) {
        return simulator.trace;
    }

    public static /* synthetic */ void a(Simulator simulator, int n2) {
        simulator.a(n2);
    }

    public static /* synthetic */ Timer a(Simulator simulator) {
        return simulator.caller;
    }

    public static /* synthetic */ void d(Simulator simulator) {
        simulator.q();
    }

    public static /* synthetic */ void e(Simulator simulator) {
        simulator.s();
    }

    public static /* synthetic */ void f(Simulator simulator) {
        simulator.r();
    }

    public static /* synthetic */ void g(Simulator simulator) {
        simulator.h();
    }

    public static /* synthetic */ void h(Simulator simulator) {
        simulator.i();
    }

    public static /* synthetic */ void i(Simulator simulator) {
        simulator.f();
    }

    public static /* synthetic */ void j(Simulator simulator) {
        simulator.n();
    }

    public static /* synthetic */ void k(Simulator simulator) {
        simulator.m();
    }

    public static /* synthetic */ int b(Simulator simulator) {
        return simulator.b();
    }

    public static /* synthetic */ void l(Simulator simulator) {
        simulator.p();
    }

    public static /* synthetic */ boolean b(Simulator simulator, boolean bl2) {
        simulator.updating = bl2;
        return simulator.updating;
    }

    public static /* synthetic */ boolean c(Simulator simulator, boolean bl2) {
        simulator.doReplayStep = bl2;
        return simulator.doReplayStep;
    }

    public static /* synthetic */ void m(Simulator simulator) {
        simulator.o();
    }

    public static /* synthetic */ boolean d(Simulator simulator, boolean bl2) {
        simulator.doRandomStep = bl2;
        return simulator.doRandomStep;
    }

    public static /* synthetic */ boolean e(Simulator simulator, boolean bl2) {
        simulator.updated = bl2;
        return simulator.updated;
    }

    public static /* synthetic */ void a(Simulator simulator, Vector vector) {
        simulator.a(vector);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class UpdateThread
    extends Thread {
        private boolean a = false;

        public UpdateThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public final void run() {
            try {
                while (true) {
                    UpdateThread updateThread = this;
                    // MONITORENTER : updateThread
                    while (!this.a) {
                        this.wait();
                    }
                    this.a = false;
                    SystemState systemState = Simulator.this.currentState;
                    // MONITOREXIT : updateThread
                    updateThread = ((Simulator)Simulator.this).inspector.engine;
                    Engine engine = updateThread;
                    // MONITORENTER : updateThread
                    try {
                        Vector vector = updateThread.getTransitions((UppaalSystem)((Simulator)Simulator.this).system.a, systemState);
                        SystemState systemState2 = systemState;
                        EventQueue.invokeLater(new Z(this, systemState2, vector));
                    }
                    catch (Exception exception) {
                        EventQueue.invokeLater(new ah(this, exception));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public final synchronized void a() {
            this.a = true;
            this.notify();
        }
    }
}

