/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.io2.UGIWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class XTAWriter
extends AbstractVisitor {
    protected Map<Element, String> names = new HashMap<Element, String>();
    protected Writer writer;

    public XTAWriter(OutputStream stream) {
        this.writer = new OutputStreamWriter(stream);
    }

    public UGIWriter createUGIWriter(OutputStream stream) {
        return new UGIWriter(stream, this.names);
    }

    protected boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    protected boolean hasFlag(Element element, String property) {
        Object value = element.getPropertyValue(property);
        return value != null && (Boolean)value != false;
    }

    protected void writeNonEmptyProperty(Element element, String name) throws IOException {
        String value = (String)element.getPropertyValue(name);
        if (!this.isEmpty(value)) {
            this.writer.write(value.toString());
        }
    }

    protected void writeNewLine() throws IOException {
        this.writer.write("\n");
    }

    public void visitDocument(Document document) throws Exception {
        document.accept(new AbstractVisitor(){

            protected void collect(Element element) {
                String name = (String)element.getPropertyValue("name");
                if (!XTAWriter.this.isEmpty(name)) {
                    XTAWriter.this.names.put(element, name);
                }
            }

            public void visitLocation(Location location) throws Exception {
                this.collect(location);
            }

            public void visitTemplate(Template template) throws Exception {
                this.collect(template);
                super.visitTemplate(template);
            }
        });
        document.accept(new AbstractVisitor(){
            protected int counter = 0;

            public void visitLocation(Location location) throws Exception {
                String name = (String)location.getPropertyValue("name");
                if (XTAWriter.this.isEmpty(name)) {
                    while (XTAWriter.this.names.containsValue(name = "S" + this.counter++)) {
                    }
                    XTAWriter.this.names.put(location, name);
                }
            }
        });
        this.writeNonEmptyProperty(document, "declaration");
        this.writeNewLine();
        super.visitDocument(document);
        this.writeNonEmptyProperty(document, "instantiation");
        this.writeNewLine();
        this.writer.write(document.getPropertyValue("system").toString());
        this.writer.flush();
    }

    public void visitTemplate(Template template) throws Exception {
        this.writer.write("process ");
        this.writer.write(this.names.get(template));
        this.writer.write("(");
        this.writeNonEmptyProperty(template, "parameter");
        this.writer.write(") {\n");
        this.writeNonEmptyProperty(template, "declaration");
        template.accept(new AbstractVisitor(){
            protected boolean first = true;

            public void visitLocation(Location location) throws Exception {
                if (this.first) {
                    this.first = false;
                    XTAWriter.this.writer.write("state ");
                } else {
                    XTAWriter.this.writer.write(", ");
                }
                XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
                String invariant = (String)location.getPropertyValue("invariant");
                if (!XTAWriter.this.isEmpty(invariant)) {
                    XTAWriter.this.writer.write("{");
                    XTAWriter.this.writer.write(invariant);
                    XTAWriter.this.writer.write("}");
                }
            }
        });
        this.writer.write(";\n");
        template.accept(new AbstractVisitor(){
            protected boolean first = true;

            public void visitTemplate(Template template) throws Exception {
                super.visitTemplate(template);
                if (!this.first) {
                    XTAWriter.this.writer.write(";\n");
                }
            }

            public void visitLocation(Location location) throws Exception {
                if (XTAWriter.this.hasFlag(location, "committed")) {
                    if (this.first) {
                        this.first = false;
                        XTAWriter.this.writer.write("commit ");
                    } else {
                        XTAWriter.this.writer.write(", ");
                    }
                    XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
                }
            }
        });
        template.accept(new AbstractVisitor(){
            protected boolean first = true;

            public void visitTemplate(Template template) throws Exception {
                super.visitTemplate(template);
                if (!this.first) {
                    XTAWriter.this.writer.write(";\n");
                }
            }

            public void visitLocation(Location location) throws Exception {
                if (XTAWriter.this.hasFlag(location, "urgent")) {
                    if (this.first) {
                        this.first = false;
                        XTAWriter.this.writer.write("urgent ");
                    } else {
                        XTAWriter.this.writer.write(", ");
                    }
                    XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
                }
            }
        });
        template.accept(new AbstractVisitor(){
            protected boolean first = true;

            public void visitTemplate(Template template) throws Exception {
                super.visitTemplate(template);
                if (!this.first) {
                    XTAWriter.this.writer.write(";\n");
                }
            }

            public void visitLocation(Location location) throws Exception {
                if (XTAWriter.this.hasFlag(location, "winning")) {
                    if (this.first) {
                        this.first = false;
                        XTAWriter.this.writer.write("winning ");
                    } else {
                        XTAWriter.this.writer.write(", ");
                    }
                    XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
                }
            }
        });
        template.accept(new AbstractVisitor(){
            protected boolean first = true;

            public void visitTemplate(Template template) throws Exception {
                super.visitTemplate(template);
                if (!this.first) {
                    XTAWriter.this.writer.write(";\n");
                }
            }

            public void visitLocation(Location location) throws Exception {
                if (XTAWriter.this.hasFlag(location, "losing")) {
                    if (this.first) {
                        this.first = false;
                        XTAWriter.this.writer.write("losing ");
                    } else {
                        XTAWriter.this.writer.write(", ");
                    }
                    XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
                }
            }
        });
        template.accept(new AbstractVisitor(){

            public void visitLocation(Location location) throws Exception {
                if (XTAWriter.this.hasFlag(location, "init")) {
                    XTAWriter.this.writer.write("init ");
                    XTAWriter.this.writer.write(XTAWriter.this.names.get(location));
                    XTAWriter.this.writer.write(";\n");
                }
            }
        });
        template.accept(new AbstractVisitor(){
            protected boolean first = true;

            public void visitTemplate(Template template) throws Exception {
                super.visitTemplate(template);
                if (!this.first) {
                    XTAWriter.this.writer.write(";\n");
                }
            }

            public void visitEdge(Edge edge) throws Exception {
                if (this.first) {
                    this.first = false;
                    XTAWriter.this.writer.write("trans ");
                } else {
                    XTAWriter.this.writer.write(",\n");
                }
                XTAWriter.this.writer.write(XTAWriter.this.names.get(edge.getSource()));
                if (edge.hasFlag("controllable")) {
                    XTAWriter.this.writer.write(" -> ");
                } else {
                    XTAWriter.this.writer.write(" -u-> ");
                }
                XTAWriter.this.writer.write(XTAWriter.this.names.get(edge.getTarget()));
                String select = (String)edge.getPropertyValue("select");
                String guard = (String)edge.getPropertyValue("guard");
                String sync = (String)edge.getPropertyValue("synchronisation");
                String assign = (String)edge.getPropertyValue("assignment");
                XTAWriter.this.writer.write(" { ");
                if (!XTAWriter.this.isEmpty(select)) {
                    XTAWriter.this.writer.write("select ");
                    XTAWriter.this.writer.write(select);
                    XTAWriter.this.writer.write("; ");
                }
                if (!XTAWriter.this.isEmpty(guard)) {
                    XTAWriter.this.writer.write("guard ");
                    XTAWriter.this.writer.write(guard);
                    XTAWriter.this.writer.write("; ");
                }
                if (!XTAWriter.this.isEmpty(sync)) {
                    XTAWriter.this.writer.write("sync ");
                    XTAWriter.this.writer.write(sync);
                    XTAWriter.this.writer.write("; ");
                }
                if (!XTAWriter.this.isEmpty(assign)) {
                    XTAWriter.this.writer.write("assign ");
                    XTAWriter.this.writer.write(assign);
                    XTAWriter.this.writer.write("; ");
                }
                XTAWriter.this.writer.write(" }");
            }
        });
        this.writer.write("}\n");
    }
}

