/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.engine;

import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import java.io.IOException;

public class Problem {
    private String type;
    private String path;
    private int fline;
    private int fcolumn;
    private int lline;
    private int lcolumn;
    private String msg;
    private static final String ERROR = "While reading problem report";

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getPath() {
        return this.path;
    }

    public int getFirstLine() {
        return this.fline;
    }

    public int getFirstColumn() {
        return this.fcolumn;
    }

    public int getLastLine() {
        return this.lline;
    }

    public int getLastColumn() {
        return this.lcolumn;
    }

    private int readInt(LexicalAnalyser lex) throws ProtocolException, IOException {
        if (lex.nextToken() != 4) {
            throw new ProtocolException(ERROR);
        }
        return lex.getValue();
    }

    private String readWord(LexicalAnalyser lex) throws ProtocolException, IOException {
        if (lex.nextToken() != 2) {
            throw new ProtocolException(ERROR);
        }
        return lex.getWord();
    }

    private void readNL(LexicalAnalyser lex) throws ProtocolException, IOException {
        if (lex.nextToken() != 0) {
            throw new ProtocolException(ERROR);
        }
    }

    public Problem(String type, String path, int fline, int fcolumn, int lline, int lcolumn, String msg) {
        this.type = type;
        this.path = path;
        this.fline = fline;
        this.fcolumn = fcolumn;
        this.lline = lline;
        this.lcolumn = lcolumn;
        this.msg = msg;
    }

    public String toString() {
        return this.type + "\n" + this.path + "\n" + this.fline + " " + this.fcolumn + " " + this.lline + " " + this.lcolumn + this.msg + "\n";
    }
}

