/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Constants;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.system.EmptyTranslator;
import com.uppaal.model.system.Translator;
import com.uppaal.util.FloatPoint;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class FIGWriter
extends AbstractVisitor
implements Constants {
    private PrintWriter out;
    private String filename;
    private Translator translator;

    public FIGWriter(OutputStream stream, String filename) {
        this(stream, filename, new EmptyTranslator());
    }

    public FIGWriter(OutputStream stream, String filename, Translator aTranslator) {
        this.out = new PrintWriter(stream);
        this.filename = filename;
        this.translator = aTranslator;
    }

    private String getColor(Color color) {
        return String.format("#%2X%2X%2X", color.getRed(), color.getGreen(), color.getBlue());
    }

    private void generateHeader(String template) {
        this.out.print("#FIG 3.2\n# Process template: " + template + (this.filename.length() == 0 ? "" : " of " + this.filename) + "\n" + "# Generated by UPPAAL, see http://www.uppaal.com/\n" + "Landscape\n" + "Center\n" + "Metric\n" + "A4\n" + "100.00\n" + "Single\n" + "-3\n" + "75 2\n");
        this.out.print("0 32 " + this.getColor(STATE_FILL_COL) + "\n" + "0 33 " + this.getColor(STATE_LABEL_COL) + "\n" + "0 34 " + this.getColor(INVARIANT_COL) + "\n" + "0 35 " + this.getColor(GUARD_COL) + "\n" + "0 36 " + this.getColor(SYNC_COL) + "\n" + "0 37 " + this.getColor(ASSIGN_COL) + "\n");
    }

    private void generateFooter() throws IOException {
    }

    private void polyline(Point2D[] points) {
        this.print(2, 1, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, points.length);
        this.tab();
        this.print(0, 0, Float.valueOf(1.0f), Float.valueOf(7.5f), Float.valueOf(10.0f));
        this.tab();
        for (int i = 0; i < points.length; ++i) {
            this.out.print((int)points[i].getX() + " " + (int)points[i].getY() + " ");
        }
        this.out.print("\n");
    }

    protected FloatPoint getPos(Element element) {
        int x = (Integer)element.getPropertyValue("x");
        int y = (Integer)element.getPropertyValue("y");
        return new FloatPoint((float)x, (float)y);
    }

    private void tab() {
        this.out.print('\t');
    }

    private void print(Object ... arguments) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object o : arguments) {
            if (first) {
                first = false;
            } else {
                buffer.append(' ');
            }
            buffer.append(o.toString());
        }
        this.out.print(buffer.toString() + "\n");
    }

    private void circle(int pen_color, int fill_color, int area_fill, int center_x, int center_y, int radius) {
        this.print(1, 3, 0, 1, pen_color, fill_color, 0, 0, area_fill, 1, 1, 0, center_x, center_y, radius, radius, center_x, center_y, center_x + radius, center_y + radius);
    }

    private void arc(int pen_color, int center_x, int center_y) {
        this.print(5, 1, 0, 1, pen_color, -1, 0, 0, -1, 0, 0, 0, 0, 0, center_x, center_y, 0, 0, 0, 0, 0, 0);
    }

    private void text(int color, int font, int font_size, int x, int y, String text) {
        if (text.length() > 0) {
            this.print(4, 0, color, 0, 0, font, font_size, 0, 4, 0, 0, x, y, text + "\\001");
        }
    }

    private void label(Property property, int color, int font, int font_size) {
        int tail;
        int j = 0;
        int head = 0;
        String line = this.translator.translate(property.getValue().toString());
        int x = (Integer)property.getPropertyValue("x");
        int y = (Integer)property.getPropertyValue("y");
        while (line.substring(head).indexOf("\n") != -1) {
            tail = head + line.substring(head).indexOf("\n");
            this.text(color, font, font_size, x, y + j * 18 + 14, line.substring(head, tail));
            ++j;
            head = tail + 1;
        }
        tail = line.length();
        this.text(color, font, font_size, x, y + j * 18 + 14, line.substring(head, tail));
    }

    private void edge(Edge edge) {
        FloatPoint lastPos;
        FloatPoint firstPos;
        int length = 2;
        for (Node node = edge.getFirst(); node != null; node = node.getNext()) {
            ++length;
        }
        FloatPoint[] pathPoints = new FloatPoint[length];
        pathPoints[0] = firstPos = this.getPos(edge.getSource());
        Node node = edge.getFirst();
        int count = 1;
        while (node != null) {
            pathPoints[count] = this.getPos(node);
            node = node.getNext();
            ++count;
        }
        pathPoints[length - 1] = lastPos = this.getPos(edge.getTarget());
        FloatPoint secondPos = pathPoints[1];
        FloatPoint firstUnitVector = secondPos.subtract(firstPos).unitVector();
        FloatPoint newFirstPos = firstPos.add(firstUnitVector.multiply(12.0f));
        FloatPoint secLastPos = pathPoints[length - 2];
        FloatPoint lastUnitVector = lastPos.subtract(secLastPos).unitVector();
        FloatPoint newLastPos = lastPos.subtract(lastUnitVector.multiply(12.0f));
        pathPoints[0] = newFirstPos;
        pathPoints[length - 1] = newLastPos;
        this.polyline((Point2D[])pathPoints);
    }

    public void visitTemplate(Template template) throws Exception {
        this.generateHeader(template.getPropertyValue("name").toString());
        template.accept(new AbstractVisitor(){

            public void visitLocation(Location location) throws Exception {
                FIGWriter.this.visitLocation(location);
            }
        });
        template.accept(new AbstractVisitor(){

            public void visitEdge(Edge edge) throws Exception {
                FIGWriter.this.visitEdge(edge);
            }
        });
        this.generateFooter();
        this.out.flush();
    }

    public void visitLocation(Location location) throws Exception {
        int x = (Integer)location.getPropertyValue("x");
        int y = (Integer)location.getPropertyValue("y");
        this.circle(0, 32, 20, x, y, 12);
        if (location.hasFlag("init")) {
            this.circle(0, 20, -1, x, y, 8);
        }
        this.label(location.getProperty("name"), 0, 2, 14);
        this.label(location.getProperty("invariant"), 0, 2, 14);
    }

    public void visitEdge(Edge edge) throws Exception {
        this.edge(edge);
        this.label(edge.getProperty("guard"), 0, 0, 14);
        this.label(edge.getProperty("synchronisation"), 0, 0, 14);
        this.label(edge.getProperty("assignment"), 0, 0, 14);
    }
}

