/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.LayoutVisitor;
import com.uppaal.model.core2.Constants;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.io2.UGIReader;
import com.uppaal.model.io2.XMLReader;
import com.uppaal.model.io2.XTAReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public class PrototypeDocument
extends Element
implements Constants {
    public PrototypeDocument() {
        super(null);
        Object[] properties = new Object[]{"#template", new Element(null), "declaration", "", "declaration:errors", new Vector(), "system", "", "system:errors", new Vector(), "#template/name", "", "#template/name:errors", new Vector(), "#template/parameter", "", "#template/parameter:errors", new Vector(), "#template/declaration", "", "#template/declaration:errors", new Vector(), "#template/#location", new Element(null), "#template/#location/name", "", "#template/#location/name:x", 0, "#template/#location/name:y", 0, "#template/#location/name:errors", new Vector(), "#template/#location/invariant", "", "#template/#location/invariant:x", 0, "#template/#location/invariant:y", 0, "#template/#location/invariant:errors", new Vector(), "#template/#location/documentation", "", "#template/#location/init", false, "#template/#location/committed", false, "#template/#location/urgent", false, "#template/#location/winning", false, "#template/#location/losing", false, "#template/#location/x", 0, "#template/#location/y", 0, "#template/#edge", new Element(null), "#template/#edge/select", "", "#template/#edge/select:x", 0, "#template/#edge/select:y", 0, "#template/#edge/select:errors", new Vector(), "#template/#edge/guard", "", "#template/#edge/guard:x", 0, "#template/#edge/guard:y", 0, "#template/#edge/guard:errors", new Vector(), "#template/#edge/synchronisation", "", "#template/#edge/synchronisation:x", 0, "#template/#edge/synchronisation:y", 0, "#template/#edge/synchronisation:errors", new Vector(), "#template/#edge/assignment", "", "#template/#edge/assignment:x", 0, "#template/#edge/assignment:y", 0, "#template/#edge/assignment:errors", new Vector(), "#template/#edge/documentation", "", "#template/#edge/controllable", true, "#template/#edge/#nail", new Element(null), "#template/#edge/#nail/x", 0, "#template/#edge/#nail/y", 0, "#template/#location/name:color", STATE_LABEL_COL, "#template/#location/name:font", FONT, "#template/#location/invariant:color", INVARIANT_COL, "#template/#location/invariant:font", FONT, "#template/#edge/select:color", SELECT_COL, "#template/#edge/select:font", FONT, "#template/#edge/guard:color", GUARD_COL, "#template/#edge/guard:font", FONT, "#template/#edge/synchronisation:color", SYNC_COL, "#template/#edge/synchronisation:font", FONT, "#template/#edge/assignment:color", ASSIGN_COL, "#template/#edge/assignment:font", FONT};
        this.setProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document load(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            String s = url.toString().toLowerCase();
            if (s.endsWith(".xml")) {
                Document document = new XMLReader(stream).parse(this);
                return document;
            }
            if (s.endsWith(".xta") || s.endsWith(".ta")) {
                Document document = new XTAReader(stream).parse(this);
                try {
                    String gfxUri = url.toString().replaceFirst("\\....?$", ".ugi");
                    InputStream gfxStream = new URL(gfxUri).openStream();
                    try {
                        UGIReader ugiReader = new UGIReader(gfxStream);
                        ugiReader.parse(document);
                    }
                    finally {
                        gfxStream.close();
                    }
                }
                catch (FileNotFoundException e) {
                    document.acceptSafe(new LayoutVisitor());
                }
                Document document2 = document;
                return document2;
            }
            try {
                throw new IOException("The file extension was not recognised. Only .xml, .xta and .ta files are supported.");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            stream.close();
        }
    }
}

