/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Visitor;

public class Edge
extends Node {
    protected Location source;
    protected Location target;

    public Edge(Element prototype) {
        super(prototype);
    }

    public Location getSource() {
        return this.source;
    }

    public Location getTarget() {
        return this.target;
    }

    public Nail getNails() {
        return (Nail)this.first;
    }

    public void setSource(Location source) {
        Location old = this.source;
        this.source = source;
        this.fireSourceChanged(old);
    }

    public void setTarget(Location target) {
        Location old = this.target;
        this.target = target;
        this.fireTargetChanged(old);
    }

    public Nail createNail() {
        return new Nail((Element)this.getPropertyValue("#nail"));
    }

    public void accept(Visitor visitor) throws Exception {
        visitor.visitEdge(this);
    }

    void fireSourceChanged(Location oldSource) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : element.listeners) {
                    l.edgeSourceChanged(this, oldSource, this.source);
                }
            } while ((element = element.prototype) != null);
        }
    }

    void fireTargetChanged(Location oldTarget) {
        if (this.getDocument() != null) {
            Element element = this;
            do {
                if (element.listeners == null) continue;
                for (EventListener l : element.listeners) {
                    l.edgeTargetChanged(this, oldTarget, this.target);
                }
            } while ((element = element.prototype) != null);
        }
    }

    protected Element getPrototypeFromParent(Element parent) {
        return (Element)parent.getPropertyValue("#edge");
    }
}

