/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.engine.Engine;
import com.uppaal.engine.ProtocolException;
import com.uppaal.gui.Main;
import com.uppaal.gui.ModePanel;
import com.uppaal.gui.SystemInspector;
import com.uppaal.gui.Tab;
import com.uppaal.gui.simulator.ChoiceModel;
import com.uppaal.gui.simulator.JMSCLog;
import com.uppaal.gui.simulator.PTDisplayPanel;
import com.uppaal.gui.simulator.TraceModel;
import com.uppaal.model.core2.Constants;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;
import com.uppaal.model.io2.PSWriter;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.Process;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.Transition;
import com.uppaal.model.system.Translator;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.util.ObservablePointer;
import com.uppaal.util.error.InfoError;
import com.uppaal.util.files.FileHandle;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.Timer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Simulator
extends Tab
implements Constants {
    private static String overwriteWarning = "Warning: this will destroy a part of the current trace! Continue?";
    private static final int DIST = 5;
    private SystemInspector inspector;
    private PTDisplayPanel[] processDisplayPanel;
    private JPanel mainArea;
    private ModePanel innerPanel;
    private JList choiceList;
    private JList variables;
    private JList traceList;
    private JTextField fileName;
    private JToggleButton randomButton;
    private JToggleButton replayButton;
    private JSlider slider;
    private Timer caller;
    private FileHandle traceFile;
    private FileHandle psFile;
    private boolean showFullDBM = false;
    private boolean[] visible;
    private int noOfProcesses;
    private ObservablePointer system;
    private SystemState currentState;
    private SystemState visibleState;
    private ChoiceModel choices;
    private UpdateThread updater;
    private boolean updated = true;
    private TraceModel trace;
    private boolean ignore = false;
    private Dimension oldDim;
    public AbstractAction viewProcessesAction = new n(this);
    public AbstractAction viewVariablesAction = new h(this);
    public AbstractAction viewFullDBMAction = new T(this);
    public AbstractAction selectPrevAction = new A(this);
    public AbstractAction selectNextAction = new ai(this);
    public AbstractAction stepAction = new W(this);
    public AbstractAction toggleAction = new ap(this);
    public AbstractAction prevAction = new ck(this);
    public AbstractAction nextAction = new cg(this);
    public AbstractAction firstAction = new b(this);
    public AbstractAction lastAction = new aw(this);
    public AbstractAction replayAction = new bg(this);
    public AbstractAction randomAction = new aT(this);
    public AbstractAction loadTraceAction = new bm(this);
    public AbstractAction saveTraceAction = new cs(this);

    public Simulator(SystemInspector systemInspector, ObservablePointer observablePointer) throws Exception {
        this.inspector = systemInspector;
        this.system = observablePointer;
        this.c(true);
        this.choices = new ChoiceModel(new Vector());
        this.updater = new UpdateThread();
        this.trace = new TraceModel();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPrev", this.selectPrevAction);
        actionMap.put("selectNext", this.selectNextAction);
        actionMap.put("step", this.stepAction);
        actionMap.put("toggle", this.toggleAction);
        actionMap.put("prev", this.prevAction);
        actionMap.put("next", this.nextAction);
        actionMap.put("first", this.firstAction);
        actionMap.put("last", this.lastAction);
        actionMap.put("replay", this.replayAction);
        actionMap.put("random", this.randomAction);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("Z"), "selectPrev");
        inputMap.put(KeyStroke.getKeyStroke("X"), "selectNext");
        inputMap.put(KeyStroke.getKeyStroke("Q"), "prev");
        inputMap.put(KeyStroke.getKeyStroke("A"), "next");
        inputMap.put(KeyStroke.getKeyStroke("P"), "replay");
        inputMap.put(KeyStroke.getKeyStroke("R"), "random");
        inputMap.put(KeyStroke.getKeyStroke("F"), "first");
        inputMap.put(KeyStroke.getKeyStroke("L"), "last");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "step");
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "toggle");
        bb bb2 = new bb(this);
        bb2.insert("xml/Simulator.xml", this);
        ((JSplitPane)bb2.find("mainSplit")).setRightComponent(new JMSCLog(this.system, this.trace, this.traceList.getSelectionModel()));
        JScrollPane jScrollPane = (JScrollPane)bb2.find("scrollPane");
        jScrollPane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(32);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(32);
        this.mainArea.setBackground(PROCESS_FILL_COL);
        this.mainArea.setLayout(new V(0, 5, 5));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(60, new JLabel("Fast", 4));
        ((Dictionary)hashtable).put(120, new JLabel("Slow", 2));
        this.slider.setLabelTable(hashtable);
        z z2 = new z(this);
        this.traceList.setCellRenderer(z2);
        this.traceList.setFixedCellHeight(z2.getPreferredSize().height);
        this.traceList.setModel(this.trace);
        this.psFile = new FileHandle(this.inspector);
        this.psFile.a("eps", "Encapsulated PS File", true);
        this.traceFile = new FileHandle(this.inspector);
        this.traceFile.a("xtr", "UPPAAL Trace File", true);
        this.system.addObserver(new bw(this));
        this.choiceList.addListSelectionListener(new bl(this));
        this.choiceList.addMouseListener(new ba(this));
        this.traceList.addListSelectionListener(new bV(this));
        this.slider.addChangeListener(new dd(this));
        this.e();
    }

    private UppaalSystem a() {
        return (UppaalSystem)this.system.a;
    }

    public final void a(String string) {
        int n2 = this.a().getProcessIndex(string);
        if (n2 > -1) {
            this.processDisplayPanel[n2].setVisible(false);
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    public final void a(Vector vector, int n2) {
        this.trace.a(vector, n2);
        this.a(this.trace.a());
        this.b(this.a());
    }

    public final void b() {
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            this.processDisplayPanel[i2].a();
        }
        this.mainArea.revalidate();
    }

    public final void c() {
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            this.processDisplayPanel[i2].b();
        }
        this.mainArea.revalidate();
    }

    public final void a(double d2) {
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            this.processDisplayPanel[i2].a(d2);
        }
        this.mainArea.revalidate();
    }

    public final double[] a() {
        if (this.processDisplayPanel != null) {
            double[] dArray = new double[this.processDisplayPanel.length];
            for (int i2 = 0; i2 < this.processDisplayPanel.length; ++i2) {
                dArray[i2] = this.processDisplayPanel[i2].a();
            }
            return dArray;
        }
        return null;
    }

    public final void a(Template template, Translator translator) {
        if (this.psFile.a("Save Postscript", "eps")) {
            try {
                FileOutputStream fileOutputStream = this.psFile.a();
                template.accept((Visitor)new PSWriter((OutputStream)fileOutputStream, "", Main.exportColors, translator));
                ((OutputStream)fileOutputStream).close();
                return;
            }
            catch (Exception exception) {
                Main.infoError.a("Error Saving Templates as Postscript: " + exception.getMessage());
            }
        }
    }

    private void d() {
        int n2;
        String[] stringArray = new String[this.noOfProcesses];
        boolean[] blArray = new boolean[this.noOfProcesses];
        for (n2 = 0; n2 < this.noOfProcesses; ++n2) {
            stringArray[n2] = this.a().getProcess(n2).getName();
            blArray[n2] = this.processDisplayPanel[n2].isVisible();
        }
        if (bt.a(this.inspector, "Visible Processes", stringArray, blArray)) {
            for (n2 = 0; n2 < this.noOfProcesses; ++n2) {
                this.processDisplayPanel[n2].setVisible(blArray[n2]);
            }
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    private boolean[] a() {
        if (this.processDisplayPanel != null) {
            boolean[] blArray = new boolean[this.noOfProcesses];
            for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
                blArray[i2] = this.processDisplayPanel[i2].isVisible();
            }
            return blArray;
        }
        return null;
    }

    private void e() {
        double[] dArray = this.a();
        boolean[] blArray = this.a();
        UppaalSystem uppaalSystem = this.a();
        this.trace.a((SystemState)null);
        this.traceList.clearSelection();
        this.i();
        this.mainArea.removeAll();
        this.viewVariablesAction.setEnabled(uppaalSystem != null);
        this.viewFullDBMAction.setEnabled(uppaalSystem != null);
        this.viewProcessesAction.setEnabled(uppaalSystem != null);
        if (uppaalSystem != null) {
            int n2;
            this.noOfProcesses = uppaalSystem.getNoOfProcesses();
            this.processDisplayPanel = new PTDisplayPanel[this.noOfProcesses];
            for (n2 = 0; n2 < this.noOfProcesses; ++n2) {
                Process process = uppaalSystem.getProcess(n2);
                this.processDisplayPanel[n2] = new PTDisplayPanel(this, process.getName(), process.getTranslator());
                this.mainArea.add(this.processDisplayPanel[n2]);
                this.processDisplayPanel[n2].a(process.getTemplate());
            }
            n2 = uppaalSystem.getNoOfVariables();
            if (this.visible == null || n2 != this.visible.length) {
                this.visible = new boolean[n2];
            }
            while (n2-- > 0) {
                this.visible[n2] = true;
            }
            EventQueue.invokeLater(new dI(this, uppaalSystem));
        } else {
            this.noOfProcesses = 0;
            this.processDisplayPanel = null;
            this.visible = null;
        }
        this.loadTraceAction.setEnabled(uppaalSystem != null);
        this.saveTraceAction.setEnabled(uppaalSystem != null);
        if (this.a()) {
            this.a(0.75);
            this.mainArea.scrollRectToVisible(new Rectangle());
        } else {
            if (dArray != null) {
                this.a(dArray);
            }
            if (blArray != null) {
                this.a(blArray);
            }
            this.mainArea.revalidate();
        }
        this.repaint();
    }

    private void a(boolean[] blArray) {
        if (blArray.length == this.processDisplayPanel.length) {
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                this.processDisplayPanel[i2].setVisible(blArray[i2]);
            }
        }
    }

    private void a(double[] dArray) {
        if (dArray.length == this.processDisplayPanel.length) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.processDisplayPanel[i2].a(dArray[i2]);
            }
        }
    }

    private boolean a() {
        boolean bl2;
        block1: {
            boolean bl3;
            block2: {
                block0: {
                    bl2 = false;
                    if (this.oldDim == null) break block0;
                    if (this.oldDim.equals(this.mainArea.getPreferredSize())) break block1;
                    bl3 = true;
                    break block2;
                }
                bl3 = false;
            }
            bl2 = bl3;
        }
        this.oldDim = this.mainArea.getPreferredSize();
        return bl2;
    }

    private Transition a() {
        int n2 = this.choiceList.getSelectedIndex();
        if (n2 >= 0 && n2 < this.choices.getSize()) {
            return this.choices.a(n2);
        }
        return null;
    }

    private SystemState a() {
        int n2 = this.a();
        if (n2 >= 0 && n2 < this.trace.getSize()) {
            if (TraceModel.b(n2)) {
                --n2;
            }
            return (SystemState)this.trace.getElementAt(n2);
        }
        return null;
    }

    private void a(SystemState systemState) {
        this.visibleState = systemState;
        if (systemState != null) {
            SystemLocation[] systemLocationArray = systemState.getLocationVector();
            for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
                this.processDisplayPanel[i2].a(systemLocationArray[i2].getLocation());
            }
        } else {
            for (int i3 = 0; i3 < this.noOfProcesses; ++i3) {
                this.processDisplayPanel[i3].a((Location)null);
            }
        }
        this.g();
    }

    private void b(SystemState systemState) {
        if (this.currentState != systemState) {
            this.currentState = systemState;
            this.a(new Vector());
            if (systemState != null) {
                this.updated = false;
                this.updater.a();
                return;
            }
            this.updated = true;
            return;
        }
        this.f();
    }

    private void f() {
        int n2 = this.a();
        if (n2 >= 0 && n2 < this.trace.getSize() && this.updated) {
            if (this.trace.d(n2)) {
                n2 = (int)((double)this.choices.getSize() * Math.random());
            } else if (!TraceModel.a(n2)) {
                n2 = this.choices.a(this.trace.a(n2));
            } else {
                this.choiceList.clearSelection();
                return;
            }
            if (n2 >= 0 && n2 < this.choices.getSize()) {
                this.choiceList.setSelectedIndex(n2);
                this.choiceList.ensureIndexIsVisible(n2);
                this.choiceList.revalidate();
            }
        }
    }

    private void a(Vector vector) {
        this.choices = new ChoiceModel(vector);
        this.choiceList.clearSelection();
        this.choiceList.setModel(this.choices);
    }

    private void g() {
        Vector<String> vector = new Vector<String>();
        if (this.visibleState != null) {
            int[] nArray = this.visibleState.getVariables();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (this.visible != null && !this.visible[i2]) continue;
                vector.add(this.a().getVariableName(i2) + " = " + nArray[i2]);
            }
            Polyhedron polyhedron = this.visibleState.getPolyhedron();
            if (this.showFullDBM) {
                polyhedron.getAllConstraints(vector);
            } else {
                polyhedron.getSufficientConstraints(vector);
            }
        }
        this.variables.setListData(vector);
    }

    private void h() {
        int n2 = this.a().getNoOfVariables();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.a().getVariableName(i2);
        }
        if (bt.a((Frame)this.getTopLevelAncestor(), "Visible Variables", stringArray, this.visible)) {
            this.g();
        }
    }

    private boolean a(Transition transition) {
        int n2 = this.a();
        if (n2 >= 0 && !this.trace.d(n2) && !Main.choiceError.a(overwriteWarning)) {
            return false;
        }
        if (TraceModel.b(n2)) {
            --n2;
        }
        this.ignore = true;
        this.trace.a(n2, transition);
        this.ignore = false;
        this.a(this.trace.a());
        return true;
    }

    private int a() {
        return this.traceList.getSelectedIndex();
    }

    private void a(int n2) {
        this.traceList.setSelectedIndex(n2);
        this.traceList.ensureIndexIsVisible(n2);
        this.traceList.revalidate();
        this.i();
    }

    private void i() {
        int n2 = this.a();
        this.prevAction.setEnabled(n2 > 0 && this.caller == null);
        this.nextAction.setEnabled(!this.trace.d(n2) && this.caller == null);
    }

    private int b() {
        return (int)Math.pow(2.0, (double)this.slider.getValue() / 10.0);
    }

    private void j() {
        String string;
        InfoError infoError;
        try {
            if (this.traceFile.a("Open Trace File")) {
                this.fileName.setText(this.traceFile.c());
                FileInputStream fileInputStream = this.traceFile.a();
                if (fileInputStream == null) {
                    throw new FileNotFoundException();
                }
                this.trace.a(this.a(), fileInputStream);
                ((InputStream)fileInputStream).close();
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            infoError = Main.infoError;
            string = "Could not open file " + this.traceFile.c();
        }
        catch (IOException iOException) {
            infoError = Main.infoError;
            string = "IO Exception";
        }
        catch (ProtocolException protocolException) {
            infoError = Main.infoError;
            string = "This is not a valid trace file";
        }
        infoError.a(string);
    }

    private void m() {
        String string;
        StringBuilder stringBuilder;
        InfoError infoError;
        try {
            if (this.traceFile.a("Save Trace File", "xtr")) {
                this.fileName.setText(this.traceFile.c());
                FileOutputStream fileOutputStream = this.traceFile.a();
                if (fileOutputStream == null) {
                    Main.infoError.a("there is no file where I can save this");
                    return;
                }
                this.trace.a(fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            infoError = Main.infoError;
            stringBuilder = new StringBuilder().append("File not found:");
            string = fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            infoError = Main.infoError;
            stringBuilder = new StringBuilder().append("IOException:");
            string = iOException.getMessage();
        }
        infoError.a(stringBuilder.append(string).toString());
    }

    private void n() {
        if (this.caller == null) {
            this.replayAction.setEnabled(true);
            this.randomAction.setEnabled(false);
            this.loadTraceAction.setEnabled(false);
            this.saveTraceAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.inspector.verifier.setEnabled(false);
            this.caller = new Timer(this.b(), new cT(this, null));
            this.caller.start();
            this.replayButton.setSelected(true);
        }
    }

    private void o() {
        if (this.caller == null) {
            int n2 = this.b();
            this.replayAction.setEnabled(false);
            this.randomAction.setEnabled(true);
            this.loadTraceAction.setEnabled(false);
            this.saveTraceAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.inspector.verifier.setEnabled(false);
            this.caller = new Timer(n2, new bS(this, null));
            this.caller.start();
            this.randomButton.setSelected(true);
        }
    }

    private void p() {
        if (this.caller != null) {
            this.caller.stop();
            this.caller = null;
            this.stepAction.setEnabled(this.a() != null);
            this.inspector.verifier.setEnabled(true);
            this.randomAction.setEnabled(true);
            this.replayAction.setEnabled(true);
            this.loadTraceAction.setEnabled(this.system != null);
            this.saveTraceAction.setEnabled(this.a() != null);
            this.replayButton.setSelected(false);
            this.randomButton.setSelected(false);
            this.i();
        }
    }

    public final void k() {
        this.viewProcessesAction.setEnabled(true);
        this.viewVariablesAction.setEnabled(true);
        this.viewFullDBMAction.setEnabled(true);
    }

    public final void l() {
        this.viewProcessesAction.setEnabled(false);
        this.viewVariablesAction.setEnabled(false);
        this.viewFullDBMAction.setEnabled(false);
    }

    public static /* synthetic */ void a(Simulator simulator) {
        simulator.d();
    }

    public static /* synthetic */ void b(Simulator simulator) {
        simulator.h();
    }

    public static /* synthetic */ boolean a(Simulator simulator, boolean bl2) {
        simulator.showFullDBM = bl2;
        return simulator.showFullDBM;
    }

    public static /* synthetic */ boolean a(Simulator simulator) {
        return simulator.showFullDBM;
    }

    public static /* synthetic */ void c(Simulator simulator) {
        simulator.g();
    }

    public static /* synthetic */ JList a(Simulator simulator) {
        return simulator.choiceList;
    }

    public static /* synthetic */ ChoiceModel a(Simulator simulator) {
        return simulator.choices;
    }

    public static /* synthetic */ Transition a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ boolean a(Simulator simulator, Transition transition) {
        return simulator.a(transition);
    }

    public static /* synthetic */ int a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ TraceModel a(Simulator simulator) {
        return simulator.trace;
    }

    public static /* synthetic */ void a(Simulator simulator, int n2) {
        simulator.a(n2);
    }

    public static /* synthetic */ Timer a(Simulator simulator) {
        return simulator.caller;
    }

    public static /* synthetic */ void d(Simulator simulator) {
        simulator.n();
    }

    public static /* synthetic */ void e(Simulator simulator) {
        simulator.p();
    }

    public static /* synthetic */ void f(Simulator simulator) {
        simulator.o();
    }

    public static /* synthetic */ void g(Simulator simulator) {
        simulator.j();
    }

    public static /* synthetic */ void h(Simulator simulator) {
        simulator.m();
    }

    public static /* synthetic */ void i(Simulator simulator) {
        simulator.e();
    }

    public static /* synthetic */ int b(Simulator simulator) {
        return simulator.noOfProcesses;
    }

    public static /* synthetic */ PTDisplayPanel[] a(Simulator simulator) {
        return simulator.processDisplayPanel;
    }

    public static /* synthetic */ void a(Simulator simulator, SystemState systemState) {
        simulator.a(systemState);
    }

    public static /* synthetic */ JList b(Simulator simulator) {
        return simulator.variables;
    }

    public static /* synthetic */ boolean b(Simulator simulator) {
        return simulator.ignore;
    }

    public static /* synthetic */ SystemState b(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ void b(Simulator simulator, SystemState systemState) {
        simulator.b(systemState);
    }

    public static /* synthetic */ void j(Simulator simulator) {
        simulator.i();
    }

    public static /* synthetic */ int c(Simulator simulator) {
        return simulator.b();
    }

    public static /* synthetic */ boolean c(Simulator simulator) {
        return simulator.updated;
    }

    public static /* synthetic */ boolean b(Simulator simulator, boolean bl2) {
        simulator.updated = bl2;
        return simulator.updated;
    }

    public static /* synthetic */ void a(Simulator simulator, Vector vector) {
        simulator.a(vector);
    }

    public static /* synthetic */ void k(Simulator simulator) {
        simulator.f();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class UpdateThread
    extends Thread {
        private boolean a = false;

        public UpdateThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public final void run() {
            try {
                while (true) {
                    UpdateThread updateThread = this;
                    // MONITORENTER : updateThread
                    while (!this.a) {
                        this.wait();
                    }
                    this.a = false;
                    SystemState systemState = Simulator.this.currentState;
                    // MONITOREXIT : updateThread
                    updateThread = ((Simulator)Simulator.this).inspector.engine;
                    Engine engine = updateThread;
                    // MONITORENTER : updateThread
                    try {
                        Vector vector = updateThread.getTransitions((UppaalSystem)((Simulator)Simulator.this).system.a, systemState);
                        SystemState systemState2 = systemState;
                        EventQueue.invokeLater(new aa(this, systemState2, vector));
                    }
                    catch (Exception exception) {
                        EventQueue.invokeLater(new ah(this, exception));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public final synchronized void a() {
            this.a = true;
            this.notify();
        }
    }
}

