/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.engine.Engine;
import com.uppaal.gui.Main;
import com.uppaal.gui.ModePanel;
import com.uppaal.gui.SystemInspector;
import com.uppaal.gui.Tab;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.simulator.ChoiceModel;
import com.uppaal.gui.simulator.JMSCLog;
import com.uppaal.gui.simulator.PTDisplayPanel;
import com.uppaal.gui.simulator.TraceModel;
import com.uppaal.model.system.SystemState;
import com.uppaal.util.ObservablePointer;
import com.uppaal.util.error.InfoError;
import com.uppaal.util.files.FileHandle;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.Timer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Simulator
extends Tab {
    private static String overwriteWarning = "Warning: this will destroy a part of the current trace! Continue?";
    private static final int DIST = 5;
    private SystemInspector inspector;
    private PTDisplayPanel[] processDisplayPanel;
    private JPanel mainArea;
    private ModePanel innerPanel;
    private JList choiceList;
    private JList variables;
    private JList traceList;
    private JTextField fileName;
    private JToggleButton randomButton;
    private JToggleButton replayButton;
    private JSlider slider;
    private Timer caller;
    private FileHandle traceFile;
    private FileHandle psFile;
    private boolean showFullDBM = false;
    private boolean[] visible;
    private int noOfProcesses;
    private ObservablePointer system;
    private SystemState currentState;
    private SystemState visibleState;
    private ChoiceModel choices;
    private UpdateThread updater;
    private boolean updated = true;
    private TraceModel trace;
    private boolean ignore = false;
    public AbstractAction viewProcessesAction = new df(this);
    public AbstractAction viewVariablesAction = new h(this);
    public AbstractAction viewFullDBMAction = new dB(this);
    public AbstractAction selectPrevAction = new x(this);
    public AbstractAction selectNextAction = new dI(this);
    public AbstractAction stepAction = new P(this);
    public AbstractAction toggleAction = new dO(this);
    public AbstractAction prevAction = new bK(this);
    public AbstractAction nextAction = new fm(this);
    public AbstractAction firstAction = new cW(this);
    public AbstractAction lastAction = new ai(this);
    public AbstractAction replayAction = new ev(this);
    public AbstractAction randomAction = new aD(this);
    public AbstractAction loadTraceAction = new eC(this);
    public AbstractAction saveTraceAction = new fy(this);

    public Simulator(SystemInspector systemInspector, ObservablePointer observablePointer) throws Exception {
        this.inspector = systemInspector;
        this.system = observablePointer;
        this.a(true);
        this.choices = new ChoiceModel(new Vector());
        this.updater = new UpdateThread();
        this.trace = new TraceModel();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPrev", this.selectPrevAction);
        actionMap.put("selectNext", this.selectNextAction);
        actionMap.put("step", this.stepAction);
        actionMap.put("toggle", this.toggleAction);
        actionMap.put("prev", this.prevAction);
        actionMap.put("next", this.nextAction);
        actionMap.put("first", this.firstAction);
        actionMap.put("last", this.lastAction);
        actionMap.put("replay", this.replayAction);
        actionMap.put("random", this.randomAction);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("Z"), "selectPrev");
        inputMap.put(KeyStroke.getKeyStroke("X"), "selectNext");
        inputMap.put(KeyStroke.getKeyStroke("Q"), "prev");
        inputMap.put(KeyStroke.getKeyStroke("A"), "next");
        inputMap.put(KeyStroke.getKeyStroke("P"), "replay");
        inputMap.put(KeyStroke.getKeyStroke("R"), "random");
        inputMap.put(KeyStroke.getKeyStroke("F"), "first");
        inputMap.put(KeyStroke.getKeyStroke("L"), "last");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "step");
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "toggle");
        eq eq2 = new eq(this);
        eq2.insert("xml/Simulator.xml", this);
        ((JSplitPane)eq2.find("mainSplit")).setRightComponent(new JMSCLog(this.system, this.trace, this.traceList.getSelectionModel()));
        JScrollPane jScrollPane = (JScrollPane)eq2.find("scrollPane");
        jScrollPane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(32);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(32);
        this.mainArea.setBackground(GraphicsElement.PROCESS_FILL_COL);
        this.mainArea.setLayout(new O(0, 5, 5));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(60, new JLabel("Fast", 4));
        ((Dictionary)hashtable).put(120, new JLabel("Slow", 2));
        this.slider.setLabelTable(hashtable);
        dq dq2 = new dq(this);
        this.traceList.setCellRenderer(dq2);
        this.traceList.setFixedCellHeight(dq2.getPreferredSize().height);
        this.traceList.setModel(this.trace);
        this.psFile = new FileHandle(this.inspector);
        this.psFile.a("eps", "Encapsulated PS File", true);
        this.traceFile = new FileHandle(this.inspector);
        this.traceFile.a("xtr", "UPPAAL Trace File", true);
        this.system.addObserver(new eI(this));
        this.choiceList.addListSelectionListener(new aM(this));
        this.choiceList.addMouseListener(new ep(this));
        this.traceList.addListSelectionListener(new fc(this));
        this.slider.addChangeListener(new cu(this));
        this.g();
    }

    private da a() {
        return (da)this.system.a;
    }

    public final void a(String string) {
        int n2 = this.a().a(string);
        if (n2 > -1) {
            this.processDisplayPanel[n2].setVisible(false);
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    public final void a(Vector vector, int n2) {
        this.trace.a(vector, n2);
        this.a(this.trace.a());
        this.b(this.a());
    }

    public final void a() {
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            this.processDisplayPanel[i2].a();
        }
        this.mainArea.revalidate();
    }

    public final void b() {
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            this.processDisplayPanel[i2].b();
        }
        this.mainArea.revalidate();
    }

    public final void a(double d2) {
        for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
            this.processDisplayPanel[i2].a(d2);
        }
        this.mainArea.revalidate();
    }

    public final void a(fw fw2, gc gc2) {
        if (this.psFile.a("Save Postscript", "eps")) {
            try {
                FileOutputStream fileOutputStream = this.psFile.a();
                fw2.a(new cY(fileOutputStream, "", gc2));
                ((OutputStream)fileOutputStream).close();
                return;
            }
            catch (Exception exception) {
                Main.infoError.a("Error Saving Templates as Postscript: " + exception.getMessage());
            }
        }
    }

    private void f() {
        int n2;
        String[] stringArray = new String[this.noOfProcesses];
        boolean[] blArray = new boolean[this.noOfProcesses];
        for (n2 = 0; n2 < this.noOfProcesses; ++n2) {
            stringArray[n2] = this.a().a((int)n2).a;
            blArray[n2] = this.processDisplayPanel[n2].isVisible();
        }
        if (aW.a(this.inspector, "Visible Processes", stringArray, blArray)) {
            for (n2 = 0; n2 < this.noOfProcesses; ++n2) {
                this.processDisplayPanel[n2].setVisible(blArray[n2]);
            }
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    private void g() {
        da da2 = this.a();
        this.trace.a((SystemState)null);
        this.traceList.clearSelection();
        this.k();
        this.mainArea.removeAll();
        this.viewVariablesAction.setEnabled(da2 != null);
        this.viewFullDBMAction.setEnabled(da2 != null);
        this.viewProcessesAction.setEnabled(da2 != null);
        if (da2 != null) {
            int n2;
            this.noOfProcesses = da2.a();
            this.processDisplayPanel = new PTDisplayPanel[this.noOfProcesses];
            for (n2 = 0; n2 < this.noOfProcesses; ++n2) {
                bp bp2 = da2.a(n2);
                this.processDisplayPanel[n2] = new PTDisplayPanel(this, bp2.a, bp2.a);
                this.mainArea.add(this.processDisplayPanel[n2]);
                this.processDisplayPanel[n2].a(bp2.a);
            }
            n2 = da2.b();
            if (this.visible == null || n2 != this.visible.length) {
                this.visible = new boolean[n2];
            }
            while (n2-- > 0) {
                this.visible[n2] = true;
            }
            EventQueue.invokeLater(new gv(this, da2));
        } else {
            this.noOfProcesses = 0;
            this.processDisplayPanel = null;
            this.visible = null;
        }
        this.a(0.75);
        this.repaint();
    }

    private cQ a() {
        int n2 = this.choiceList.getSelectedIndex();
        if (n2 >= 0 && n2 < this.choices.getSize()) {
            return this.choices.a(n2);
        }
        return null;
    }

    private SystemState a() {
        int n2 = this.a();
        if (n2 >= 0 && n2 < this.trace.getSize()) {
            if (TraceModel.b(n2)) {
                --n2;
            }
            return (SystemState)this.trace.getElementAt(n2);
        }
        return null;
    }

    private void a(SystemState systemState) {
        this.visibleState = systemState;
        if (systemState != null) {
            bk[] bkArray = systemState.a;
            for (int i2 = 0; i2 < this.noOfProcesses; ++i2) {
                this.processDisplayPanel[i2].a(bkArray[i2].a);
            }
        } else {
            for (int i3 = 0; i3 < this.noOfProcesses; ++i3) {
                this.processDisplayPanel[i3].a((aj)null);
            }
        }
        this.i();
    }

    private void b(SystemState systemState) {
        if (this.currentState != systemState) {
            this.currentState = systemState;
            this.a(new Vector());
            if (systemState != null) {
                this.updated = false;
                this.updater.a();
                return;
            }
            this.updated = true;
            return;
        }
        this.h();
    }

    private void h() {
        int n2 = this.a();
        if (n2 >= 0 && n2 < this.trace.getSize() && this.updated) {
            if (this.trace.d(n2)) {
                n2 = (int)((double)this.choices.getSize() * Math.random());
            } else if (!TraceModel.a(n2)) {
                n2 = this.choices.a(this.trace.a(n2));
            } else {
                this.choiceList.clearSelection();
                return;
            }
            if (n2 >= 0 && n2 < this.choices.getSize()) {
                this.choiceList.setSelectedIndex(n2);
                this.choiceList.ensureIndexIsVisible(n2);
                this.choiceList.revalidate();
            }
        }
    }

    private void a(Vector vector) {
        this.choices = new ChoiceModel(vector);
        this.choiceList.clearSelection();
        this.choiceList.setModel(this.choices);
    }

    private void i() {
        Vector<String> vector = new Vector<String>();
        if (this.visibleState != null) {
            int[] nArray = this.visibleState.a;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (this.visible != null && !this.visible[i2]) continue;
                vector.add(this.a().a(i2) + " = " + nArray[i2]);
            }
            gr gr2 = this.visibleState.a;
            if (this.showFullDBM) {
                gr2.a(vector);
            } else {
                gr2.b(vector);
            }
        }
        this.variables.setListData(vector);
    }

    private void j() {
        int n2 = this.a().b();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.a().a(i2);
        }
        if (aW.a((Frame)this.getTopLevelAncestor(), "Visible Variables", stringArray, this.visible)) {
            this.i();
        }
    }

    private boolean a(cQ cQ2) {
        int n2 = this.a();
        if (n2 >= 0 && !this.trace.d(n2) && !Main.choiceError.a(overwriteWarning)) {
            return false;
        }
        if (TraceModel.b(n2)) {
            --n2;
        }
        this.ignore = true;
        this.trace.a(n2, cQ2);
        this.ignore = false;
        this.a(this.trace.a());
        return true;
    }

    private int a() {
        return this.traceList.getSelectedIndex();
    }

    private void a(int n2) {
        this.traceList.setSelectedIndex(n2);
        this.traceList.ensureIndexIsVisible(n2);
        this.traceList.revalidate();
        this.k();
    }

    private void k() {
        int n2 = this.a();
        this.prevAction.setEnabled(n2 > 0 && this.caller == null);
        this.nextAction.setEnabled(!this.trace.d(n2) && this.caller == null);
    }

    private int b() {
        return (int)Math.pow(2.0, (double)this.slider.getValue() / 10.0);
    }

    private void l() {
        String string;
        InfoError infoError;
        try {
            if (this.traceFile.a("Open Trace File")) {
                this.fileName.setText(this.traceFile.c());
                FileInputStream fileInputStream = this.traceFile.a();
                if (fileInputStream == null) {
                    throw new FileNotFoundException();
                }
                this.trace.a(this.a(), fileInputStream);
                ((InputStream)fileInputStream).close();
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            infoError = Main.infoError;
            string = "Could not open file " + this.traceFile.c();
        }
        catch (IOException iOException) {
            infoError = Main.infoError;
            string = "IO Exception";
        }
        catch (cr cr2) {
            infoError = Main.infoError;
            string = "This is not a valid trace file";
        }
        infoError.a(string);
    }

    private void m() {
        String string;
        StringBuilder stringBuilder;
        InfoError infoError;
        try {
            if (this.traceFile.a("Save Trace File", "xtr")) {
                this.fileName.setText(this.traceFile.c());
                FileOutputStream fileOutputStream = this.traceFile.a();
                if (fileOutputStream == null) {
                    Main.infoError.a("there is no file where I can save this");
                    return;
                }
                this.trace.a(fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            infoError = Main.infoError;
            stringBuilder = new StringBuilder().append("File not found:");
            string = fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            infoError = Main.infoError;
            stringBuilder = new StringBuilder().append("IOException:");
            string = iOException.getMessage();
        }
        infoError.a(stringBuilder.append(string).toString());
    }

    private void n() {
        if (this.caller == null) {
            this.replayAction.setEnabled(true);
            this.randomAction.setEnabled(false);
            this.loadTraceAction.setEnabled(false);
            this.saveTraceAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.inspector.verifier.setEnabled(false);
            this.caller = new Timer(this.b(), new fM(this, null));
            this.caller.start();
            this.replayButton.setSelected(true);
        }
    }

    private void o() {
        if (this.caller == null) {
            int n2 = this.b();
            this.replayAction.setEnabled(false);
            this.randomAction.setEnabled(true);
            this.loadTraceAction.setEnabled(false);
            this.saveTraceAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.inspector.verifier.setEnabled(false);
            this.caller = new Timer(n2, new by(this, null));
            this.caller.start();
            this.randomButton.setSelected(true);
        }
    }

    private void p() {
        if (this.caller != null) {
            this.caller.stop();
            this.caller = null;
            this.stepAction.setEnabled(this.a() != null);
            this.inspector.verifier.setEnabled(true);
            this.randomAction.setEnabled(true);
            this.replayAction.setEnabled(true);
            this.loadTraceAction.setEnabled(true);
            this.saveTraceAction.setEnabled(true);
            this.replayButton.setSelected(false);
            this.randomButton.setSelected(false);
            this.k();
        }
    }

    public final void c() {
        this.viewProcessesAction.setEnabled(true);
        this.viewVariablesAction.setEnabled(true);
        this.viewFullDBMAction.setEnabled(true);
    }

    public final void d() {
        this.viewProcessesAction.setEnabled(false);
        this.viewVariablesAction.setEnabled(false);
        this.viewFullDBMAction.setEnabled(false);
    }

    public static /* synthetic */ void a(Simulator simulator) {
        simulator.f();
    }

    public static /* synthetic */ void b(Simulator simulator) {
        simulator.j();
    }

    public static /* synthetic */ boolean a(Simulator simulator, boolean bl2) {
        simulator.showFullDBM = bl2;
        return simulator.showFullDBM;
    }

    public static /* synthetic */ boolean a(Simulator simulator) {
        return simulator.showFullDBM;
    }

    public static /* synthetic */ void c(Simulator simulator) {
        simulator.i();
    }

    public static /* synthetic */ JList a(Simulator simulator) {
        return simulator.choiceList;
    }

    public static /* synthetic */ ChoiceModel a(Simulator simulator) {
        return simulator.choices;
    }

    public static /* synthetic */ cQ a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ boolean a(Simulator simulator, cQ cQ2) {
        return simulator.a(cQ2);
    }

    public static /* synthetic */ int a(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ TraceModel a(Simulator simulator) {
        return simulator.trace;
    }

    public static /* synthetic */ void a(Simulator simulator, int n2) {
        simulator.a(n2);
    }

    public static /* synthetic */ Timer a(Simulator simulator) {
        return simulator.caller;
    }

    public static /* synthetic */ void d(Simulator simulator) {
        simulator.n();
    }

    public static /* synthetic */ void e(Simulator simulator) {
        simulator.p();
    }

    public static /* synthetic */ void f(Simulator simulator) {
        simulator.o();
    }

    public static /* synthetic */ void g(Simulator simulator) {
        simulator.l();
    }

    public static /* synthetic */ void h(Simulator simulator) {
        simulator.m();
    }

    public static /* synthetic */ void i(Simulator simulator) {
        simulator.g();
    }

    public static /* synthetic */ int b(Simulator simulator) {
        return simulator.noOfProcesses;
    }

    public static /* synthetic */ PTDisplayPanel[] a(Simulator simulator) {
        return simulator.processDisplayPanel;
    }

    public static /* synthetic */ void a(Simulator simulator, SystemState systemState) {
        simulator.a(systemState);
    }

    public static /* synthetic */ JList b(Simulator simulator) {
        return simulator.variables;
    }

    public static /* synthetic */ boolean b(Simulator simulator) {
        return simulator.ignore;
    }

    public static /* synthetic */ SystemState b(Simulator simulator) {
        return simulator.a();
    }

    public static /* synthetic */ void b(Simulator simulator, SystemState systemState) {
        simulator.b(systemState);
    }

    public static /* synthetic */ void j(Simulator simulator) {
        simulator.k();
    }

    public static /* synthetic */ int c(Simulator simulator) {
        return simulator.b();
    }

    public static /* synthetic */ boolean c(Simulator simulator) {
        return simulator.updated;
    }

    public static /* synthetic */ boolean b(Simulator simulator, boolean bl2) {
        simulator.updated = bl2;
        return simulator.updated;
    }

    public static /* synthetic */ void a(Simulator simulator, Vector vector) {
        simulator.a(vector);
    }

    public static /* synthetic */ void k(Simulator simulator) {
        simulator.h();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class UpdateThread
    extends Thread {
        private boolean a = false;

        public UpdateThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public final void run() {
            try {
                while (true) {
                    Object object = this;
                    // MONITORENTER : object
                    while (!this.a) {
                        this.wait();
                    }
                    this.a = false;
                    SystemState systemState = Simulator.this.currentState;
                    // MONITOREXIT : object
                    object = ((Simulator)Simulator.this).inspector.engine;
                    Engine engine = object;
                    // MONITORENTER : object
                    try {
                        Vector vector = ((Engine)object).a((da)((Simulator)Simulator.this).system.a, systemState);
                        SystemState systemState2 = systemState;
                        EventQueue.invokeLater(new dC(this, systemState2, vector));
                    }
                    catch (Exception exception) {
                        EventQueue.invokeLater(new Z(this, exception));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public final synchronized void a() {
            this.a = true;
            this.notify();
        }
    }
}

