/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.util.files;

import java.io.File;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class GUIFileFilter
extends FileFilter {
    private String extension;
    private String description;

    public GUIFileFilter(String s) {
        this.extension = s;
        this.description = this.extension.length() == 0 ? "* (all files)" : "*." + this.extension;
    }

    public GUIFileFilter(String ext, String descr) {
        this.extension = ext;
        this.description = descr + " (*." + ext + ")";
    }

    public boolean accept(File f) {
        if (this.extension.length() == 0) {
            return true;
        }
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName();
        StringTokenizer ext = new StringTokenizer(this.extension, ",");
        while (ext.hasMoreTokens()) {
            if (!name.toLowerCase().endsWith("." + ext.nextToken())) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }
}

