/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.util.files;

import com.uppaal.gui.Main;
import com.uppaal.util.files.GUIFileFilter;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileHandle
extends Observable {
    private String dialogTitle;
    private File file;
    private JFileChooser fileChooser;
    private Frame frame;
    private Vector filters = new Vector();

    public FileHandle(Frame frame, String extension, String dialogTitle) {
        this(frame, dialogTitle);
        this.addFilter(new GUIFileFilter(extension));
    }

    public FileHandle(Frame frame, String dialogTitle) {
        this.frame = frame;
        this.dialogTitle = dialogTitle;
    }

    public void addFilter(FileFilter filter) {
        if (this.fileChooser != null) {
            this.fileChooser.addChoosableFileFilter(filter);
            this.fileChooser.setFileFilter(filter);
        }
        this.filters.addElement(filter);
    }

    public String getName() {
        return this.file == null ? "" : this.file.getName();
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            for (int i = 0; i < this.filters.size(); ++i) {
                this.fileChooser.addChoosableFileFilter((FileFilter)this.filters.get(i));
            }
            this.fileChooser.setFileFilter((FileFilter)this.filters.get(this.filters.size() - 1));
        }
        return this.fileChooser;
    }

    public final String getRootName() {
        String name = this.getName();
        int dotPos = name.lastIndexOf(".");
        return dotPos >= 0 ? name.substring(0, dotPos) : name;
    }

    public String getDirName() {
        return this.file.getParent();
    }

    public String fullName() {
        return this.file == null ? "" : this.file.getPath();
    }

    public final void notifyObserversNow() {
        this.setChanged();
        this.notifyObservers();
    }

    public final boolean exists() {
        return this.file != null && this.file.exists();
    }

    public void setNew(String d, String n) {
        this.file = new File(d, n);
    }

    public void setName(String f) {
        this.file = f == null ? null : new File(f);
    }

    public void renew() {
        this.file = null;
    }

    public final boolean ask(String title) {
        JFileChooser chooser = this.getFileChooser();
        chooser.setCurrentDirectory(this.file == null ? new File(Main.currentDir) : this.file);
        if (chooser.showDialog(this.frame, title) == 0) {
            this.file = chooser.getSelectedFile();
            Main.currentDir = chooser.getCurrentDirectory().getAbsolutePath();
            return true;
        }
        Main.currentDir = chooser.getCurrentDirectory().getAbsolutePath();
        return false;
    }

    public boolean ask() {
        return this.ask(this.dialogTitle);
    }

    public FileInputStream inStream() throws FileNotFoundException {
        return this.file == null ? null : new FileInputStream(this.file);
    }

    public FileOutputStream outStream() throws FileNotFoundException, IOException {
        return this.file == null ? null : new FileOutputStream(this.file);
    }

    public String getText() {
        if (!this.exists()) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.file));
            while (br.ready()) {
                s.append(br.readLine());
                s.append('\n');
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            Main.internalError.errorMessage("File for FileHandle::getText() not found");
        }
        catch (IOException e) {
            System.err.println("FileHandle::getText() Error reading file:" + e + ".");
        }
        return s.toString();
    }

    public boolean isFile() {
        return this.file != null && this.file.isFile();
    }

    public boolean canWrite() {
        return this.file != null && this.file.canWrite();
    }

    public String toString() {
        String msg = this.getClass().getName();
        msg = msg + "[name:" + this.getName();
        msg = msg + ",dir:" + this.getDirName();
        msg = msg + ",frame:" + this.frame;
        msg = msg + "]";
        return msg;
    }
}

