/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class MultiChooser2
extends JDialog {
    private JButton okayButton = new JButton("Ok");
    private JButton cancelButton = new JButton("Cancel");
    private JButton allButton = new JButton("All");
    private JButton noneButton = new JButton("None");
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JPanel buttonPanel = new JPanel(new FlowLayout());
    private CheckBoxListModel model = new CheckBoxListModel();
    private JList list = new JList(this.model);
    private JScrollPane scroll = new JScrollPane(this.list);
    private String[] labels;
    private boolean[] selected;
    boolean ok = false;

    public MultiChooser2(JFrame parent, String title, String[] labels, boolean[] selected) {
        super(parent, title, true);
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(2);
        this.labels = labels;
        this.selected = selected;
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MultiChooser2.this.dispose();
            }
        });
        this.okayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ar) {
                MultiChooser2.this.ok = true;
                MultiChooser2.this.dispose();
            }
        });
        this.allButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MultiChooser2.this.model.selectAll();
            }
        });
        this.noneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MultiChooser2.this.model.selectNone();
            }
        });
        this.buttonPanel.add(this.allButton);
        this.buttonPanel.add(this.noneButton);
        this.buttonPanel.add(this.okayButton);
        this.buttonPanel.add(this.cancelButton);
        this.list.setCellRenderer(new CheckBoxRenderer());
        this.list.addMouseListener(this.model);
        this.mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.mainPanel.add((Component)this.scroll, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    public static boolean show(JFrame parent, String title, String[] labels, boolean[] selected) {
        boolean[] copy = new boolean[selected.length];
        System.arraycopy(selected, 0, copy, 0, selected.length);
        MultiChooser2 chooser = new MultiChooser2(parent, title, labels, copy);
        chooser.pack();
        chooser.setVisible(true);
        if (!chooser.ok) {
            return false;
        }
        System.arraycopy(copy, 0, selected, 0, selected.length);
        return true;
    }

    class CheckBoxListModel
    extends AbstractListModel
    implements MouseListener {
        CheckBoxListModel() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                int index = MultiChooser2.this.list.locationToIndex(e.getPoint());
                ((MultiChooser2)MultiChooser2.this).selected[index] = !MultiChooser2.this.selected[index];
                this.fireContentsChanged(this, index, index);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public int getSize() {
            return MultiChooser2.this.labels.length;
        }

        public Object getElementAt(int index) {
            return MultiChooser2.this.labels[index];
        }

        public void selectAll() {
            for (int i = 0; i < MultiChooser2.this.selected.length; ++i) {
                ((MultiChooser2)MultiChooser2.this).selected[i] = true;
            }
            this.fireContentsChanged(this, 0, MultiChooser2.this.selected.length - 1);
        }

        public void selectNone() {
            for (int i = 0; i < MultiChooser2.this.selected.length; ++i) {
                ((MultiChooser2)MultiChooser2.this).selected[i] = false;
            }
            this.fireContentsChanged(this, 0, MultiChooser2.this.selected.length - 1);
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CheckBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(MultiChooser2.this.labels[index]);
            this.setSelected(MultiChooser2.this.selected[index]);
            this.setOpaque(false);
            return this;
        }
    }
}

