/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.UppaalSystem;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemTransition {
    private Vector<SystemEdge> edges = new Vector();
    private static final String PROTOCOL_ERROR = "While reading transition";

    public static SystemTransition create(UppaalSystem system, LexicalAnalyser lex) throws ProtocolException, IOException {
        SystemTransition t = new SystemTransition();
        try {
            while (lex.getToken() != 1) {
                if (lex.getToken() != 4) {
                    throw new ProtocolException(PROTOCOL_ERROR);
                }
                int i = lex.getValue();
                if (lex.nextToken() != 4) {
                    throw new ProtocolException(PROTOCOL_ERROR);
                }
                int j = lex.getValue();
                if (lex.nextToken() != 0) {
                    throw new ProtocolException(PROTOCOL_ERROR);
                }
                t.edges.add(system.getEdge(i, j - 1));
                lex.nextToken();
            }
        }
        catch (NumberFormatException e) {
            throw new ProtocolException(e.getMessage());
        }
        return t;
    }

    public String traceFormat() {
        StringBuffer s = new StringBuffer("(");
        boolean start = true;
        for (SystemEdge edge : this.edges) {
            if (start) {
                start = false;
            } else {
                s.append(", ");
            }
            s.append(edge.getFormatedName());
        }
        s.append(')');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return ((SystemTransition)obj).edges.equals(this.edges);
    }

    public String getTextualFormat() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.edges.size());
        for (SystemEdge edge : this.edges) {
            buf.append('\n');
            buf.append(edge.getProcess().getIndex()).append('\n');
            buf.append(edge.getIndex() + 1);
        }
        return buf.toString();
    }

    public Vector<SystemEdge> getEdges() {
        return this.edges;
    }

    public SystemEdge getEdge(int i) {
        return this.edges.get(i);
    }

    public int getSize() {
        return this.edges.size();
    }

    public boolean involvesProcess(int process) {
        for (SystemEdge edge : this.edges) {
            if (edge.getProcess().getIndex() != process) continue;
            return true;
        }
        return false;
    }
}

