/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import com.uppaal.model.system.LocationVector;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.UppaalSystem;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemState {
    private Vector<Integer> valueList;
    private Polyhedron myPolyhedron;
    private LocationVector myLocationVector;

    public SystemState(UppaalSystem system) {
        this.myPolyhedron = new Polyhedron(system);
        this.myLocationVector = new LocationVector(system);
    }

    public SystemState(LocationVector loc, Polyhedron pol) {
        this.myLocationVector = loc;
        this.myPolyhedron = pol;
    }

    public static SystemState create(UppaalSystem system, LexicalAnalyser lex) throws ProtocolException, IOException {
        LocationVector loc = LocationVector.create(system, lex);
        lex.nextToken();
        Polyhedron pol = Polyhedron.create(system, lex);
        SystemState state = new SystemState(loc, pol);
        state.valueList = new Vector();
        for (int i = 0; i < system.getNoOfVariables(); ++i) {
            if (lex.nextToken() != 4) {
                throw new ProtocolException("While reading state");
            }
            state.valueList.add(lex.getValue());
            if (lex.nextToken() == 0) continue;
            throw new ProtocolException("While reading state");
        }
        if (lex.nextToken() != 1) {
            throw new ProtocolException("While reading state");
        }
        return state;
    }

    public String getTextualFormat() {
        StringBuffer s = new StringBuffer();
        s.append(this.myLocationVector.writeTextualFormat());
        s.append(this.myPolyhedron.writeTextualFormat());
        for (Integer i : this.valueList) {
            s.append(i.toString());
            s.append('\n');
        }
        s.append('.');
        return s.toString();
    }

    public String toString() {
        return this.getTextualFormat() + "\n";
    }

    public String traceFormat() {
        return this.myLocationVector.traceFormat();
    }

    public LocationVector getLocationVector() {
        return this.myLocationVector;
    }

    public Polyhedron getPolyhedron() {
        return this.myPolyhedron;
    }

    public Vector<Integer> getVariables() {
        return this.valueList;
    }
}

