/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.Translator;
import java.util.Vector;

public class Process {
    private String name;
    private Template template;
    private Vector<SystemLocation> locations;
    private Vector<SystemEdge> edges;
    private Translator translator;
    private int index;

    Process(String name, int index, Template template, Translator translator) {
        this.name = name;
        this.template = template;
        this.locations = new Vector();
        this.edges = new Vector();
        this.translator = translator;
        this.index = index;
    }

    void addEdge(Edge edge) {
        String sync = (String)edge.getPropertyValue("synchronisation");
        if (sync != null && sync.length() > 0) {
            sync = this.translator.translate(sync);
        }
        this.edges.add(new SystemEdge(this, this.edges.size(), this.name, edge));
    }

    void addLocation(Location location) {
        this.locations.add(new SystemLocation(this, this.locations.size(), location));
    }

    public SystemEdge getEdge(int edge) {
        return this.edges.get(edge);
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public SystemLocation getLocation(int i) {
        return this.locations.get(i);
    }
}

