/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import com.uppaal.gui.Main;
import com.uppaal.model.system.UppaalSystem;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class Polyhedron {
    private UppaalSystem system;
    private Vector<Constraint> constraintList;
    private static int MAXBOUND = Integer.MAX_VALUE;
    private static int MINBOUND = Integer.MIN_VALUE;
    private static final String PROTOCOL_ERROR = "While reading polyhedron";

    private String getClockName(int i) {
        return this.system.getClockName(i);
    }

    public Polyhedron(UppaalSystem system) {
        this.system = system;
        this.constraintList = new Vector();
    }

    private static boolean strict(int bound) {
        return (bound & 1) == 0;
    }

    private static int getValue(int bound) {
        return bound >> 1;
    }

    private static int makeBound(int val, boolean strict) {
        return strict ? val << 1 : (val << 1) + 1;
    }

    private static int setStrict(int val) {
        return val & 0xFFFFFFFE;
    }

    private static int readInteger(LexicalAnalyser lex) throws ProtocolException, NumberFormatException, IOException {
        if (lex.getToken() != 4) {
            throw new ProtocolException(PROTOCOL_ERROR);
        }
        int i = lex.getValue();
        if (lex.nextToken() != 0) {
            throw new ProtocolException(PROTOCOL_ERROR);
        }
        return i;
    }

    public static Polyhedron create(UppaalSystem system, LexicalAnalyser lex) throws ProtocolException, IOException {
        Polyhedron pol = new Polyhedron(system);
        try {
            while (lex.getToken() != 1) {
                int i = Polyhedron.readInteger(lex);
                lex.nextToken();
                int j = Polyhedron.readInteger(lex);
                lex.nextToken();
                int b = Polyhedron.readInteger(lex);
                if (lex.nextToken() != 1) {
                    throw new ProtocolException(PROTOCOL_ERROR);
                }
                Vector<Constraint> vector = pol.constraintList;
                Polyhedron polyhedron = pol;
                polyhedron.getClass();
                vector.add(polyhedron.new Constraint(i, j, b ^ 1));
                lex.nextToken();
            }
        }
        catch (NumberFormatException e) {
            throw new ProtocolException(e.getMessage());
        }
        return pol;
    }

    private int[][] computeCanonicalDBM() {
        int i;
        int j;
        int size = this.system.getNoOfClocks();
        int[][] dbm = new int[size][size];
        for (j = 0; j < size; ++j) {
            dbm[0][j] = 1;
        }
        for (i = 1; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                dbm[i][j] = MAXBOUND;
            }
        }
        for (Constraint constr : this.constraintList) {
            if (constr.bound() >= MAXBOUND || constr.bound() <= MINBOUND) {
                Main.infoError.errorMessage("Polyhedron::computeCanonicalDBM(): illegal value for bound");
            }
            dbm[constr.getIndex1()][constr.getIndex2()] = constr.bound;
        }
        for (int k = 0; k < size; ++k) {
            for (j = 0; j < size; ++j) {
                if (dbm[k][j] >= MAXBOUND) continue;
                for (i = 0; i < size; ++i) {
                    int sum;
                    if (dbm[i][k] >= MAXBOUND || (sum = (dbm[i][k] & 0xFFFFFFFE) + (dbm[k][j] & 0xFFFFFFFE) | dbm[i][k] & dbm[k][j] & 1) >= dbm[i][j]) continue;
                    dbm[i][j] = sum;
                }
            }
        }
        return dbm;
    }

    public String writeTextualFormat() {
        StringBuffer s = new StringBuffer("");
        for (Constraint c : this.constraintList) {
            s.append(String.valueOf(c.i));
            s.append("\n");
            s.append(String.valueOf(c.j));
            s.append("\n");
            s.append(String.valueOf(c.bound ^ 1));
            s.append("\n");
            s.append(".\n");
        }
        s.append(".\n");
        return new String(s);
    }

    public String dbmAsString() {
        int[][] dbm = this.computeCanonicalDBM();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.system.getNoOfClocks(); ++i) {
            for (int j = i + 1; j < this.system.getNoOfClocks(); ++j) {
                int lower = dbm[i][j];
                int upper = dbm[j][i];
                if (lower == MAXBOUND && upper == MAXBOUND || i == 0 && lower == 1 && upper == MAXBOUND) continue;
                String iname = this.getClockName(i);
                String jname = this.getClockName(j);
                if (Polyhedron.getValue(lower) >= 0 && Polyhedron.getValue(upper) < 0) {
                    iname = this.getClockName(j);
                    jname = this.getClockName(i);
                    int oldupper = upper;
                    upper = lower;
                    lower = oldupper;
                }
                s.append(jname);
                if (Polyhedron.getValue(lower) == 0 && Polyhedron.getValue(upper) == 0 && i > 0) {
                    s.append(" = ");
                    s.append(iname);
                    s.append('\n');
                    continue;
                }
                if (i > 0) {
                    s.append(" - ");
                    s.append(iname);
                }
                if (Polyhedron.getValue(lower) == -Polyhedron.getValue(upper)) {
                    s.append(" = ");
                    s.append(String.valueOf(Polyhedron.getValue(upper)));
                } else {
                    s.append(" in ");
                    if (lower == MAXBOUND) {
                        s.append("[-inf,");
                    } else {
                        if (Polyhedron.strict(lower)) {
                            s.append("(");
                        } else {
                            s.append("[");
                        }
                        s.append(String.valueOf(-1 * Polyhedron.getValue(lower)));
                        s.append(",");
                    }
                    if (upper == MAXBOUND) {
                        s.append("inf]");
                    } else {
                        s.append(String.valueOf(Polyhedron.getValue(upper)));
                        if (Polyhedron.strict(upper)) {
                            s.append(")");
                        } else {
                            s.append("]");
                        }
                    }
                }
                s.append("\n");
            }
        }
        return s.toString();
    }

    public String toString() {
        if (this.constraintList.isEmpty()) {
            return "true";
        }
        StringBuffer s = new StringBuffer();
        Iterator<Constraint> i = this.constraintList.iterator();
        s.append(i.next().toString());
        while (i.hasNext()) {
            s.append("\n");
            s.append(i.next().toString());
        }
        return s.toString();
    }

    public void addStrictConstraint(int i, int j, int bound) {
        this.constraintList.add(new Constraint(i, j, 2 * bound));
    }

    public void addNonStrictConstraint(int i, int j, int bound) {
        this.constraintList.add(new Constraint(i, j, 2 * bound + 1));
    }

    class Constraint {
        private int i;
        private int j;
        private int bound;

        public Constraint(int a, int b, int c) {
            if (a > Polyhedron.this.system.getNoOfClocks() || b > Polyhedron.this.system.getNoOfClocks()) {
                Main.internalError.errorMessage("clock out of range\n");
            }
            this.i = a;
            this.j = b;
            this.bound = c;
        }

        public int getIndex1() {
            return this.i;
        }

        public int getIndex2() {
            return this.j;
        }

        public int bound() {
            return this.bound;
        }

        public boolean strict() {
            return this.isStrict();
        }

        public boolean isStrict() {
            return (this.bound & 1) == 0;
        }

        public int val() {
            return this.getValue();
        }

        public int getValue() {
            return this.bound >> 1;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("");
            s.append(Polyhedron.this.getClockName(this.i));
            s.append(" - ");
            s.append(Polyhedron.this.getClockName(this.j));
            if (!this.strict()) {
                s.append(" <= ");
            } else {
                s.append(" < ");
            }
            s.append(this.val());
            return new String(s);
        }
    }
}

