/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import com.uppaal.model.system.SystemLocation;
import com.uppaal.model.system.UppaalSystem;
import java.io.IOException;

public class LocationVector {
    private SystemLocation[] locations;

    public LocationVector(UppaalSystem system) {
        this.locations = new SystemLocation[system.getNoOfProcesses()];
    }

    public static LocationVector create(UppaalSystem system, LexicalAnalyser lex) throws ProtocolException, IOException {
        LocationVector loc = new LocationVector(system);
        try {
            for (int i = 0; i < loc.locations.length; ++i) {
                block9: {
                    block8: {
                        if (lex.getToken() != 4) break block8;
                        loc.locations[i] = system.getLocation(i, lex.getValue());
                        if (lex.nextToken() == 0) break block9;
                    }
                    throw new ProtocolException("While reading location vector");
                }
                lex.nextToken();
            }
            if (lex.getToken() != 1) {
                throw new ProtocolException("Expected end of block");
            }
        }
        catch (NumberFormatException e) {
            throw new ProtocolException(e.getMessage());
        }
        return loc;
    }

    public String writeTextualFormat() {
        StringBuffer s = new StringBuffer("");
        for (SystemLocation location : this.locations) {
            s.append(String.valueOf(location.getIndex()));
            s.append('\n');
        }
        s.append(".\n");
        return s.toString();
    }

    public String toString() {
        return this.convertToString(false);
    }

    private String convertToString(boolean isShort) {
        StringBuffer s = new StringBuffer("(");
        boolean first = true;
        for (SystemLocation location : this.locations) {
            String name;
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            if (!isShort) {
                s.append(location.getProcess().getName() + ".");
            }
            s.append((name = location.getName()) == null || name.length() == 0 ? "-" : name);
        }
        s.append(")");
        return s.toString();
    }

    public String traceFormat() {
        return this.convertToString(true);
    }

    public int size() {
        return this.locations.length;
    }

    public SystemLocation get(int i) {
        return this.locations[i];
    }
}

