/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.io2;

import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.io2.ParseException;
import com.uppaal.model.io2.SimpleCharStream;
import com.uppaal.model.io2.Token;
import com.uppaal.model.io2.XTAReaderConstants;
import com.uppaal.model.io2.XTAReaderTokenManager;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class XTAReader
implements XTAReaderConstants {
    public XTAReaderTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[15];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public Document parse(Element prototype) throws ParseException {
        Document doc = new Document(prototype);
        this.systemSpec(doc);
        return doc;
    }

    private StringBuffer specialImage(Token t) {
        if (t != null) {
            return this.specialImage(t, t.image);
        }
        return new StringBuffer("");
    }

    private StringBuffer specialImage(Token t, String repl) {
        Stack<String> stack = new Stack<String>();
        StringBuffer s = new StringBuffer();
        stack.push(repl);
        t = t.specialToken;
        while (t != null) {
            stack.push(t.image);
            t = t.specialToken;
        }
        while (!stack.empty()) {
            s.append((String)stack.pop());
        }
        return s;
    }

    private StringBuffer skipTo(TerminationCondition condition, boolean leading) throws ParseException {
        StringBuffer s = new StringBuffer();
        while (!condition.terminate()) {
            Token t = this.getNextToken();
            if (t.kind != 0) {
                if (leading) {
                    s.append(this.specialImage(t.specialToken));
                } else {
                    leading = true;
                }
                s.append(t.image);
                continue;
            }
            if (condition.terminate()) break;
            throw new ParseException("Unexpected end of file.");
        }
        return s;
    }

    private String skipTo(int tokenKind, boolean leading) throws ParseException {
        StringBuffer s = new StringBuffer();
        Token t = this.getNextToken();
        while (t.kind != tokenKind) {
            if (t.kind == 0) {
                throw new ParseException("Token '" + tokenImage[tokenKind] + "'expected.");
            }
            if (leading) {
                s.append(this.specialImage(t.specialToken));
            } else {
                leading = true;
            }
            s.append(t.image);
            t = this.getNextToken();
        }
        return s.toString();
    }

    public final void systemSpec(Document document) throws ParseException {
        this.globalvardeclblock(document);
        while (this.getToken((int)1).kind == 4) {
            this.processdecl(document);
        }
        this.processassblock(document);
        this.systemdeclblock(document);
    }

    void globalvardeclblock(Document document) throws ParseException {
        StringBuffer decl = this.skipTo(new TerminationCondition(){

            public boolean terminate() {
                return XTAReader.this.getToken((int)1).kind == 20 || XTAReader.this.getToken((int)1).kind == 4;
            }
        }, true);
        if (decl.length() != 0) {
            document.setProperty("declaration", decl.toString());
        }
    }

    public final void processdecl(Document document) throws ParseException {
        Template template = document.createTemplate();
        this.PTHead(template);
        this.PTParamList(template);
        this.PTBody(template);
        document.insert(template, document.getLast());
    }

    void processassblock(Document document) throws ParseException {
        StringBuffer assign = this.skipTo(new TerminationCondition(){

            public boolean terminate() {
                return XTAReader.this.getToken((int)1).kind == 19;
            }
        }, false);
        if (assign.length() != 0) {
            document.setProperty("instantiation", assign.toString());
        }
    }

    void systemdeclblock(Document document) throws ParseException {
        document.setProperty("system", this.skipTo(0, false));
    }

    public final void PTHead(Template template) throws ParseException {
        String s;
        TerminationCondition tc = new TerminationCondition(){

            public boolean terminate() {
                return XTAReader.this.getToken((int)1).kind == 25 || XTAReader.this.getToken((int)1).kind == 31;
            }
        };
        try {
            this.jj_consume_token(4);
            Token t = this.jj_consume_token(47);
            s = t.image;
        }
        catch (ParseException e) {
            s = new String(this.skipTo(tc, true));
        }
        template.setProperty("name", s);
    }

    public final void PTParamList(Template template) throws ParseException {
        String param = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                param = this.skipTo(26, true);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        template.setProperty("parameter", param);
    }

    public final void PTBody(Template template) throws ParseException {
        this.jj_consume_token(31);
        this.body(template);
        this.jj_consume_token(32);
    }

    public final void body(Template template) throws ParseException {
        HashMap locations = new HashMap();
        this.bodyLocal(template);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                this.bodyStates(template, locations);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.bodyCommitted(locations);
                block21: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(29);
                    this.bodyCommitted(locations);
                }
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                this.bodyUrgent(locations);
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(29);
                    this.bodyUrgent(locations);
                }
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                this.bodyInit(template, locations);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                this.bodyTransitions(template, locations);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
    }

    void bodyLocal(Template template) throws ParseException {
        StringBuffer decl = this.skipTo(new TerminationCondition(){
            int open = 0;

            public boolean terminate() {
                Token t = XTAReader.this.getToken(1);
                if (t.kind == 31) {
                    ++this.open;
                } else if (t.kind == 32) {
                    --this.open;
                }
                return t.kind == 13 || this.open == -1;
            }
        }, false);
        if (decl.length() != 0) {
            template.setProperty("declaration", decl.toString());
        }
    }

    public final void bodyStates(Template template, Map locations) throws ParseException {
        this.bodyState(template, locations);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(29);
            this.bodyState(template, locations);
        }
        this.jj_consume_token(30);
    }

    public final void bodyState(Template template, Map locations) throws ParseException {
        Token t = this.jj_consume_token(47);
        Location location = template.createLocation();
        location.setProperty("name", t.image);
        template.insert(location, template.getLast());
        locations.put(t.image, location);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                location.setProperty("invariant", this.skipTo(32, false));
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
    }

    public final void bodyCommitted(Map locations) throws ParseException {
        Location loc = this.location(locations);
        if (loc != null) {
            loc.setProperty("committed", true);
        }
    }

    public final void bodyUrgent(Map locations) throws ParseException {
        Location loc = this.location(locations);
        if (loc != null) {
            loc.setProperty("urgent", true);
        }
    }

    public final void bodyInit(Template template, Map locations) throws ParseException {
        Location loc = this.location(locations);
        this.jj_consume_token(30);
        if (loc != null) {
            loc.setProperty("init", true);
        }
    }

    public final void bodyTransitions(Template template, Map locations) throws ParseException {
        Location src = this.location(locations);
        this.jj_consume_token(41);
        this.destination(template, locations, src);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(29);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: {
                    src = this.location(locations);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                }
            }
            this.jj_consume_token(41);
            this.destination(template, locations, src);
        }
        this.jj_consume_token(30);
    }

    public final Location location(Map locations) throws ParseException {
        Token t = this.jj_consume_token(47);
        return (Location)locations.get(t.image);
    }

    public final void destination(Template template, Map locations, Location src) throws ParseException {
        try {
            Location dst = this.location(locations);
            Edge edge = template.createEdge();
            edge.setSource(src);
            edge.setTarget(dst);
            template.insert(edge, template.getLast());
            this.jj_consume_token(31);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    this.jj_consume_token(16);
                    edge.setProperty("guard", this.skipTo(30, false));
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    this.jj_consume_token(17);
                    edge.setProperty("synchronisation", this.skipTo(30, false));
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    this.jj_consume_token(18);
                    edge.setProperty("assignment", this.skipTo(30, false));
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                }
            }
            this.jj_consume_token(32);
        }
        catch (ParseException e) {
            this.skipTo(32, false);
        }
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x2000000, 8192, 0x20000000, 32768, 0x20000000, 2048, 4096, 16384, 0x20000000, Integer.MIN_VALUE, 0x20000000, 0, 65536, 131072, 262144};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32768, 0, 0, 0};
    }

    public XTAReader(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new XTAReaderTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public XTAReader(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new XTAReaderTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public XTAReader(XTAReaderTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(XTAReaderTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 15; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[50];
        for (i = 0; i < 50; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 15; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 50; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        XTAReader.jj_la1_0();
        XTAReader.jj_la1_1();
    }

    static interface TerminationCondition {
        public boolean terminate();
    }
}

