/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.CannotRedoException;
import com.uppaal.model.core2.CannotUndoException;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CompoundCommand;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;
import java.util.LinkedList;

public class Document
extends Node {
    protected int version;
    protected LinkedList<Command> undoList = new LinkedList();
    protected LinkedList<Command> redoList = new LinkedList();

    public Document() {
        super(null);
    }

    public Document(Element prototype) {
        super(prototype);
    }

    public void execute(Command command) {
        command.setVersion(this.version);
        if (this.redoList.isEmpty()) {
            ++this.version;
        } else {
            this.version = this.redoList.getLast().getVersion() + 1;
            this.redoList.clear();
        }
        this.undoList.add(command);
        command.execute();
    }

    public void execute(Command ... commands) {
        this.execute((Command)new CompoundCommand(commands));
    }

    public void undo() throws CannotUndoException {
        if (this.undoList.isEmpty()) {
            throw new CannotUndoException();
        }
        Command command = this.undoList.removeLast();
        int oldVersion = this.version;
        this.version = command.getVersion();
        command.setVersion(oldVersion);
        command.undo();
        this.redoList.add(command);
    }

    public void redo() throws CannotRedoException {
        if (this.redoList.isEmpty()) {
            throw new CannotRedoException();
        }
        Command command = this.redoList.removeLast();
        int oldVersion = this.version;
        this.version = command.getVersion();
        command.setVersion(oldVersion);
        command.execute();
        this.undoList.add(command);
    }

    public int getVersion() {
        return this.version;
    }

    public Template createTemplate() {
        return new Template((Element)this.getPropertyValue("#template"));
    }

    public Template getTemplates() {
        return (Template)this.first;
    }

    public void accept(Visitor visitor) throws Exception {
        visitor.visitDocument(this);
    }

    public Document getDocument() {
        return this;
    }
}

