/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.verifier;

import com.uppaal.engine.ConnectionListener;
import com.uppaal.engine.Engine;
import com.uppaal.engine.RequestOptionsInfo;
import com.uppaal.engine.RequestSetOptions;
import com.uppaal.gui.Main;
import com.uppaal.gui.SystemInspector;
import com.uppaal.gui.verifier.Options;
import com.uppaal.gui.verifier.OptionsChangedEvent;
import com.uppaal.gui.verifier.OptionsChangedListener;
import com.uppaal.gui.verifier.Property;
import com.uppaal.gui.verifier.Verification;
import com.uppaal.util.files.FileHandle;
import com.uppaal.util.files.GUIFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verifier
extends JPanel
implements DocumentListener,
OptionsChangedListener,
ConnectionListener {
    protected static final String SELECT = "com/uppaal/resource/images/selectedQuery.gif";
    protected static final String OKAY = "com/uppaal/resource/images/queryOkay.gif";
    protected static final String NOT_OKAY = "com/uppaal/resource/images/queryNotOkay.gif";
    protected static final String UNKNOWN = "com/uppaal/resource/images/queryUnknown.gif";
    JPanel queryControl;
    JList queryList;
    PropertyListModel queryModel;
    JScrollPane queryScroll;
    JButton newProperty;
    JButton removeProperty;
    JButton checkProperty;
    JButton toggle;
    boolean queryVisible = true;
    JPanel buttonPanel;
    JTextArea propertyEditor;
    JScrollPane propertyScroll;
    JTextArea commentEditor;
    JScrollPane commentScroll;
    JList status;
    DefaultListModel statusModel;
    JScrollPane statusScroll;
    private JMenuBar menuBar;
    private JMenu queryMenu;
    FileHandle qFile;
    PlainDocument emptyDoc = new PlainDocument();
    SystemInspector inspector;
    Options options;
    boolean changed = true;

    public Verifier(SystemInspector inspector) {
        this.inspector = inspector;
        inspector.getEngine().addConnectionListener(this);
        this.createUI();
        this.qFile = new FileHandle(inspector, "UPPAAL Queries File");
        this.qFile.addFilter(new GUIFileFilter("q", "UPPAAL Queries File"));
    }

    @Override
    public void optionsChanged(OptionsChangedEvent e) {
        this.queryList.getSelectionModel().setSelectionMode(e.getSource().traceOn() ? 0 : 2);
        this.changed = true;
    }

    public void resetQueryStatus() {
        for (int i = 0; i < this.queryModel.size(); ++i) {
            this.queryModel.setStatus(i, 4);
        }
    }

    public void load(URL url) throws IOException {
        this.qFile.setName(null);
        if (this.queryModel.parse(url) > 0) {
            this.propertyEditor.setEnabled(true);
            this.commentEditor.setEnabled(true);
            this.queryList.setSelectedIndex(0);
            for (int i = 0; i < this.queryModel.size(); ++i) {
                Property p = (Property)this.queryModel.elementAt(i);
                p.getPropertyDocument().addDocumentListener(this);
                p.getCommentDocument().addDocumentListener(this);
            }
        } else {
            this.propertyEditor.setEnabled(false);
            this.propertyEditor.setDocument(this.emptyDoc);
            this.commentEditor.setEnabled(false);
            this.commentEditor.setDocument(this.emptyDoc);
        }
        if (url.getProtocol().equals("file")) {
            this.qFile.setName(url.getFile());
        }
    }

    private void saveAs() {
        if (this.qFile.ask("Save Queries As") && (!this.qFile.exists() || Main.choiceError.errorMessage("Overwrite " + this.qFile.getName()))) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            FileOutputStream out = this.qFile.outStream();
            try {
                this.queryModel.unparse(out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException ioe) {
            Main.infoError.errorMessage("Error Saving Properties.");
        }
    }

    public void appendText(String s) {
        this.statusModel.addElement(s);
        this.status.ensureIndexIsVisible(this.statusModel.size() - 1);
    }

    public boolean closing() {
        return true;
    }

    public Vector<Property> getQueries() {
        Vector<Property> toCheck = new Vector<Property>();
        for (int i : this.queryList.getSelectedIndices()) {
            Property prop = (Property)this.queryModel.elementAt(i);
            if (prop.getProperty().trim().length() <= 0) continue;
            toCheck.add(prop);
        }
        return toCheck;
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.queryModel = new PropertyListModel();
        this.queryList = new JList(this.queryModel);
        this.queryList.setVisibleRowCount(8);
        this.queryList.setCellRenderer(new QueryRenderer());
        this.queryList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                try {
                    Property sel = (Property)Verifier.this.queryModel.elementAt(Verifier.this.queryList.getSelectedIndex());
                    Verifier.this.propertyEditor.setDocument(sel.getPropertyDocument());
                    Verifier.this.commentEditor.setDocument(sel.getCommentDocument());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.queryScroll = new JScrollPane(this.queryList);
        this.newProperty = new JButton("Insert");
        this.newProperty.setToolTipText("Insert new query.");
        this.newProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int index = Verifier.this.queryList.getSelectedIndex();
                if (index == -1) {
                    Property theNew = Verifier.this.queryModel.addNewProperty();
                    index = Verifier.this.queryModel.indexOf(theNew);
                } else {
                    Property property = Verifier.this.queryModel.addNewProperty(index);
                }
                Verifier.this.queryList.clearSelection();
                Verifier.this.queryList.setSelectedIndex(index);
                Verifier.this.queryList.ensureIndexIsVisible(index);
                Verifier.this.propertyEditor.setEnabled(true);
                Verifier.this.commentEditor.setEnabled(true);
            }
        });
        this.removeProperty = new JButton("Remove");
        this.removeProperty.setToolTipText("Delete selected query.");
        this.removeProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    int i = Verifier.this.queryList.getSelectedIndex();
                    Verifier.this.queryModel.removeElementAt(i);
                    if (i == Verifier.this.queryModel.size()) {
                        --i;
                    }
                    if (i < 0) {
                        Verifier.this.propertyEditor.setEnabled(false);
                        Verifier.this.propertyEditor.setDocument(Verifier.this.emptyDoc);
                        Verifier.this.commentEditor.setEnabled(false);
                        Verifier.this.commentEditor.setDocument(Verifier.this.emptyDoc);
                    }
                    Verifier.this.queryList.setSelectedIndex(i);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.checkProperty = new JButton("Check");
        this.checkProperty.setToolTipText("Model check selected queries.");
        this.checkProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Verifier.this.verify();
            }
        });
        this.toggle = new JButton("Comments");
        this.toggle.setToolTipText("Display comments in overview.");
        this.toggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Verifier.this.queryVisible = !Verifier.this.queryVisible;
                Verifier.this.toggle.setText(Verifier.this.queryVisible ? "Comments" : "Queries");
                Verifier.this.toggle.setToolTipText(Verifier.this.queryVisible ? "Display comments in overview." : "Display queries in overview.");
                Verifier.this.queryList.repaint();
            }
        });
        this.buttonPanel = new JPanel(new GridLayout(0, 1));
        this.buttonPanel.add(this.checkProperty);
        this.buttonPanel.add(this.newProperty);
        this.buttonPanel.add(this.removeProperty);
        this.buttonPanel.add(this.toggle);
        this.buttonPanel.setBorder(new EmptyBorder(6, 6, 5, 5));
        this.queryControl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = -1;
        this.queryControl.add((Component)this.queryScroll, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        this.queryControl.add((Component)this.buttonPanel, gbc);
        this.queryControl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Overview"));
        this.propertyEditor = new JTextArea();
        this.propertyEditor.setFont(new Font("Monospaced", 0, 12));
        this.propertyScroll = new JScrollPane(this.propertyEditor);
        this.commentEditor = new JTextArea();
        this.commentEditor.setFont(new Font("Monospaced", 0, 12));
        this.commentScroll = new JScrollPane(this.commentEditor);
        this.statusModel = new DefaultListModel();
        this.status = new JList(this.statusModel);
        this.status.setVisibleRowCount(4);
        this.status.setBackground(this.getBackground());
        this.status.setCellRenderer(new StatusRenderer());
        this.status.setMaximumSize(new Dimension(1200, 100));
        this.statusScroll = new JScrollPane(this.status);
        JPanel editors = new JPanel(new GridLayout(2, 1));
        JPanel propTitel = new JPanel(new BorderLayout());
        propTitel.add((Component)this.propertyScroll, "Center");
        propTitel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Query"));
        JPanel commTitel = new JPanel(new BorderLayout());
        commTitel.add((Component)this.commentScroll, "Center");
        commTitel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Comment"));
        editors.add(propTitel);
        editors.add(commTitel);
        JPanel top = new JPanel(new GridLayout(2, 1));
        top.add(this.queryControl);
        top.add(editors);
        top.setBorder(new EmptyBorder(12, 12, 11, 11));
        JPanel extra = new JPanel(new BorderLayout());
        extra.add((Component)this.statusScroll, "Center");
        extra.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Status"));
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        bottom.add((Component)extra, "Center");
        JSplitPane theSplit = new JSplitPane(0, false, top, bottom);
        theSplit.setOneTouchExpandable(true);
        this.add((Component)theSplit, "Center");
        this.queryList.setSelectedIndex(0);
    }

    public void setMenuBar(JMenuBar theBar) {
        this.menuBar = theBar;
        this.options = new Options((JMenu)this.menuBar.getSubElements()[5]);
        this.options.addOptionsChangedListener(this);
        this.queryMenu = (JMenu)this.menuBar.getSubElements()[4];
        JMenuItem mi = this.queryMenu.add(new JMenuItem("New Queries"));
        mi.setMnemonic('N');
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Verifier.this.qFile.renew();
                Verifier.this.queryModel.removeAllElements();
                Verifier.this.queryModel.addNewProperty();
                Verifier.this.queryList.setSelectedIndex(0);
                Verifier.this.propertyEditor.setEnabled(true);
                Verifier.this.commentEditor.setEnabled(true);
            }
        });
        mi = this.queryMenu.add(new JMenuItem("Open Queries..."));
        mi.setMnemonic('O');
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Verifier.this.qFile.ask("Open Queries")) {
                    try {
                        Verifier.this.load(new URL("file:" + Verifier.this.qFile.fullName()));
                    }
                    catch (Exception ex) {
                        Verifier.this.queryModel.removeAllElements();
                        Main.infoError.errorMessage("Error while loading query file: " + ex.getMessage());
                    }
                }
            }
        });
        mi = this.queryMenu.add(new JMenuItem("Save Queries"));
        mi.setMnemonic('S');
        mi.setEnabled(!Main.demo);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Verifier.this.qFile.exists()) {
                    Verifier.this.save();
                } else {
                    Verifier.this.saveAs();
                }
            }
        });
        mi = this.queryMenu.add(new JMenuItem("Save Queries As..."));
        mi.setMnemonic('A');
        mi.setEnabled(!Main.demo);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Verifier.this.saveAs();
            }
        });
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.queryModel.setStatus(this.queryList.getSelectedIndex(), 4);
    }

    @Override
    public void insertUpdate(DocumentEvent doe) {
        this.queryModel.setStatus(this.queryList.getSelectedIndex(), 4);
    }

    @Override
    public void removeUpdate(DocumentEvent doce) {
        this.queryModel.setStatus(this.queryList.getSelectedIndex(), 4);
    }

    void verify() {
        this.inspector.updateEngine();
        if (this.changed) {
            this.inspector.getEngine().request(new RequestSetOptions(this.options));
            this.changed = false;
        }
        Verification verification = new Verification(this.inspector, this.getQueries());
        verification.start();
    }

    @Override
    public void connected(Engine engine, String version) {
        engine.request(new RequestOptionsInfo(){

            public void gotOptionsInfo(final String info) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Verifier.this.options.setInfoStructure(info);
                    }
                });
            }
        });
        this.changed = true;
    }

    @Override
    public void disconnected(Engine engine) {
        this.resetQueryStatus();
    }

    class SpecialTextField
    extends JLabel {
        public SpecialTextField() {
            this.setFont(new Font("Monospaced", 0, 12));
        }

        public void setText(String s) {
            s = s.replace('\n', ' ');
            super.setText(s);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 20);
        }
    }

    class StatusRenderer
    extends DefaultListCellRenderer {
        StatusRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setBackground(Color.white);
            if (value != null) {
                this.setBackground(list.getBackground());
                if (((String)value).equals("Property is not satisfied.") || ((String)value).equals("Operation cancelled!")) {
                    this.setForeground(Color.red);
                }
                if (((String)value).equals("Property is satisfied.")) {
                    this.setForeground(Color.green.darker());
                }
                if (((String)value).equals("Property is maybe satisfied.")) {
                    this.setForeground(Color.yellow.darker());
                }
                if (((String)value).startsWith("Established")) {
                    this.setForeground(new Color(130, 130, 130));
                }
                Verifier.this.queryList.repaint();
            }
            return this;
        }
    }

    class QueryRenderer
    extends JPanel
    implements ListCellRenderer {
        JLabel status;
        SpecialTextField text;
        ImageIcon select;
        ImageIcon okay;
        ImageIcon not;
        ImageIcon unknown;

        public QueryRenderer() {
            super(new GridBagLayout());
            this.setBorder(new EmptyBorder(0, 4, 0, 0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridheight = 0;
            URL url = ClassLoader.getSystemResource(Verifier.SELECT);
            this.select = url == null ? null : new ImageIcon(url);
            URL url2 = ClassLoader.getSystemResource(Verifier.UNKNOWN);
            this.unknown = url2 == null ? null : new ImageIcon(url2);
            URL url3 = ClassLoader.getSystemResource(Verifier.OKAY);
            this.okay = url3 == null ? null : new ImageIcon(url3);
            URL url4 = ClassLoader.getSystemResource(Verifier.NOT_OKAY);
            this.not = url4 == null ? null : new ImageIcon(url4);
            this.text = new SpecialTextField();
            this.status = new JLabel();
            this.status.setIcon(this.unknown);
            this.status.setPreferredSize(new Dimension(20, 20));
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 10;
            this.add((Component)this.text, c);
            c.weightx = 0.0;
            this.add((Component)this.status, c);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(list.getBackground());
            if (Verifier.this.queryVisible) {
                this.text.setText(((Property)value).getShortProperty());
            } else {
                this.text.setText(((Property)value).getComment());
            }
            switch (((Property)value).getStatus()) {
                case 4: {
                    this.status.setIcon(this.unknown);
                    break;
                }
                case 3: {
                    this.status.setIcon(this.unknown);
                    break;
                }
                case 1: {
                    this.status.setIcon(this.okay);
                    break;
                }
                case 2: {
                    this.status.setIcon(this.not);
                }
            }
            if (isSelected) {
                this.text.setBackground(list.getSelectionBackground());
                this.text.setForeground(list.getSelectionForeground());
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.text.setBackground(list.getBackground());
                this.text.setForeground(list.getForeground());
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            this.revalidate();
            return this;
        }
    }

    class PropertyListModel
    extends DefaultListModel {
        public PropertyListModel() {
            this.addNewProperty();
        }

        public void setStatus(int index, int status) {
            ((Property)this.elementAt(index)).setStatus(status);
            this.fireContentsChanged(this, index, index);
        }

        public int getStatus(int index) {
            return ((Property)this.elementAt(index)).getStatus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int parse(URL url) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                this.removeAllElements();
                while (reader.ready()) {
                    String s = reader.readLine();
                    if (s.length() <= 0 || s.startsWith("//")) continue;
                    StringBuffer comment = new StringBuffer();
                    if (s.equals("/*")) {
                        s = reader.readLine();
                        if (!s.equals("*/")) {
                            comment.append(s);
                            s = reader.readLine();
                            while (!s.equals("*/")) {
                                comment.append('\n').append(s);
                                s = reader.readLine();
                            }
                        }
                        s = reader.readLine();
                    }
                    StringBuffer property = new StringBuffer();
                    if (!s.equals("//NO_QUERY")) {
                        while (s.endsWith("\\")) {
                            property.append(s.substring(0, s.length() - 1)).append('\n');
                            s = reader.readLine();
                        }
                        property.append(s);
                    }
                    Property p = new Property();
                    p.setComment(new String(comment));
                    p.setProperty(new String(property));
                    this.addElement(p);
                }
            }
            finally {
                reader.close();
            }
            return this.size();
        }

        public void unparse(OutputStream os) throws IOException {
            OutputStreamWriter osw = new OutputStreamWriter(os);
            osw.write("//This file was generated from UPPAAL 3.5.3, Dec 2004\n");
            for (int i = 0; i < this.size(); ++i) {
                Property p = (Property)this.elementAt(i);
                osw.write("\n/*\n");
                osw.write(p.getComment() + "\n");
                osw.write("*/\n");
                String temp = p.getProperty();
                if (temp.trim().equals("")) {
                    temp = "//NO_QUERY";
                }
                int j = 0;
                int k = temp.indexOf(10);
                while (k > -1) {
                    osw.write(temp.substring(j, k) + "\\\n");
                    j = k + 1;
                    k = temp.indexOf(10, j);
                }
                osw.write(temp.substring(j) + "\n");
            }
            osw.flush();
        }

        public Property addNewProperty() {
            return this.addNewProperty(this.size());
        }

        public Property addNewProperty(int index) {
            Property theNew = new Property();
            theNew.getPropertyDocument().addDocumentListener(Verifier.this);
            theNew.getCommentDocument().addDocumentListener(Verifier.this);
            this.insertElementAt(theNew, index);
            return theNew;
        }
    }
}

