/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.verifier;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class VerificationDialog
extends JDialog {
    private JLabel note;
    private JProgressBar progress;
    private JFrame parent;
    private PropertyChangeListener buttonListener;

    public VerificationDialog(JFrame parent, PropertyChangeListener theListener) {
        super(parent, "UPPAAL Model Checker", false);
        this.parent = parent;
        this.buttonListener = theListener;
        this.createDialog();
    }

    private void createDialog() {
        this.note = new JLabel("Please wait...");
        this.progress = new JProgressBar();
        final JOptionPane pane = new JOptionPane(new Object[]{"Processing query", this.note, this.progress}, 1, 0, null, new String[]{"Cancel"});
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            public void windowClosing(WindowEvent we) {
                pane.setValue(null);
            }

            public void windowActivated(WindowEvent we) {
                if (!this.gotFocus) {
                    pane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        });
        final VerificationDialog d = this;
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (d.isVisible() && event.getSource() == pane && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                    VerificationDialog.this.buttonListener.propertyChange(event);
                }
            }
        });
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public void setNote(String text) {
        this.note.setText(text);
        this.pack();
    }

    public void setProgressBarLength(int length) {
        this.progress.setMaximum(length);
    }

    public void setPresentValue(int value) {
        this.progress.setValue(value);
    }
}

