/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.verifier;

import com.uppaal.engine.Engine;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.ProtocolException;
import com.uppaal.engine.RequestQuery;
import com.uppaal.gui.SystemInspector;
import com.uppaal.gui.simulator.Simulator;
import com.uppaal.gui.verifier.Property;
import com.uppaal.gui.verifier.VerificationDialog;
import com.uppaal.gui.verifier.Verifier;
import com.uppaal.model.system.UppaalSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verification
extends Thread {
    Simulator simulator;
    Verifier verifier;
    Engine engine;
    UppaalSystem system;
    Vector<Property> properties;
    VerificationDialog dialog;
    SystemInspector inspector;

    Verification(SystemInspector inspector, Vector<Property> properties) {
        this.inspector = inspector;
        this.engine = inspector.getEngine();
        this.system = inspector.getSystem();
        this.verifier = inspector.getVerifier();
        this.simulator = inspector.getSimulator();
        this.properties = properties;
    }

    @Override
    public void start() {
        this.dialog = new VerificationDialog(this.inspector, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                Verification.this.engine.kill();
                Verification.this.verifier.appendText("Operation cancelled!\n");
            }
        });
        super.start();
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
        this.dialog.dispose();
        this.dialog = null;
    }

    @Override
    public void run() {
        for (int i = 0; i < this.properties.size(); ++i) {
            this.engine.request(new Request(this.system, i));
        }
        this.engine.waitUntilIdle();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Verification.this.dialog.setVisible(false);
            }
        });
    }

    class Request
    extends RequestQuery {
        private Timer timer;
        private int number;

        public Request(UppaalSystem system, int number) {
            super(system, Verification.this.properties.get(number).getShortProperty());
            this.number = number;
        }

        protected void implementation() throws EngineException, ProtocolException, IOException {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Property property = Verification.this.properties.get(Request.this.number);
                    Verification.this.verifier.appendText(property.getShortProperty());
                    property.setStatus(4);
                    Verification.this.dialog.setNote("Verifying property " + (Request.this.number + 1) + " of " + Verification.this.properties.size() + ".");
                    Verification.this.dialog.setProgressBarLength(Verification.this.properties.size());
                    Verification.this.dialog.setPresentValue(Request.this.number);
                }
            });
            super.implementation();
        }

        protected void gotAnswer(final char result) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int status = 4;
                    switch (result) {
                        case 'T': {
                            Verification.this.verifier.appendText("Property is satisfied.");
                            status = 1;
                            break;
                        }
                        case 'M': {
                            Verification.this.verifier.appendText("Property is maybe satisfied.");
                            status = 3;
                            break;
                        }
                        case 'F': {
                            Verification.this.verifier.appendText("Property is not satisfied.");
                            status = 2;
                        }
                    }
                    Verification.this.properties.get(Request.this.number).setStatus(status);
                }
            });
        }

        protected void gotTraceLength(final int length) {
            this.timer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    Verification.this.dialog.setPresentValue(Request.this.getCurrentLength());
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Verification.this.dialog.setProgressBarLength(length);
                    Verification.this.dialog.setNote("Loading trace...");
                    Request.this.timer.start();
                }
            });
        }

        protected void gotTrace(final Vector tail, final Vector cycle) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Request.this.timer.stop();
                    if (tail != null && cycle != null) {
                        Verification.this.inspector.setEnabled(true);
                        if (Verification.this.simulator.canStoreTrace()) {
                            Verification.this.simulator.setTrace(tail, cycle);
                        }
                    }
                }
            });
        }
    }
}

