/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.verifier;

import com.uppaal.gui.verifier.OptionsChangedEvent;
import com.uppaal.gui.verifier.OptionsChangedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class Options {
    private EventListenerList listenerList = new EventListenerList();
    private Vector<Option> options = new Vector();
    private Map<String, Option> map = new HashMap<String, Option>();
    private JMenu menu;

    public Options(JMenu menu) {
        this.menu = menu;
        this.setInfoStructure(ClassLoader.getSystemResource("com/uppaal/resource/options.xml"));
    }

    public void setInfoStructure(URL url) {
        this.setInfoStructure(new InputSource(url.toString()));
    }

    public void setInfoStructure(String info) {
        this.setInfoStructure(new InputSource(new StringReader(info)));
    }

    private void setInfoStructure(InputSource source) {
        this.options.clear();
        this.menu.removeAll();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(source);
            NodeIterator i = ((DocumentTraversal)((Object)document)).createNodeIterator(document.getDocumentElement(), 1, null, false);
            Node node = i.nextNode();
            while (node != null) {
                if (node.getNodeName().equals("option")) {
                    Option option;
                    Element element = (Element)node;
                    String type = element.getAttribute("type");
                    if ("choice".equals(type)) {
                        option = new ChoiceOption(element.getAttribute("name"), element.getAttribute("display"), element.getAttribute("default"));
                        node = i.nextNode();
                        while (node.getNodeName().equals("choice")) {
                            element = (Element)node;
                            ((ChoiceOption)option).addChoice(element.getAttribute("name"), element.getAttribute("display"));
                            node = i.nextNode();
                        }
                        this.options.add(option);
                        continue;
                    }
                    if ("boolean".equals(type)) {
                        option = new BooleanOption(element.getAttribute("name"), element.getAttribute("display"), element.getAttribute("default"));
                        this.options.add(option);
                    }
                }
                node = i.nextNode();
            }
        }
        catch (Exception e) {
            System.err.println("error: Cannot read options specification");
        }
        for (Option option : this.options) {
            Option old = this.map.get(option.getName());
            if (old == null) continue;
            option.setValue(old.getValue());
        }
        this.map.clear();
        for (Option option : this.options) {
            this.map.put(option.getName(), option);
            this.menu.add(option.getMenuItem());
        }
    }

    public void addOptionsChangedListener(OptionsChangedListener ocl) {
        this.listenerList.add(OptionsChangedListener.class, ocl);
    }

    public void removeOptionsChangedListener(OptionsChangedListener ocl) {
        this.listenerList.remove(OptionsChangedListener.class, ocl);
    }

    protected void fireOptionsChanged(OptionsChangedEvent oce) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != OptionsChangedListener.class) continue;
            ((OptionsChangedListener)listeners[i + 1]).optionsChanged(oce);
        }
    }

    public boolean traceOn() {
        return !this.getOption("trace").equals("0");
    }

    public String getOption(String name) {
        Option option = this.map.get(name);
        if (option != null) {
            return option.getValue();
        }
        return "";
    }

    private void setOption(String name, String value) {
        Option option = this.map.get(name);
        option.setValue(value);
        if (name.equals("trace") && !value.equals("0")) {
            if (this.getOption("representation").equals("3")) {
                this.setOption("representation", "0");
            }
        } else if (name.equals("representation") && value.equals("3")) {
            if (!this.getOption("trace").equals("0")) {
                this.setOption("trace", "0");
            }
        } else if (name.equals("representation") && value.equals("2")) {
            if (this.getOption("reuse").equals("1")) {
                this.setOption("reuse", "0");
            }
        } else if (name.equals("reuse") && value.equals("1") && this.getOption("representation").equals("2")) {
            this.setOption("representation", "0");
        }
    }

    public String getTextualFormat() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Option option : this.options) {
            if (!first) {
                sb.append('\n');
            }
            first = false;
            sb.append(option.getName());
            sb.append(' ');
            sb.append(option.getValue());
        }
        return sb.toString();
    }

    class ChoiceOption
    extends Option {
        private Vector choices;

        public ChoiceOption(String name, String display, String value) {
            super(name, display, value);
            this.choices = new Vector();
        }

        protected void updateMenu() {
            if (this.menuItem != null && this.value != null) {
                this.getChoice(this.value).getMenuItem().setSelected(true);
            }
        }

        public List getChoices() {
            return this.choices;
        }

        public void addChoice(String name, String display) {
            this.choices.add(new Choice(name, display));
        }

        public Choice getChoice(String name) {
            for (Choice choice : this.choices) {
                if (!name.equals(choice.getName())) continue;
                return choice;
            }
            return null;
        }

        public JMenuItem getMenuItem() {
            if (this.menuItem == null) {
                JMenu m = new JMenu(this.display);
                ButtonGroup g = new ButtonGroup();
                for (Choice choice : this.choices) {
                    JRadioButtonMenuItem b = new JRadioButtonMenuItem(choice.toString());
                    b.setActionCommand(choice.getName());
                    m.add(b);
                    g.add(b);
                    b.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Options.this.setOption(ChoiceOption.this.name, e.getActionCommand());
                            Options.this.fireOptionsChanged(new OptionsChangedEvent(Options.this));
                        }
                    });
                    choice.setMenuItem(b);
                }
                this.setMenuItem(m);
            }
            return this.menuItem;
        }
    }

    class BooleanOption
    extends Option {
        public BooleanOption(String name, String display, String value) {
            super(name, display, value);
        }

        public JMenuItem getMenuItem() {
            if (this.menuItem == null) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.display);
                item.setActionCommand(this.name);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        boolean state = ((JCheckBoxMenuItem)e.getSource()).getState();
                        Options.this.setOption(e.getActionCommand(), state ? "1" : "0");
                        Options.this.fireOptionsChanged(new OptionsChangedEvent(Options.this));
                    }
                });
                this.setMenuItem(item);
            }
            return this.menuItem;
        }

        protected void updateMenu() {
            if (this.menuItem != null && this.value != null) {
                this.menuItem.setSelected(this.value.equals("1"));
            }
        }
    }

    abstract class Option
    extends Choice {
        protected String value;
        protected String defaultValue;

        public Option(String name, String display, String value) {
            super(name, display);
            this.defaultValue = value;
            this.value = value;
        }

        public String toString() {
            return this.display;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String s) {
            this.value = s;
            this.updateMenu();
        }

        public void setMenuItem(JMenuItem item) {
            super.setMenuItem(item);
            this.updateMenu();
        }

        protected abstract void updateMenu();
    }

    class Choice {
        protected String name;
        protected String display;
        protected JMenuItem menuItem;

        public Choice(String name, String display) {
            this.name = name;
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        public String getName() {
            return this.name;
        }

        public void setMenuItem(JMenuItem item) {
            this.menuItem = item;
        }

        public JMenuItem getMenuItem() {
            return this.menuItem;
        }
    }
}

