/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.tree;

import com.uppaal.gui.tree.DomToTreeModelAdapter;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Template;
import com.uppaal.util.ObservablePointer;
import java.awt.Component;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class DomTree
extends JTree
implements Observer {
    protected static final String TEMP_ICON = "com/uppaal/resource/images/templateicon.gif";
    private ObservablePointer element;

    public DomTree(ObservablePointer document, final ObservablePointer element) {
        super(new DomToTreeModelAdapter(document, element));
        MyRenderer renderer = new MyRenderer();
        this.setCellRenderer(renderer);
        this.setCellEditor(new MyEditor(this, renderer));
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(true);
        this.setInvokesStopCellEditing(true);
        this.expandRow(0);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                element.pointTo(DomTree.this.getLastSelectedPathComponent());
            }
        });
        element.addObserver(this);
        this.element = element;
    }

    public void update(Observable o, Object arg) {
        Element node = (Element)this.element.dereference();
        if (node != null) {
            int depth = 0;
            for (Element p = node; p != null; p = p.getParent()) {
                ++depth;
            }
            Object[] path = new Object[depth];
            --depth;
            while (depth >= 0) {
                path[depth] = node;
                node = node.getParent();
                --depth;
            }
            this.setSelectionPath(new TreePath(path));
        } else {
            this.clearSelection();
        }
    }

    public boolean isPathEditable(TreePath path) {
        return path.getLastPathComponent() instanceof Template;
    }

    private class MyEditor
    extends DefaultTreeCellEditor {
        public MyEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row) {
            if (value instanceof Template) {
                Element element = (Element)value;
                String label = element.getPropertyValue("#tree.label").toString();
                String caption = element.getPropertyValue(label).toString();
                return super.getTreeCellEditorComponent(tree, caption, sel, expanded, leaf, row);
            }
            return null;
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon templateIcon;

        public MyRenderer() {
            URL url = ClassLoader.getSystemResource(DomTree.TEMP_ICON);
            this.templateIcon = url == null ? null : new ImageIcon(url);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Element element = (Element)value;
            String label = element.getPropertyValue("#tree.label").toString();
            String caption = element.getPropertyValue(label).toString();
            super.getTreeCellRendererComponent(tree, caption, sel, expanded, leaf, row, hasFocus);
            if (value instanceof Template) {
                this.setIcon(this.templateIcon);
            }
            return this;
        }
    }
}

