/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.tree;

import com.uppaal.gui.tree.TreeVisitor;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;
import com.uppaal.util.ObservablePointer;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomToTreeModelAdapter
implements TreeModel {
    private EventListenerList listenerList = new EventListenerList();
    private ObservablePointer document;
    private ObservablePointer element;
    Visitor adder = new TreeVisitor(){

        public void visitTreeNode(Element element, String label) {
            element.addListener(DomToTreeModelAdapter.this.listener);
            element.getProperty(label).addListener(DomToTreeModelAdapter.this.propertyChangeListener);
        }
    };
    Visitor remover = new TreeVisitor(){

        public void visitTreeNode(Element element, String label) {
            element.removeListener(DomToTreeModelAdapter.this.listener);
            element.getProperty(label).removeListener(DomToTreeModelAdapter.this.propertyChangeListener);
        }
    };
    private EventListener listener = new AbstractEventListener(){

        public void afterInsertion(Node parent, Node node) {
            Object current = DomToTreeModelAdapter.this.element.dereference();
            DomToTreeModelAdapter.this.rebuild((Document)DomToTreeModelAdapter.this.document.dereference());
            DomToTreeModelAdapter.this.element.pointTo(current);
        }

        public void afterRemoval(Node parent, Node node) {
            DomToTreeModelAdapter.this.rebuild((Document)DomToTreeModelAdapter.this.document.dereference());
        }
    };
    private EventListener propertyChangeListener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            Element node = source.getParent();
            Element parent = node.getParent();
            Object[] children = new Object[]{node};
            int[] indices = new int[]{DomToTreeModelAdapter.this.getIndexOfChild(parent, node)};
            TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(parent), indices, children);
            DomToTreeModelAdapter.this.fireNodesChanged(event);
        }
    };

    public DomToTreeModelAdapter(ObservablePointer document, ObservablePointer element) {
        this.document = document;
        this.element = element;
        document.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                DomToTreeModelAdapter.this.updateDocument((Document)arg);
            }
        });
        this.updateDocument(null);
    }

    private void rebuild(Document document) {
        document.acceptSafe(new AbstractVisitor(){

            private Property getNonNullLocalProperty(Element element, String name) {
                Property property = element.getLocalProperty(name);
                if (property == null) {
                    property = element.setProperty(name, "");
                }
                return property;
            }

            public void visitDocument(Document document) throws Exception {
                Vector<Element> children = new Vector<Element>();
                children.add(document.getProperty("declaration"));
                for (Node node = document.getFirst(); node != null; node = node.getNext()) {
                    children.add(node);
                }
                children.add(this.getNonNullLocalProperty(document, "instantiation"));
                children.add(this.getNonNullLocalProperty(document, "system"));
                document.setProperty("#tree.children", children);
                super.visitDocument(document);
            }

            public void visitTemplate(Template template) throws Exception {
                Vector<Property> children = new Vector<Property>();
                children.add(this.getNonNullLocalProperty(template, "declaration"));
                template.setProperty("#tree.children", children);
            }
        });
        this.fireStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.getRoot())));
    }

    private void updateDocument(Document doc) {
        if (doc != null) {
            doc.getPrototype().acceptSafe(this.remover);
        }
        if ((doc = (Document)this.document.dereference()) != null) {
            doc.getPrototype().acceptSafe(this.adder);
            this.rebuild(doc);
        }
    }

    @Override
    public Object getRoot() {
        return this.document.dereference();
    }

    private Vector<Element> getChildren(Object parent) {
        return (Vector)((Element)parent).getPropertyValue("#tree.children");
    }

    @Override
    public boolean isLeaf(Object aNode) {
        return this.getChildren(aNode) == null;
    }

    @Override
    public int getChildCount(Object parent) {
        Vector<Element> children = this.getChildren(parent);
        return children == null ? 0 : children.size();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getChildren(parent).get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getChildren(parent).indexOf(child);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object last = path.getLastPathComponent();
        if (last instanceof Template) {
            ((Template)last).setProperty("name", newValue.toString());
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    private void fireNodesChanged(TreeModelEvent e) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
            }
        }
    }

    private void fireNodesInserted(TreeModelEvent e) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
            }
        }
    }

    private void fireNodesRemoved(TreeModelEvent e) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
            }
        }
    }

    private void fireStructureChanged(TreeModelEvent e) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
            }
        }
    }
}

