/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.engine.LexicalAnalyser;
import com.uppaal.engine.ProtocolException;
import com.uppaal.gui.simulator.Simulator;
import com.uppaal.model.system.Pts;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.SystemTransition;
import com.uppaal.model.system.UppaalSystem;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class TraceModel
extends AbstractListModel {
    private Simulator simulator;
    private SystemState initial;
    private Vector trace;
    private int tail;

    public TraceModel(Simulator sim) {
        this.simulator = sim;
        this.trace = new Vector();
        this.tail = 0;
        this.initial = null;
    }

    public void clear(SystemState init) {
        this.initial = init;
        if (this.initial != null) {
            this.setTrace(new Vector(), new Vector());
        } else if (this.getSize() > 0) {
            int size = this.getSize();
            this.trace = new Vector();
            this.tail = 0;
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    public void insert(int pos, SystemTransition trans, SystemState state) {
        int size = this.trace.size();
        if (pos >= 0 && pos < size - 1) {
            if (pos % 2 == 1) {
                --pos;
            }
            for (int i = size - 1; i > pos; --i) {
                this.trace.remove(i);
            }
            this.fireIntervalRemoved(this, pos + 1, size - 1);
        }
        this.trace.addElement(trans);
        this.trace.addElement(state);
        this.tail = this.trace.size();
        this.fireIntervalAdded(this, this.trace.size() - 2, this.trace.size() - 1);
    }

    public void setTrace(Vector tail, Vector cycle) {
        Pts pts;
        int i;
        this.tail = 2 * tail.size() + 1;
        int oldsize = this.trace.size();
        this.trace = new Vector();
        this.trace.add(this.initial);
        for (i = 0; i < tail.size(); ++i) {
            pts = (Pts)tail.get(i);
            this.trace.add(pts.theTransition());
            this.trace.add(pts.theState());
        }
        for (i = 0; i < cycle.size(); ++i) {
            pts = (Pts)cycle.get(i);
            this.trace.add(pts.theTransition());
            this.trace.add(pts.theState());
        }
        int newsize = this.trace.size();
        if (newsize < oldsize) {
            this.fireIntervalRemoved(this, newsize, oldsize - 1);
        }
        this.fireContentsChanged(this, 0, newsize - 1);
        if (newsize > oldsize) {
            this.fireIntervalAdded(this, oldsize, newsize - 1);
        }
    }

    public void unfold() {
        SystemTransition transition = (SystemTransition)this.trace.get(this.tail);
        this.trace.add(transition);
        this.trace.add(this.simulator.getSuccessor(transition));
        this.tail += 2;
        this.fireContentsChanged(this, this.tail - 2, this.tail - 1);
        this.fireIntervalAdded(this, this.trace.size() - 2, this.trace.size() - 1);
    }

    public int getTail() {
        return this.tail;
    }

    public boolean isState(int index) {
        return (index & 1) == 0;
    }

    public boolean isTransition(int index) {
        return (index & 1) == 1;
    }

    public boolean isInCycle(int index) {
        return index >= this.getTail() || index == this.getSize() - 1;
    }

    public boolean hasCycle() {
        return this.getTail() < this.getSize();
    }

    public boolean isLast(int index) {
        return index == this.getSize() - 1;
    }

    public int getLast() {
        return this.getSize() - 1;
    }

    public int getSize() {
        return this.trace.size();
    }

    public Object getElementAt(int index) {
        return this.trace.get(index);
    }

    private Pts getPts(int pos) {
        return new Pts((SystemTransition)this.trace.get(2 * pos + 1), (SystemState)this.trace.get(2 * pos + 2));
    }

    public void loadTrace(UppaalSystem system, InputStream in) throws IOException, ProtocolException {
        LexicalAnalyser lex = new LexicalAnalyser(in);
        lex.nextToken();
        this.initial = SystemState.create(system, lex);
        Vector<Pts> trace = new Vector<Pts>();
        while (lex.nextToken() != 1) {
            trace.addElement(Pts.create(system, lex));
        }
        this.setTrace(trace, new Vector());
    }

    public void saveTrace(OutputStream s) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(s));
        out.write(this.initial.getTextualFormat());
        out.write(10);
        for (int i = 0; i < this.trace.size() / 2; ++i) {
            out.write(this.getPts(i).toString());
        }
        out.write(".\n");
        out.close();
    }
}

