/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.engine.ProtocolException;
import com.uppaal.gui.Main;
import com.uppaal.gui.simulator.Simulator;
import com.uppaal.gui.simulator.TraceModel;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.SystemTransition;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.util.files.FileHandle;
import com.uppaal.util.files.GUIFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Trace
extends JPanel {
    private static String OverwriteWarning = "Warning: this will destroy a part of the current trace! Continue?";
    private static final String REPLAY = "replay";
    private static final String RANDOM = "random";
    private static final String PREV = "prev";
    private static final String NEXT = "next";
    private static final String LOADTRACE = "loadTrace";
    private static final String SAVETRACE = "saveTrace";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private UppaalSystem system;
    private Timer caller;
    private boolean randomEnabled = true;
    private boolean random = false;
    private boolean replay = false;
    private FileHandle traceFile;
    private Simulator simulator;
    private JList traceList;
    private JTextField fileName;
    private JToggleButton randomButton;
    private JToggleButton replayButton;
    private JSlider slider;
    private TraceModel trace;

    public Trace(Simulator sim, UppaalSystem system) {
        super(new BorderLayout());
        this.simulator = sim;
        this.system = system;
        this.trace = new TraceModel(this.simulator);
        this.getActionMap().put(PREV, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Trace.this.prev();
            }
        });
        this.getActionMap().put(NEXT, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Trace.this.next();
            }
        });
        this.getActionMap().put(FIRST, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Trace.this.first();
            }
        });
        this.getActionMap().put(LAST, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Trace.this.last();
            }
        });
        this.getActionMap().put(REPLAY, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!Trace.this.replay) {
                    Trace.this.startReplay();
                } else {
                    Trace.this.stopReplay();
                }
            }
        });
        this.getActionMap().put(RANDOM, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!Trace.this.random) {
                    Trace.this.startRandom();
                } else {
                    Trace.this.stopRandom();
                }
            }
        });
        this.getActionMap().put(LOADTRACE, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Trace.this.loadTrace();
            }
        });
        this.getActionMap().put(SAVETRACE, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Trace.this.saveTrace();
            }
        });
        this.initPanel();
    }

    public void reinit(UppaalSystem system, SystemState initial) {
        this.system = system;
        this.trace.clear(initial);
        if (initial != null) {
            this.setIndex(0);
        } else {
            this.traceList.clearSelection();
        }
        this.syncButtons();
    }

    public boolean append(SystemTransition trans, SystemState state) {
        int pos = this.getIndex();
        if (pos >= 0 && !this.trace.isLast(pos) && !Main.choiceError.errorMessage(OverwriteWarning)) {
            return false;
        }
        this.trace.insert(pos, trans, state);
        this.setIndex(this.trace.getLast());
        return true;
    }

    public void setTrace(Vector tail, Vector cycle) {
        this.trace.setTrace(tail, cycle);
        this.setIndex(this.trace.getLast());
        this.syncButtons();
    }

    public void setEnabled(boolean enabled) {
        this.setActionEnabled(RANDOM, enabled && this.randomEnabled);
        this.setActionEnabled(REPLAY, enabled);
        this.setActionEnabled(LOADTRACE, enabled);
        this.setActionEnabled(SAVETRACE, enabled);
        this.syncButtons();
    }

    public void setRandomEnabled(boolean enabled) {
        if (this.randomEnabled != enabled) {
            this.randomEnabled = enabled;
            this.setActionEnabled(RANDOM, enabled);
        }
    }

    private void first() {
        if (this.trace.getSize() > 0) {
            this.setIndex(0);
        }
    }

    private void last() {
        if (this.trace.getSize() > 0) {
            this.setIndex(this.trace.getSize() - 1);
        }
    }

    public TraceModel getModel() {
        return this.trace;
    }

    public ListSelectionModel getSelectionModel() {
        return this.traceList.getSelectionModel();
    }

    private JButton createButton(String text, String tip, String action) {
        JButton btn = new JButton(this.getActionMap().get(action));
        btn.setText(text);
        btn.setToolTipText(tip);
        btn.setFocusable(false);
        return btn;
    }

    private JToggleButton createToggle(String text, String tip, String action) {
        JToggleButton btn = new JToggleButton(this.getActionMap().get(action));
        btn.setToolTipText(tip);
        btn.setText(text);
        btn.setFocusable(false);
        return btn;
    }

    private void initPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(0, 3));
        buttonPanel.add(this.createButton("Prev", "Go to previous step in trace.", PREV));
        buttonPanel.add(this.createButton("Next", "Go to next step in trace.", NEXT));
        this.replayButton = this.createToggle("Replay", "Replay trace from current position.", REPLAY);
        buttonPanel.add(this.replayButton);
        buttonPanel.add(this.createButton("Open", "Open trace file.", LOADTRACE));
        buttonPanel.add(this.createButton("Save", "Save trace file.", SAVETRACE));
        this.randomButton = this.createToggle("Random", "Start random simulation.", RANDOM);
        buttonPanel.add(this.randomButton);
        JPanel wrapper = new JPanel(new FlowLayout(1, 0, 0));
        wrapper.add(buttonPanel);
        this.slider = new JSlider(60, 120, 90);
        this.slider.setMajorTickSpacing(10);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        ((Dictionary)labels).put(60, new JLabel("Fast", 4));
        ((Dictionary)labels).put(120, new JLabel("Slow", 2));
        this.slider.setLabelTable(labels);
        this.slider.setInverted(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (Trace.this.caller != null) {
                    Trace.this.caller.setDelay(Trace.this.getDelay());
                }
            }
        });
        Box namePanel = new Box(0);
        namePanel.add(new JLabel("Trace File:"));
        namePanel.add(Box.createHorizontalStrut(12));
        this.fileName = new JTextField(5);
        this.fileName.setEditable(false);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.fileName, "Center");
        namePanel.add(p);
        Box topPanel = new Box(1);
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(namePanel);
        topPanel.add(Box.createVerticalStrut(6));
        topPanel.add(wrapper);
        topPanel.add(Box.createVerticalStrut(5));
        topPanel.add(this.slider);
        TraceCellRenderer renderer = new TraceCellRenderer();
        this.traceList = new JList(this.trace);
        this.traceList.setVisibleRowCount(2);
        this.traceList.setSelectionMode(0);
        ListSelectionListener listener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Trace.this.syncButtons();
            }
        };
        this.traceList.addListSelectionListener(listener);
        this.traceList.setCellRenderer(renderer);
        this.traceList.setFixedCellHeight(renderer.getPreferredSize().height);
        this.traceList.setFixedCellWidth(buttonPanel.getPreferredSize().width - 18);
        JScrollPane scrollPane = new JScrollPane(this.traceList);
        int height = scrollPane.getPreferredSize().height;
        scrollPane.setPreferredSize(new Dimension(40, 42));
        this.add((Component)scrollPane, "Center");
        this.add((Component)topPanel, "South");
    }

    public int getIndex() {
        return this.traceList.getSelectedIndex();
    }

    private void setIndex(int pos) {
        this.traceList.setSelectedIndex(pos);
        this.traceList.ensureIndexIsVisible(pos);
        this.traceList.revalidate();
    }

    private void setActionEnabled(String action, boolean enabled) {
        Action act = this.getActionMap().get(action);
        if (act != null) {
            act.setEnabled(enabled);
        }
    }

    private void syncButtons() {
        int pos = this.getIndex();
        this.setActionEnabled(PREV, pos > 0 && this.caller == null);
        this.setActionEnabled(NEXT, !this.trace.isLast(pos) && this.caller == null || this.trace.hasCycle());
    }

    private int getDelay() {
        return (int)Math.pow(2.0, (double)this.slider.getValue() / 10.0);
    }

    private FileHandle getTraceFile() {
        if (this.traceFile == null) {
            this.traceFile = new FileHandle(null, "Trace File Dialog");
            this.traceFile.addFilter(new GUIFileFilter("xtr", "UPPAAL Trace File"));
        }
        return this.traceFile;
    }

    private void loadTrace() {
        FileHandle file = this.getTraceFile();
        try {
            if (file.ask("Open Trace File")) {
                this.fileName.setText(file.fullName());
                FileInputStream in = file.inStream();
                if (in == null) {
                    throw new FileNotFoundException();
                }
                this.trace.loadTrace(this.system, in);
                ((InputStream)in).close();
            }
        }
        catch (FileNotFoundException e) {
            Main.infoError.errorMessage("Could not open file " + file.fullName());
        }
        catch (IOException e) {
            Main.infoError.errorMessage("IO Exception");
        }
        catch (ProtocolException e) {
            Main.infoError.errorMessage("This is not a valid trace file");
        }
    }

    private void saveTrace() {
        FileHandle file = this.getTraceFile();
        if (!file.ask("Save Trace File")) {
            return;
        }
        this.fileName.setText(file.fullName());
        try {
            FileOutputStream s = file.outStream();
            if (s == null) {
                Main.infoError.errorMessage("there is no file where I can save this");
                return;
            }
            this.trace.saveTrace(s);
            ((OutputStream)s).close();
        }
        catch (FileNotFoundException e) {
            Main.infoError.errorMessage("File not found:" + e.getMessage());
        }
        catch (IOException e) {
            Main.infoError.errorMessage("IOException:" + e.getMessage());
        }
    }

    private void next() {
        int pos = this.getIndex();
        if (pos < 0) {
            this.setIndex(0);
        } else if (!this.trace.isLast(pos)) {
            this.setIndex(pos + 1);
        } else if (this.trace.isLast(pos) && this.trace.hasCycle()) {
            this.trace.unfold();
            this.setIndex(pos + 1);
        }
    }

    private void prev() {
        int pos = this.getIndex();
        if (pos < 0) {
            this.setIndex(this.trace.getLast());
        } else if (pos > 0) {
            this.setIndex(pos - 1);
        }
    }

    private void startReplay() {
        if (this.caller == null) {
            this.setActionEnabled(REPLAY, true);
            this.setActionEnabled(RANDOM, false);
            this.setActionEnabled(LOADTRACE, false);
            this.setActionEnabled(SAVETRACE, false);
            this.setActionEnabled(PREV, false);
            this.setActionEnabled(NEXT, false);
            this.simulator.setEnabledForRandom(false);
            this.caller = new Timer(this.getDelay(), new ReplayStepper());
            this.caller.start();
            this.replayButton.setSelected(true);
            this.replay = true;
        }
    }

    private void stopReplay() {
        if (this.caller != null) {
            this.caller.stop();
            this.caller = null;
            this.simulator.setEnabledForRandom(true);
            this.setEnabled(true);
            this.replayButton.setSelected(false);
            this.replay = false;
        }
    }

    private void startRandom() {
        if (this.caller == null) {
            int delay = this.getDelay();
            this.setActionEnabled(REPLAY, false);
            this.setActionEnabled(RANDOM, true);
            this.setActionEnabled(LOADTRACE, false);
            this.setActionEnabled(SAVETRACE, false);
            this.setActionEnabled(PREV, false);
            this.setActionEnabled(NEXT, false);
            this.simulator.setEnabledForRandom(false);
            this.caller = new Timer(delay, new RandomStepper());
            this.caller.start();
            this.randomButton.setSelected(true);
            this.random = true;
        }
    }

    private void stopRandom() {
        if (this.caller != null) {
            this.caller.stop();
            this.caller = null;
            this.simulator.setEnabledForRandom(true);
            this.setEnabled(true);
            this.randomButton.setSelected(false);
            this.random = false;
        }
    }

    private class RandomStepper
    implements ActionListener {
        private RandomStepper() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!Trace.this.simulator.takeRandomStep(Math.random())) {
                Trace.this.stopRandom();
            }
        }
    }

    private class ReplayStepper
    implements ActionListener {
        private ReplayStepper() {
        }

        public void actionPerformed(ActionEvent e) {
            if (Trace.this.trace.isLast(Trace.this.getIndex())) {
                Trace.this.stopReplay();
                return;
            }
            if (Trace.this.trace.isState(Trace.this.getIndex()) || Trace.this.getIndex() == Trace.this.trace.getSize() - 2) {
                Trace.this.setIndex(Trace.this.getIndex() + 1);
            } else {
                Trace.this.setIndex(Trace.this.getIndex() + 2);
            }
            if (Trace.this.trace.isLast(Trace.this.getIndex())) {
                Trace.this.stopReplay();
                return;
            }
        }
    }

    class TraceCellRenderer
    extends JTextField
    implements ListCellRenderer {
        private final Border grayBorder = LineBorder.createGrayLineBorder();
        private final Border emptyBorder = new EmptyBorder(1, 1, 1, 1);

        TraceCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = Trace.this.trace.isState(index) ? ((SystemState)value).traceFormat() : ((SystemTransition)value).traceFormat();
            this.setBorder(cellHasFocus ? this.grayBorder : this.emptyBorder);
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
            }
            this.setForeground(Trace.this.trace.isInCycle(index) ? Color.red : list.getForeground());
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }
}

