/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.util.MultiChooser2;
import com.uppaal.util.ObservablePointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SystemStatePanel
extends JPanel {
    private JTextArea myText;
    private JScrollPane textScrollPane;
    private ObservablePointer system;
    private ObservablePointer currState;
    private JMenuBar menuBar;
    private JMenu varMenu;
    private JMenuItem mit;
    private JCheckBoxMenuItem dbm;
    private boolean showFullDBM = true;
    private boolean[] oldVisible;
    private boolean[] visible;
    private boolean restrictedZoneFlag = false;

    public SystemStatePanel(ObservablePointer system, ObservablePointer state) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.myText = new JTextArea(0, 10);
        this.myText.setEditable(false);
        this.myText.setBackground(GraphicsElement.PROCESS_FILL_COL);
        this.myText.setForeground(new Color(0, 0, 0));
        this.textScrollPane = new JScrollPane(this.myText, 20, 31);
        this.add((Component)this.textScrollPane, "Center");
        this.system = system;
        system.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                SystemStatePanel.this.createMenus();
                SystemStatePanel.this.createVisibleArray();
            }
        });
        this.currState = state;
        state.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                SystemStatePanel.this.showState();
            }
        });
        this.createVisibleArray();
    }

    private UppaalSystem getSystem() {
        return (UppaalSystem)this.system.dereference();
    }

    public void setMenuBar(JMenuBar newMenuBar) {
        this.menuBar = newMenuBar;
        this.varMenu = (JMenu)this.menuBar.getSubElements()[3];
        this.mit = this.varMenu.add(new JMenuItem("Variables..."));
        this.mit.setEnabled(false);
        this.mit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SystemStatePanel.this.selectVariables();
            }
        });
        this.dbm = (JCheckBoxMenuItem)this.varMenu.add(new JCheckBoxMenuItem("Full DBM"));
        this.dbm.setMnemonic('D');
        this.dbm.setState(this.showFullDBM);
        this.dbm.setEnabled(false);
        this.dbm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SystemStatePanel.this.showFullDBM = !SystemStatePanel.this.showFullDBM;
                SystemStatePanel.this.showState();
            }
        });
        this.createMenus();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, super.getPreferredSize().height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, super.getMinimumSize().height);
    }

    private void showState() {
        if (this.getState() != null) {
            StringBuffer s = new StringBuffer();
            Vector<Integer> v = this.getState().getVariables();
            for (int i = 0; i < v.size(); ++i) {
                if (this.visible != null && !this.visible[i]) continue;
                s.append(this.getSystem().getVariableName(i));
                s.append(" = ");
                s.append(v.get(i).toString());
                s.append("\n");
            }
            Polyhedron p = this.getState().getPolyhedron();
            if (this.showFullDBM) {
                s.append(p.dbmAsString());
            } else {
                s.append(p.toString());
            }
            s.append("\n");
            this.myText.setText(s.toString());
        } else {
            this.myText.setText("");
        }
    }

    private void selectVariables() {
        int no = this.getSystem().getNoOfVariables();
        String[] variables = new String[no];
        for (int i = 0; i < no; ++i) {
            variables[i] = this.getSystem().getVariableName(i);
        }
        if (MultiChooser2.show((JFrame)this.menuBar.getTopLevelAncestor(), "Visible Variables", variables, this.visible)) {
            this.showState();
        }
    }

    private void createMenus() {
        this.mit.setEnabled(this.getSystem() != null);
        this.dbm.setEnabled(this.getSystem() != null);
    }

    private void createVisibleArray() {
        if (this.getSystem() != null) {
            int no = this.getSystem().getNoOfVariables();
            if (this.visible == null || no != this.visible.length) {
                this.visible = new boolean[no];
                while (no-- > 0) {
                    this.visible[no] = true;
                }
            }
        } else {
            this.visible = null;
        }
    }

    private String menuDisplayLine(String varName) {
        return "Show " + varName;
    }

    private String extractVarName(String menuDisplayLine) {
        return menuDisplayLine.substring(5);
    }

    private SystemState getState() {
        return (SystemState)this.currState.dereference();
    }

    public void setRestrictedZoneFlag(boolean value) {
        if (value != this.restrictedZoneFlag) {
            this.restrictedZoneFlag = value;
            if (value) {
                this.myText.setForeground(new Color(49, 101, 255));
            } else {
                this.myText.setForeground(Color.BLACK);
            }
        }
    }
}

