/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.engine.Engine;
import com.uppaal.engine.EngineException;
import com.uppaal.engine.RequestEnabledTransitions;
import com.uppaal.engine.RequestInitial;
import com.uppaal.engine.RequestSuccessor;
import com.uppaal.gui.Main;
import com.uppaal.gui.ModePanel;
import com.uppaal.gui.SystemInspector;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.simulator.ChoiceModel;
import com.uppaal.gui.simulator.JMSCLog;
import com.uppaal.gui.simulator.LineFlowLayout;
import com.uppaal.gui.simulator.PTDisplayPanel;
import com.uppaal.gui.simulator.SystemStatePanel;
import com.uppaal.gui.simulator.Trace;
import com.uppaal.gui.simulator.TraceModel;
import com.uppaal.model.core2.Location;
import com.uppaal.model.io2.PSWriter;
import com.uppaal.model.system.LocationVector;
import com.uppaal.model.system.Pts;
import com.uppaal.model.system.SystemEdge;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.SystemTransition;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.util.MultiChooser2;
import com.uppaal.util.ObservablePointer;
import com.uppaal.util.files.FileHandle;
import com.uppaal.util.files.GUIFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simulator
extends JPanel
implements ComponentListener {
    private static String LoadWarning = "Storing the new trace in the simulator will\ndestroy the old one. Continue?";
    private static final int DIST = 5;
    private static final int SPACE = 10;
    private SystemInspector inspector;
    private JMenuItem processMenuItem;
    private PTDisplayPanel[] processDisplayPanel;
    private SystemStatePanel statePanel;
    private JPanel mainArea;
    private JMSCLog mscLog;
    private JSplitPane mainSplit;
    private ModePanel outerPanel;
    private ModePanel innerPanel;
    private JPanel controlPanel;
    private FileHandle psFile;
    private JScrollPane scrollPane;
    private JPanel stepPanel;
    private JList choiceList = null;
    private Engine engine;
    private int noOfProcesses;
    private ObservablePointer<UppaalSystem> system;
    private SystemState currentState;
    private ObservablePointer<SystemState> visibleState = new ObservablePointer();
    private Trace myTrace;
    private ChoiceModel choices;
    private int requests = 0;

    private JButton createButton(String text, String tip, String action) {
        JButton btn = new JButton(this.getActionMap().get(action));
        btn.setText(text);
        btn.setToolTipText(tip);
        btn.setFocusable(false);
        return btn;
    }

    private JLabel createCenteredLabel(String text) {
        JLabel l = new JLabel(text);
        l.setAlignmentX(0.5f);
        return l;
    }

    private void setActionEnabled(String action, boolean enabled) {
        Action act = this.getActionMap().get(action);
        if (act != null) {
            act.setEnabled(enabled);
        }
    }

    public Simulator(SystemInspector theFrame, ObservablePointer<UppaalSystem> theSystem, Engine theEngine) {
        super(new BorderLayout());
        this.inspector = theFrame;
        this.engine = theEngine;
        this.system = theSystem;
        this.myTrace = new Trace(this, null);
        this.choices = new ChoiceModel(new Vector<Pts>());
        this.myTrace.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Simulator.this.traceSelectionChanged();
            }
        });
        ActionMap actions = this.getActionMap();
        actions.put("selectPrev", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int pos = Simulator.this.choiceList.getSelectedIndex();
                if (pos > 0 && pos < Simulator.this.choices.getSize()) {
                    Simulator.this.choiceList.setSelectedIndex(pos - 1);
                }
                if (Simulator.this.choices.getSize() > 0 && (pos == -1 || pos > Simulator.this.choices.getSize())) {
                    Simulator.this.choiceList.setSelectedIndex(Simulator.this.choices.getSize() - 1);
                }
            }
        });
        actions.put("selectNext", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int pos = Simulator.this.choiceList.getSelectedIndex();
                if (pos >= 0 && pos < Simulator.this.choices.getSize() - 1) {
                    Simulator.this.choiceList.setSelectedIndex(pos + 1);
                }
                if (Simulator.this.choices.getSize() > 0 && (pos == -1 || pos > Simulator.this.choices.getSize())) {
                    Simulator.this.choiceList.setSelectedIndex(0);
                }
            }
        });
        actions.put("step", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Simulator.this.takeStep();
            }
        });
        actions.put("toggle", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (Simulator.this.choices.getSize() > 0) {
                    int idx = Simulator.this.choiceList.getSelectedIndex();
                    if (idx == -1) {
                        idx = Simulator.this.choiceList.getLeadSelectionIndex();
                        if (idx >= 0 && idx < Simulator.this.choices.getSize()) {
                            Simulator.this.choiceList.setSelectedIndex(idx);
                        }
                    } else {
                        Simulator.this.choiceList.clearSelection();
                    }
                }
            }
        });
        actions.put("prev", this.myTrace.getActionMap().get("prev"));
        actions.put("next", this.myTrace.getActionMap().get("next"));
        actions.put("first", this.myTrace.getActionMap().get("first"));
        actions.put("last", this.myTrace.getActionMap().get("last"));
        actions.put("replay", this.myTrace.getActionMap().get("replay"));
        actions.put("random", this.myTrace.getActionMap().get("random"));
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("Z"), "selectPrev");
        inputMap.put(KeyStroke.getKeyStroke("X"), "selectNext");
        inputMap.put(KeyStroke.getKeyStroke("Q"), "prev");
        inputMap.put(KeyStroke.getKeyStroke("A"), "next");
        inputMap.put(KeyStroke.getKeyStroke("P"), "replay");
        inputMap.put(KeyStroke.getKeyStroke("R"), "random");
        inputMap.put(KeyStroke.getKeyStroke("F"), "first");
        inputMap.put(KeyStroke.getKeyStroke("L"), "last");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "step");
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "toggle");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        buttonPanel.add(this.createButton("Next", "Perform selected transition.", "step"));
        buttonPanel.add(this.createButton("Reset", "Reset system to inital state.", "first"));
        JPanel wrapper = new JPanel(new FlowLayout(1, 0, 0));
        wrapper.add(buttonPanel);
        this.statePanel = new SystemStatePanel(this.system, this.visibleState);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.choiceList = new JList(this.choices);
        this.choiceList.setSelectionMode(0);
        this.choiceList.setVisibleRowCount(2);
        this.choiceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int pos = Simulator.this.choiceList.getSelectedIndex();
                if (pos >= 0 && pos < Simulator.this.choices.getSize()) {
                    Simulator.this.setVisibleState(Simulator.this.choices.getState(pos));
                    Simulator.this.setActionEnabled("step", true);
                } else {
                    Simulator.this.setVisibleState(Simulator.this.getCurrentState());
                    Simulator.this.setActionEnabled("step", false);
                }
                Simulator.this.updateSelectedTransition();
            }
        });
        this.choiceList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = Simulator.this.choiceList.locationToIndex(e.getPoint());
                    Action action = Simulator.this.getActionMap().get("step");
                    if (action.isEnabled()) {
                        action.actionPerformed(null);
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.choiceList);
        scrollPane.setPreferredSize(new Dimension(40, 42));
        Box top = new Box(1);
        top.add(Box.createVerticalStrut(5));
        top.add(wrapper);
        this.stepPanel = new JPanel();
        this.stepPanel.setLayout(new BorderLayout());
        this.stepPanel.add((Component)scrollPane, "Center");
        this.stepPanel.add((Component)top, "South");
        this.controlPanel = this.createControlPanel();
        this.mscLog = new JMSCLog(this.system, this.myTrace.getModel(), this.myTrace.getSelectionModel());
        this.mainArea = new JPanel();
        this.mainArea.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.mainArea.setBackground(GraphicsElement.PROCESS_FILL_COL);
        this.psFile = new FileHandle(this.inspector, "Encapsulated Postscript File");
        this.psFile.addFilter(new GUIFileFilter("eps", "Encapsulated PS File"));
        scrollPane = new JScrollPane(this.mainArea, 20, 30);
        scrollPane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        scrollPane.getVerticalScrollBar().setUnitIncrement(32);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(32);
        this.mainSplit = new JSplitPane(0, scrollPane, this.mscLog);
        this.mainSplit.setOneTouchExpandable(true);
        this.innerPanel = new ModePanel();
        this.innerPanel.setLeftComponent(this.statePanel, "Variables");
        this.innerPanel.setMainArea(this.mainSplit);
        this.innerPanel.resetToPreferredSizes();
        this.outerPanel = new ModePanel();
        this.outerPanel.addComponentListener(this);
        this.outerPanel.setLeftComponent(this.controlPanel, "Simulation Control");
        this.outerPanel.setMainArea(this.innerPanel);
        this.outerPanel.resetToPreferredSizes();
        this.add((Component)this.outerPanel, "Center");
        this.system.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Simulator.this.systemChanged();
            }
        });
        this.systemChanged();
        this.visibleState.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Simulator.this.visibleStateChanged((SystemState)arg);
            }
        });
    }

    public void setMenuBar(JMenuBar menuBar) {
        JMenu viewMenu = (JMenu)menuBar.getSubElements()[3];
        this.processMenuItem = new JMenuItem("Processes...");
        viewMenu.addSeparator();
        viewMenu.add(this.processMenuItem);
        this.processMenuItem.setEnabled(this.noOfProcesses > 0);
        this.processMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Simulator.this.selectVisibleProcesses();
            }
        });
        this.statePanel.setMenuBar(menuBar);
    }

    private UppaalSystem getSystem() {
        return this.system.get();
    }

    private void loadInitialState() {
        if (this.getSystem() != null) {
            ++this.requests;
            this.engine.request(new GetInitial(this.getSystem()));
        }
    }

    private JPanel createControlPanel() {
        JLabel label = this.createCenteredLabel("Enabled Transitions");
        Box is = new Box(1);
        is.add(label);
        is.add(Box.createVerticalStrut(6));
        is.add(this.stepPanel);
        label.setLabelFor(this.choiceList);
        label.setDisplayedMnemonic('E');
        Box gs = new Box(1);
        gs.add(Box.createVerticalStrut(11));
        gs.add(this.createCenteredLabel("Simulation Trace"));
        gs.add(Box.createVerticalStrut(6));
        gs.add(this.myTrace);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(12, 12, 11, 11));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 0.3;
        panel.add((Component)is, gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.7;
        panel.add((Component)gs, gbc);
        return panel;
    }

    public void hideProcess(String name) {
        int index = this.getSystem().getProcessIndex(name);
        if (index > -1) {
            this.processDisplayPanel[index].setVisible(false);
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    public void setTrace(Vector tail, Vector cycle) {
        this.myTrace.setTrace(tail, cycle);
        this.traceSelectionChanged();
    }

    public boolean canStoreTrace() {
        return JOptionPane.showConfirmDialog(this.inspector, LoadWarning, "Load Trace", 0) == 0;
    }

    public void setEnabledForRandom(boolean enabled) {
        this.setActionEnabled("step", enabled && this.getTransition() != null);
        this.inspector.getVerifier().setEnabled(enabled);
    }

    public void setEnabledForMC(boolean enabled) {
    }

    public void setEnabledAll(boolean enabled) {
    }

    public void increaseZoom() {
        for (int i = 0; i < this.noOfProcesses; ++i) {
            this.processDisplayPanel[i].increaseZoom();
        }
        this.mainArea.revalidate();
    }

    public void decreaseZoom() {
        for (int i = 0; i < this.noOfProcesses; ++i) {
            this.processDisplayPanel[i].decreaseZoom();
        }
        this.mainArea.revalidate();
    }

    public void normalZoom() {
        for (int i = 0; i < this.noOfProcesses; ++i) {
            this.processDisplayPanel[i].normalZoom();
        }
        this.mainArea.revalidate();
    }

    public void setZoom(float zoom) {
        for (int i = 0; i < this.noOfProcesses; ++i) {
            this.processDisplayPanel[i].setZoom(zoom);
        }
        this.mainArea.revalidate();
    }

    public void printSystem() {
    }

    public boolean closing() {
        return this.outerPanel.closing() && this.innerPanel.closing();
    }

    private void initialiseProcessViews() {
        UppaalSystem system = this.getSystem();
        this.noOfProcesses = system.getNoOfProcesses();
        this.processMenuItem.setEnabled(this.noOfProcesses > 0);
        this.mainArea.removeAll();
        this.mainArea.setLayout(new LineFlowLayout(0, 5, 5));
        this.processDisplayPanel = new PTDisplayPanel[this.noOfProcesses];
        for (int i = 0; i < this.noOfProcesses; ++i) {
            this.processDisplayPanel[i] = new PTDisplayPanel(this, system.getProcess(i).getName(), system.getProcess(i).getTemplate(), system.getProcess(i).getTranslator());
            this.mainArea.add(this.processDisplayPanel[i]);
        }
    }

    public void selectVisibleProcesses() {
        int i;
        String[] processes = new String[this.noOfProcesses];
        boolean[] visible = new boolean[this.noOfProcesses];
        for (i = 0; i < this.noOfProcesses; ++i) {
            processes[i] = this.getSystem().getProcess(i).getName();
            visible[i] = this.processDisplayPanel[i].isVisible();
        }
        if (MultiChooser2.show(this.inspector, "Visible Processes", processes, visible)) {
            for (i = 0; i < this.noOfProcesses; ++i) {
                this.processDisplayPanel[i].setVisible(visible[i]);
            }
            this.mainArea.revalidate();
            this.mainArea.repaint();
        }
    }

    public void systemChanged() {
        this.myTrace.reinit(null, null);
        this.mainArea.removeAll();
        if (this.getSystem() != null) {
            this.initialiseProcessViews();
            this.loadInitialState();
            if (this.mainSplit != null) {
                this.mainSplit.setDividerLocation(0.7);
            }
            this.setEnabledAll(true);
        } else {
            this.noOfProcesses = 0;
            this.processDisplayPanel = null;
            this.setEnabledAll(false);
        }
        this.normalZoom();
        this.repaint();
    }

    private SystemTransition getTransition() {
        int idx = this.choiceList.getSelectedIndex();
        if (idx >= 0 && idx < this.choices.getSize()) {
            return this.choices.getTransition(idx);
        }
        return null;
    }

    private SystemState getCurrentState() {
        return this.currentState;
    }

    private SystemState getVisibleState() {
        return this.visibleState.get();
    }

    private void setCurrentState(SystemState state) {
        this.currentState = state;
    }

    private void setVisibleState(SystemState state) {
        this.visibleState.set(state);
    }

    private void traceSelectionChanged() {
        SystemState state;
        int index = this.myTrace.getIndex();
        TraceModel model = this.myTrace.getModel();
        if (index < 0 || index >= model.getSize()) {
            this.setCurrentState(null);
            this.setVisibleState(null);
            this.choiceList.clearSelection();
            this.setChoices(new Vector());
            return;
        }
        if (model.isTransition(index)) {
            --index;
        }
        if ((state = (SystemState)model.getElementAt(index)).equals(this.getCurrentState())) {
            this.syncChoiceSelection();
            return;
        }
        this.choiceList.clearSelection();
        this.setChoices(new Vector());
        this.setCurrentState(state);
        this.setVisibleState(state);
        if (this.engine.isConnected() && state != null) {
            ++this.requests;
            this.engine.request(new RequestEnabledTransitions(this.getSystem(), state){

                public void finished(final Vector v) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Simulator.this.setChoices(v);
                            Simulator.this.syncChoiceSelection();
                            Simulator.this.requests--;
                        }
                    });
                }

                public void error(Throwable e) throws Throwable {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Simulator.this.requests--;
                        }
                    });
                    throw e;
                }
            });
        }
    }

    private void syncChoiceSelection() {
        int index = this.myTrace.getIndex();
        TraceModel model = this.myTrace.getModel();
        if (index >= 0 && index < model.getSize()) {
            if (model.isTransition(index)) {
                int pos = this.choices.getIndexOf((SystemTransition)model.getElementAt(index));
                if (pos >= 0 && pos < this.choices.getSize()) {
                    this.choiceList.setSelectedIndex(pos);
                    this.choiceList.ensureIndexIsVisible(pos);
                    this.choiceList.revalidate();
                }
            } else if (model.isLast(index)) {
                index = (int)((double)this.choices.getSize() * Math.random());
                this.choiceList.setSelectedIndex(index);
                this.choiceList.ensureIndexIsVisible(index);
                this.choiceList.revalidate();
            } else {
                this.choiceList.clearSelection();
            }
        } else {
            this.choiceList.clearSelection();
        }
    }

    private void visibleStateChanged(SystemState old) {
        SystemState state = this.getVisibleState();
        if (state != null) {
            LocationVector loc = state.getLocationVector();
            for (int i = 0; i < this.noOfProcesses; ++i) {
                this.processDisplayPanel[i].setLocation(loc.get(i).getLocation());
            }
        } else {
            for (int i = 0; i < this.noOfProcesses; ++i) {
                this.processDisplayPanel[i].setLocation((Location)null);
            }
        }
    }

    private void updateSelectedTransition() {
        for (int i = 0; i < this.noOfProcesses; ++i) {
            this.processDisplayPanel[i].setEdge(null);
        }
        int index = this.choiceList.getSelectedIndex();
        if (index >= 0 && index < this.choices.getSize()) {
            SystemTransition t = this.choices.getTransition(index);
            for (SystemEdge edge : t.getEdges()) {
                this.processDisplayPanel[edge.getProcess().getIndex()].setEdge(edge.getEdge());
            }
            this.statePanel.setRestrictedZoneFlag(true);
        } else {
            this.statePanel.setRestrictedZoneFlag(false);
        }
    }

    void saveTemplatePostscript(PTDisplayPanel panel) {
        if (this.psFile.ask("Save Postscript") && (!this.psFile.exists() || Main.choiceError.errorMessage("Overwrite " + this.psFile.getName() + "?"))) {
            try {
                Rectangle2D bnds = panel.view.getModelBounds();
                FileOutputStream out = this.psFile.outStream();
                panel.template.accept(new PSWriter(out, "", bnds, panel.translator));
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                Main.infoError.errorMessage("Error Saving Templates as Postscript: " + e.getMessage());
            }
        }
    }

    SystemState getSuccessor(SystemTransition t) {
        final ObservablePointer result = new ObservablePointer();
        ++this.requests;
        this.engine.request(new RequestSuccessor(this.getSystem(), this.getCurrentState(), t){

            public void finished(SystemState s) {
                result.pointTo(s);
            }
        });
        this.engine.waitUntilIdle();
        --this.requests;
        return (SystemState)result.dereference();
    }

    public void setChoices(Vector vec) {
        this.choices = new ChoiceModel(vec);
        this.choiceList.setModel(this.choices);
    }

    public boolean takeStep() {
        if (this.choices.getSize() == 0 || this.getTransition().getSize() == 0) {
            Main.showMessageDialog(this.inspector, "deadlockNotice", 1);
            return false;
        }
        SystemState successor = this.getSuccessor(this.getTransition());
        if (successor == null) {
            Main.showMessageDialog(this.inspector, "badSuccessorNotice", 1);
            return false;
        }
        return this.myTrace.append(this.getTransition(), successor);
    }

    public boolean takeRandomStep(double randomNumber) {
        if (this.requests > 0) {
            return true;
        }
        if (this.choices.getSize() == 0) {
            Main.showMessageDialog(this.inspector, "deadlockNotice", 1);
            return false;
        }
        int index = (int)((double)this.choices.getSize() * randomNumber);
        this.choiceList.setSelectedIndex(index);
        return this.takeStep();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private class GetInitial
    extends RequestInitial {
        public GetInitial(UppaalSystem system) {
            super(system);
        }

        public void finished(final SystemState init) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Simulator.this.myTrace.reinit(Simulator.this.getSystem(), init);
                    Simulator.this.requests--;
                }
            });
        }

        public void error(Throwable e) throws Throwable {
            if (!(e instanceof EngineException)) {
                throw e;
            }
            final String msg = e.getMessage();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Simulator.this.requests--;
                    Main.infoError.errorMessage("Cannot retrieve initial state: " + msg);
                }
            });
        }
    }
}

