/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.gui.Main;
import com.uppaal.gui.canvas.SimulationLabelViewHandler;
import com.uppaal.gui.canvas.SimulationLocationViewHandler;
import com.uppaal.gui.canvas.SimulationTransitionViewHandler;
import com.uppaal.gui.canvas.TemplateView;
import com.uppaal.gui.canvas.TemplateViewHandler;
import com.uppaal.gui.simulator.Simulator;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Template;
import com.uppaal.model.system.Translator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PTDisplayPanel
extends JPanel
implements MouseListener {
    private String name;
    TemplateView view;
    Template template;
    Translator translator;
    private Simulator simulator;
    private static final int minWidth = 160;
    private static final int minHeight = 120;
    private SimulationLocationViewHandler locationHandler;
    private SimulationTransitionViewHandler transitionHandler;

    public PTDisplayPanel(Simulator aSimulator, String aName, Template aTemplate, Translator aTranslator) {
        super(new BorderLayout());
        this.setBorder(new LineBorder(Color.black));
        this.simulator = aSimulator;
        this.name = aName;
        this.template = aTemplate;
        this.translator = aTranslator;
        this.locationHandler = new SimulationLocationViewHandler(10);
        this.transitionHandler = new SimulationTransitionViewHandler(8);
        TemplateViewHandler[] handlers = new TemplateViewHandler[]{new SimulationLabelViewHandler(10, "#location", "name", this.translator), new SimulationLabelViewHandler(10, "#location", "invariant", this.translator), new SimulationLabelViewHandler(10, "#edge", "guard", this.translator), new SimulationLabelViewHandler(10, "#edge", "assignment", this.translator), new SimulationLabelViewHandler(10, "#edge", "synchronisation", this.translator), this.transitionHandler, this.locationHandler};
        this.view = new TemplateView(handlers);
        this.view.addMouseListener(this);
        this.view.setGridOn(false);
        this.view.setDocument(this.template.getDocument());
        this.view.setTemplate(this.template);
        JPanel wrapper = new JPanel();
        wrapper.add(this.view);
        wrapper.setBorder(new EmptyBorder(5, 5, 5, 5));
        wrapper.setBackground(Color.white);
        JLabel header = new JLabel(this.name);
        header.setBorder(new EmptyBorder(1, 3, 1, 3));
        header.setOpaque(true);
        header.setBackground(new Color(230, 230, 230, 230));
        header.setForeground(new Color(49, 101, 255));
        header.setFont(new Font("SansSerif", 1, 12));
        this.add((Component)header, "North");
        this.add((Component)wrapper, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PTDisplayPanel.this.view.center();
            }
        });
    }

    public void setLocation(Location location) {
        this.locationHandler.setCurrent(location);
    }

    public void setEdge(Edge edge) {
        this.transitionHandler.setCurrent(edge);
    }

    public void increaseZoom() {
        this.setZoom((8.0 * this.getZoom() + 2.0) / 8.0);
    }

    public void decreaseZoom() {
        this.setZoom(Math.max((8.0 * this.getZoom() - 2.0) / 8.0, 0.25));
    }

    public void normalZoom() {
        this.setZoom(Main.defaultSimulatorZoom);
    }

    public void setZoom(double zoom) {
        this.view.setZoom(zoom);
    }

    public double getZoom() {
        return this.view.getZoom();
    }

    public Dimension getMinimumSize() {
        return new Dimension(160, 120);
    }

    public void mousePressed(MouseEvent e) {
        if (e.isAltDown() || e.isMetaDown()) {
            JPopupMenu menu = new JPopupMenu("Process " + this.name);
            JMenuItem mit = new JMenuItem("Zoom In");
            menu.add(mit);
            mit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent otherE) {
                    PTDisplayPanel.this.increaseZoom();
                }
            });
            mit = new JMenuItem("Zoom Normal");
            menu.add(mit);
            mit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent otherE) {
                    PTDisplayPanel.this.normalZoom();
                }
            });
            mit = new JMenuItem("Zoom Out");
            menu.add(mit);
            mit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent otherE) {
                    PTDisplayPanel.this.decreaseZoom();
                }
            });
            menu.addSeparator();
            mit = new JMenuItem("Hide");
            menu.add(mit);
            mit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent otherE) {
                    PTDisplayPanel.this.simulator.hideProcess(PTDisplayPanel.this.name);
                }
            });
            menu.addSeparator();
            mit = new JMenuItem("Save Postscript");
            menu.add(mit);
            mit.setEnabled(!Main.demo);
            mit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent otherE) {
                    PTDisplayPanel.this.simulator.saveTemplatePostscript(PTDisplayPanel.this);
                }
            });
            menu.show(this.view, e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public Dimension realSize() {
        Dimension dim = this.view.getPreferredSize();
        return new Dimension(dim.width + 5, dim.height + 5);
    }
}

