/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.gui.simulator.JMSCLog;
import com.uppaal.model.system.LocationVector;
import com.uppaal.model.system.SystemState;
import com.uppaal.model.system.SystemTransition;
import com.uppaal.model.system.UppaalSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class JMSCLogView
extends JComponent
implements Scrollable,
MouseMotionListener,
MouseListener,
FocusListener,
KeyListener {
    private static final Color mouseOverColor = new Color(230, 230, 230);
    private static final Color mouseOverChangedColor = new Color(240, 240, 240);
    private static final Color selectionColor = new Color(185, 194, 226);
    private static final Color selectionFocusColor = new Color(165, 174, 206);
    private static final Color locationColorA = new Color(226, 156, 156);
    private static final Color locationColorB = new Color(206, 207, 255);
    private static final Color locationColorC = new Color(185, 115, 115);
    private static final Color locationColorD = new Color(165, 174, 206);
    private static final Color locationLabelColor = new Color(70, 70, 70);
    private JMSCLog jml = null;
    private boolean change = false;
    private int current = -1;
    private int currentShown = -1;
    private Point mouse;
    int[] wid;
    int[] cen;
    int[] edg;
    boolean widthsCalculated = false;
    private Font messageFont;
    private Font locationFont;
    private Font headerFont;

    JMSCLogView(JMSCLog jml) {
        this.jml = jml;
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.messageFont = new Font(JMSCLog.logMessageFontName, JMSCLog.logMessageFontStyle, JMSCLog.logMessageFontSize);
        this.locationFont = new Font(JMSCLog.logStateFontName, JMSCLog.logStateFontStyle, JMSCLog.logStateFontSize);
        this.headerFont = new Font(JMSCLog.headerFontName, JMSCLog.headerFontStyle, JMSCLog.headerFontSize);
    }

    int sLength(Graphics g, String s) {
        return (int)g.getFontMetrics().getStringBounds(s, g).getWidth();
    }

    void calcWidths(Graphics g) {
        UppaalSystem system = this.jml.getSystem();
        if (this.jml.model == null || system == null || this.jml.model.getSize() == 0) {
            return;
        }
        int pc = system.getNoOfProcesses();
        int states = (this.jml.model.getSize() + 1) / 2;
        if (pc == 0) {
            return;
        }
        this.wid = new int[pc];
        this.cen = new int[pc];
        this.edg = new int[pc];
        int sum = 0;
        for (int i = 0; i < pc; ++i) {
            g.setFont(this.headerFont);
            int max = this.sLength(g, system.getProcess(i).getName());
            g.setFont(this.locationFont);
            for (int j = 0; j < states; ++j) {
                int wid;
                SystemState state = (SystemState)this.jml.model.getElementAt(2 * j);
                LocationVector loc = state.getLocationVector();
                String s = loc.get(i).getName();
                if (s == null) {
                    s = "-";
                }
                if ((wid = this.sLength(g, s) + 4) <= max) continue;
                max = wid;
            }
            this.wid[i] = max;
            this.edg[i] = JMSCLog.logLeftMargin + sum + i * JMSCLog.logEventHorizontalSpacing;
            this.cen[i] = this.edg[i] + this.wid[i] / 2;
            sum += this.wid[i];
        }
        this.widthsCalculated = true;
    }

    public void paint(Graphics g) {
        int j;
        SystemTransition trans;
        this.revalidate();
        UppaalSystem system = this.jml.getSystem();
        Rectangle drawHere = g.getClipBounds();
        g.setColor(Color.white);
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        if (this.jml.model == null || system == null || this.jml.model.getSize() == 0) {
            return;
        }
        if (this.current >= this.jml.model.getSize()) {
            this.current = -1;
        }
        if (this.currentShown >= this.jml.model.getSize()) {
            this.currentShown = -1;
        }
        if (!this.widthsCalculated) {
            this.calcWidths(g);
        }
        int wi = this.getWidth();
        int processes = system.getNoOfProcesses();
        int transitions = this.jml.model.getSize() / 2;
        int states = transitions + 1;
        if (this.currentShown != -1) {
            g.setColor(mouseOverColor);
            g.fillRect(0, this.currentShown * JMSCLog.logEventHeight + JMSCLog.logTopMargin + 15, wi, JMSCLog.logEventHeight);
            if (this.change) {
                g.setColor(mouseOverChangedColor);
                g.fillRect(0, this.currentShown * JMSCLog.logEventHeight + 2 + JMSCLog.logTopMargin + 15, wi, JMSCLog.logEventHeight - 4);
            }
        }
        if (this.current != -1) {
            g.setColor(selectionColor);
            g.fillRect(0, this.current * JMSCLog.logEventHeight + 2 + JMSCLog.logTopMargin + 15, wi, JMSCLog.logEventHeight - 4);
            if (this.hasFocus()) {
                g.setColor(selectionFocusColor);
                g.drawRect(1, this.current * JMSCLog.logEventHeight + 2 + JMSCLog.logTopMargin + 16, wi - 3, JMSCLog.logEventHeight - 7);
            }
        }
        g.setColor(Color.black);
        for (int i = 0; i < processes; ++i) {
            g.drawRect(this.edg[i], JMSCLog.logTopMargin, this.wid[i], 5);
            g.drawLine(this.cen[i], JMSCLog.logTopMargin + 5, this.cen[i], JMSCLog.logTopMargin + 15);
        }
        g.setFont(this.locationFont);
        int firstState = (int)(drawHere.getY() - (double)JMSCLog.logTopMargin - 15.0) / (JMSCLog.logEventHeight * 2);
        int lastState = Math.min((int)(drawHere.getY() + drawHere.getHeight() - (double)JMSCLog.logTopMargin - 15.0) / (JMSCLog.logEventHeight * 2), states - 1);
        for (int j2 = firstState; j2 <= lastState; ++j2) {
            boolean isTail = this.jml.isTail(j2 - 1);
            int y = j2 * JMSCLog.logEventHeight * 2 + JMSCLog.logTopMargin + 15;
            for (int i = 0; i < processes; ++i) {
                boolean draw = true;
                g.setColor(isTail ? Color.red : Color.black);
                g.drawLine(this.cen[i], y, this.cen[i], y + JMSCLog.logEventHeight);
                if (j2 > 0) {
                    trans = (SystemTransition)this.jml.model.getElementAt(2 * j2 - 1);
                    draw = trans.involvesProcess(i);
                }
                if (!draw && this.currentShown != j2 * 2) continue;
                SystemState state = (SystemState)this.jml.model.getElementAt(2 * j2);
                LocationVector loc = state.getLocationVector();
                String s = loc.get(i).getName();
                if (s == null) {
                    s = "-";
                }
                int w = this.sLength(g, s) + 10;
                if (draw) {
                    g.setColor(isTail ? locationColorC : locationColorD);
                } else {
                    g.setColor(isTail ? locationColorA : locationColorB);
                }
                g.fillRoundRect(this.cen[i] - w / 2, y + JMSCLog.logEventMargin, w + 1, JMSCLog.logEventHeight - JMSCLog.logEventMargin * 2, JMSCLog.logRoundCorner, JMSCLog.logRoundCorner);
                g.setColor(draw ? Color.black : locationLabelColor);
                g.drawRoundRect(this.cen[i] - w / 2, y + JMSCLog.logEventMargin, w, JMSCLog.logEventHeight - JMSCLog.logEventMargin * 2 - 1, JMSCLog.logRoundCorner, JMSCLog.logRoundCorner);
                int hi = g.getFontMetrics().getAscent() - g.getFontMetrics().getLeading() - g.getFontMetrics().getDescent();
                g.drawString(s, this.cen[i] - w / 2 + 6, y + hi + (JMSCLog.logEventHeight - hi) / 2);
            }
        }
        int firstTransition = (int)(drawHere.getY() - (double)JMSCLog.logTopMargin - 15.0 - (double)JMSCLog.logEventHeight) / (2 * JMSCLog.logEventHeight);
        int lastTransition = Math.min((int)(drawHere.getY() + drawHere.getHeight() - (double)JMSCLog.logTopMargin - 15.0 - (double)JMSCLog.logEventHeight) / (2 * JMSCLog.logEventHeight), transitions - 1);
        for (j = firstTransition; j <= lastTransition; ++j) {
            boolean isTail = this.jml.isTail(j);
            int y = (2 * j + 1) * JMSCLog.logEventHeight + JMSCLog.logTopMargin + 15;
            trans = (SystemTransition)this.jml.model.getElementAt(2 * j + 1);
            g.setColor(isTail ? Color.red : Color.black);
            for (int i = 0; i < processes; ++i) {
                g.drawLine(this.cen[i], y, this.cen[i], y + JMSCLog.logEventHeight);
                if (!trans.involvesProcess(i)) continue;
                g.drawLine(this.cen[i], y + JMSCLog.logEventMargin + JMSCLog.logEventHeight, this.cen[i] - JMSCLog.logArrowWidth, y + JMSCLog.logEventMargin - JMSCLog.logArrowLength + JMSCLog.logEventHeight);
                g.drawLine(this.cen[i], y + JMSCLog.logEventMargin + JMSCLog.logEventHeight, this.cen[i] + JMSCLog.logArrowWidth, y + JMSCLog.logEventMargin - JMSCLog.logArrowLength + JMSCLog.logEventHeight);
            }
        }
        g.setFont(this.messageFont);
        g.setColor(Color.red);
        for (j = firstTransition; j <= lastTransition; ++j) {
            SystemTransition trans2 = (SystemTransition)this.jml.model.getElementAt(2 * j + 1);
            if (trans2.getSize() <= 1) continue;
            boolean before = false;
            boolean after = false;
            int y = j * JMSCLog.logEventHeight * 2 + JMSCLog.logTopMargin + 15 + (int)((double)JMSCLog.logEventHeight * 1.5);
            int start = trans2.getEdge(0).getProcess().getIndex();
            String name = trans2.getEdge(0).getName();
            name = name.substring(0, name.length() - 1);
            for (int i = 1; i < trans2.getSize(); ++i) {
                int end = trans2.getEdge(i).getProcess().getIndex();
                g.drawLine(this.cen[start], y, this.cen[end], y);
                if (start < end) {
                    g.drawLine(this.cen[end], y, this.cen[end] - JMSCLog.logArrowLength, y - JMSCLog.logArrowWidth);
                    g.drawLine(this.cen[end], y, this.cen[end] - JMSCLog.logArrowLength, y + JMSCLog.logArrowWidth);
                    before = true;
                    continue;
                }
                g.drawLine(this.cen[end], y, this.cen[end] + JMSCLog.logArrowLength, y - JMSCLog.logArrowWidth);
                g.drawLine(this.cen[end], y, this.cen[end] + JMSCLog.logArrowLength, y + JMSCLog.logArrowWidth);
                after = true;
            }
            if (before) {
                g.drawString(name, this.cen[start] + 5, y - 3);
            }
            if (!after) continue;
            g.drawString(name, this.cen[start] - 3 - this.sLength(g, name), y - 3);
        }
        g.setColor(Color.black);
        for (int i = 0; i < processes; ++i) {
            int y = states * JMSCLog.logEventHeight + transitions * JMSCLog.logEventHeight;
            g.drawLine(this.cen[i], y + JMSCLog.logTopMargin + 15, this.cen[i], y + JMSCLog.logTopMargin + 25);
            g.fillRect(this.edg[i], y + JMSCLog.logTopMargin + 25, this.wid[i], 5);
        }
    }

    public Dimension getPreferredSize() {
        UppaalSystem system = this.jml.getSystem();
        if (!this.widthsCalculated || system == null) {
            return new Dimension(0, this.jml.model.getSize() * JMSCLog.logEventHeight + 50);
        }
        int processes = system.getNoOfProcesses();
        return new Dimension(this.wid[processes - 1] + this.edg[processes - 1], this.jml.model.getSize() * JMSCLog.logEventHeight + 50);
    }

    public void mouseMoved(MouseEvent e) {
        int old = this.currentShown;
        this.currentShown = e.getPoint().y - JMSCLog.logTopMargin - 15;
        if (this.currentShown >= 0) {
            this.currentShown /= JMSCLog.logEventHeight;
            if (this.currentShown >= this.jml.model.getSize()) {
                this.currentShown = -1;
            }
        } else {
            this.currentShown = -1;
        }
        if (old != this.currentShown) {
            if (old != -1) {
                this.repaint(0, old * JMSCLog.logEventHeight + JMSCLog.logTopMargin + 15, this.getWidth(), JMSCLog.logEventHeight);
            }
            if (this.currentShown != -1) {
                this.repaint(0, this.currentShown * JMSCLog.logEventHeight + JMSCLog.logTopMargin + 15, this.getWidth(), JMSCLog.logEventHeight);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
        this.addMouseMotionListener(this);
    }

    public void mouseExited(MouseEvent e) {
        this.removeMouseMotionListener(this);
        this.currentShown = -1;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.grabFocus();
        this.change = true;
        this.repaint();
    }

    public void setSelectionIndex(int n) {
        int old = this.current;
        this.change = false;
        int n2 = this.current = n >= 0 && n < this.jml.model.getSize() ? n : -1;
        if (old != this.current) {
            this.jml.selection.setSelectionInterval(this.current, this.current);
        }
        this.currentShown = -1;
        this.repaint();
    }

    public void ensureIndexIsVisible() {
        this.revalidate();
        this.repaint();
        this.scrollRectToVisible(new Rectangle(0, this.current * JMSCLog.logEventHeight + JMSCLog.logTopMargin + 15, this.getWidth(), JMSCLog.logEventHeight));
    }

    public void mouseReleased(MouseEvent e) {
        this.setSelectionIndex((e.getPoint().y - JMSCLog.logTopMargin - 15) / JMSCLog.logEventHeight);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return JMSCLog.logEventHeight;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public boolean isFocusable() {
        return true;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int n;
        if (e.getKeyCode() == 40 && this.current < this.jml.model.getSize() - 1) {
            n = this.current + 1;
            this.setSelectionIndex(n);
        }
        if (e.getKeyCode() == 38 && this.current > 0) {
            n = this.current - 1;
            this.setSelectionIndex(n);
        }
    }

    public void keyTyped(KeyEvent e) {
    }
}

