/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.gui.simulator.JMSCLog;
import com.uppaal.model.system.UppaalSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class JMSCLogHeader
extends JComponent {
    private JMSCLog jml;
    private Font font;
    private static final Color bgColor = new Color(230, 230, 230);
    private static final Color fontColor = new Color(49, 101, 255);

    public JMSCLogHeader(JMSCLog jml) {
        this.jml = jml;
        this.font = new Font(JMSCLog.headerFontName, JMSCLog.headerFontStyle, JMSCLog.headerFontSize);
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.jml.jmlv.getPreferredSize();
        return new Dimension(dim.width, JMSCLog.headerHeight);
    }

    public void paint(Graphics g) {
        this.revalidate();
        Rectangle drawHere = g.getClipBounds();
        g.setColor(bgColor);
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setColor(Color.black);
        g.drawLine(drawHere.x, JMSCLog.headerHeight - 1, drawHere.x + drawHere.width, JMSCLog.headerHeight - 1);
        UppaalSystem system = this.jml.getSystem();
        if (this.jml.model == null || system == null || this.jml.model.getSize() == 0) {
            return;
        }
        if (!this.jml.jmlv.widthsCalculated) {
            this.jml.jmlv.calcWidths(g);
        }
        int processes = system.getNoOfProcesses();
        int transitions = this.jml.model.getSize() / 2;
        int states = transitions + 1;
        g.setColor(fontColor);
        g.setFont(this.font);
        for (int i = 0; i < processes; ++i) {
            String name = system.getProcess(i).getName();
            g.drawString(name, 1 + this.jml.jmlv.edg[i] + (this.jml.jmlv.wid[i] - this.jml.jmlv.sLength(g, name)) / 2, 13);
        }
    }
}

