/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.simulator;

import com.uppaal.gui.UppaalOptions;
import com.uppaal.gui.simulator.JMSCLogHeader;
import com.uppaal.gui.simulator.JMSCLogView;
import com.uppaal.gui.simulator.TraceModel;
import com.uppaal.model.system.UppaalSystem;
import com.uppaal.util.ObservablePointer;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JMSCLog
extends JScrollPane
implements ListDataListener,
ListSelectionListener {
    JMSCLogView jmlv;
    JMSCLogHeader header;
    public static String headerFontName = "SansSerif";
    public static int headerFontStyle = 1;
    public static int headerFontSize = 12;
    public static int headerHeight = 18;
    public static String timeLineFontName = "SansSerif";
    public static int timeLineFontSize = 9;
    public static int timeLineWidth = 16;
    public static String logStateFontName = "SansSerif";
    public static int logStateFontStyle = 0;
    public static int logStateFontSize = 12;
    public static String logMessageFontName = "SansSerif";
    public static int logMessageFontStyle = 0;
    public static int logMessageFontSize = 10;
    public static int logEventHeight = 30;
    public static int logEventMargin = 5;
    public static int logRoundCorner = 5;
    public static int logTopMargin = 10;
    public static int logLeftMargin = 10;
    public static int logEventHorizontalSpacing = 10;
    public static int logArrowLength = logRoundCorner * 2;
    public static int logArrowWidth = logArrowLength / 3;
    ListModel model;
    ListSelectionModel selection;
    private ObservablePointer system;
    private TraceModel trace;

    public static void saveOptions() {
        try {
            UppaalOptions.getOptionsFrom(Class.forName("com.uppaal.gui.simulator.JMSCLog"), "msc");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public JMSCLog(ObservablePointer system, TraceModel trace, ListSelectionModel select) {
        this.system = system;
        this.trace = trace;
        this.model = trace;
        this.selection = select;
        this.jmlv = new JMSCLogView(this);
        this.header = new JMSCLogHeader(this);
        this.setViewportView(this.jmlv);
        this.setColumnHeaderView(this.header);
        this.model.addListDataListener(this);
        this.selection.addListSelectionListener(this);
        system.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                JMSCLog.this.jmlv.widthsCalculated = false;
            }
        });
    }

    boolean isTail(int index) {
        return index >= this.trace.getTail();
    }

    UppaalSystem getSystem() {
        return (UppaalSystem)this.system.dereference();
    }

    public void contentsChanged(ListDataEvent e) {
        this.jmlv.widthsCalculated = false;
        this.jmlv.repaint();
        this.header.repaint();
    }

    public void intervalAdded(ListDataEvent e) {
        this.jmlv.widthsCalculated = false;
        this.jmlv.repaint();
        this.header.repaint();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.jmlv.repaint();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.selection.isSelectionEmpty()) {
            this.jmlv.setSelectionIndex(-1);
        } else {
            this.jmlv.setSelectionIndex(this.selection.getMinSelectionIndex());
            this.jmlv.ensureIndexIsVisible();
        }
    }

    static {
        try {
            UppaalOptions.loadOptionsInto(Class.forName("com.uppaal.gui.simulator.JMSCLog"), "msc");
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Do not obfuscate com.uppaal.gui.simulator.JMSCLog");
        }
    }
}

