/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.gui.editor.EditorBase;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TransitionEditor
extends EditorBase {
    private JTextArea guardTextArea;
    private JTextArea synchronizationTextArea;
    private JTextArea assignmentTextArea;

    protected int getReferenceX() {
        Edge edge = (Edge)this.element;
        Location source = edge.getSource();
        Location target = edge.getTarget();
        int x1 = source.getX();
        int x2 = target.getX();
        return (x1 + x2) / 2;
    }

    protected int getReferenceY() {
        Edge edge = (Edge)this.element;
        Location source = edge.getSource();
        Location target = edge.getTarget();
        int y1 = source.getY();
        int y2 = target.getY();
        return (y1 + y2) / 2;
    }

    public TransitionEditor(JFrame frame, Element theElement) {
        super(frame, theElement, "Edit Edge");
        this.insertFields(frame);
    }

    private void insertFields(JFrame frame) {
        this.guardTextArea = new JTextArea(3, 30);
        this.guardTextArea.setCaretColor(Color.black);
        this.guardTextArea.setText(this.getLabel("guard"));
        this.synchronizationTextArea = new JTextArea(3, 30);
        this.synchronizationTextArea.setCaretColor(Color.black);
        this.synchronizationTextArea.setText(this.getLabel("synchronisation"));
        this.assignmentTextArea = new JTextArea(3, 30);
        this.assignmentTextArea.setCaretColor(Color.black);
        this.assignmentTextArea.setText(this.getLabel("assignment"));
        String[] left = new String[]{"Guard:", "Sync:", "Update: "};
        JComponent[] right = new JComponent[]{this.guardTextArea, this.synchronizationTextArea, this.assignmentTextArea};
        GridBagLayout grid = new GridBagLayout();
        JPanel panel = new JPanel(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        for (int i = 0; i < 3; ++i) {
            JLabel label = new JLabel(left[i], 2);
            label.setDisplayedMnemonic(left[i].charAt(0));
            label.setLabelFor(right[i]);
            c.gridx = 0;
            c.gridy = i;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            panel.add((Component)label, c);
            JScrollPane pane = new JScrollPane(right[i], 20, 31);
            c.gridx = 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)pane, c);
        }
        this.editorPanel.add(panel);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void okPressed() {
        this.getDocument().execute(this.setPropertyCommand("guard", this.guardTextArea.getText().trim(), -60, -30), this.setPropertyCommand("synchronisation", this.synchronizationTextArea.getText().trim(), -60, -15), this.setPropertyCommand("assignment", this.assignmentTextArea.getText().trim(), -60, 0));
        this.dispose();
    }
}

