/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.gui.Main;
import com.uppaal.model.core2.Element;
import com.uppaal.syntax.core.ParseError;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupMenuBase
extends JPopupMenu {
    protected Element element;

    public PopupMenuBase(Element element, String description, Action edit, Action delete) {
        this.element = element;
        this.setLabel(description);
        JMenuItem menuItem = new JMenuItem("Show error(s)");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PopupMenuBase.this.showErrors();
            }
        });
        this.add(menuItem);
        this.addSeparator();
        if (edit.isEnabled()) {
            menuItem = new JMenuItem("Edit " + description);
            menuItem.addActionListener(edit);
            this.add(menuItem);
        }
        menuItem = new JMenuItem(delete);
        menuItem.setText("Delete " + description);
        this.add(menuItem);
    }

    private void showErrors() {
        Vector errors = (Vector)this.element.getPropertyValue("errors");
        if (errors == null || errors.isEmpty()) {
            Main.showInfo("No errors in this item.");
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("Errors:\n");
            for (ParseError error : errors) {
                sb.append(error.begin() + " - " + error.end() + ":   " + error.message() + "\n");
            }
            Main.showInfo(sb.toString());
        }
    }
}

