/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.engine.Problem;
import com.uppaal.gui.Main;
import com.uppaal.gui.ModePanel;
import com.uppaal.gui.ToggleAction;
import com.uppaal.gui.editor.ClearErrors;
import com.uppaal.gui.editor.DescriptionRenderer;
import com.uppaal.gui.editor.DomTextArea;
import com.uppaal.gui.editor.DomTextField;
import com.uppaal.gui.editor.PTEditorControl;
import com.uppaal.gui.editor.PositionRenderer;
import com.uppaal.gui.editor.ProblemModel;
import com.uppaal.gui.tree.DomTree;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.InsertElementCommand;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.RemoveElementCommand;
import com.uppaal.model.core2.Template;
import com.uppaal.model.io2.FIGWriter;
import com.uppaal.syntax.core.ParseError;
import com.uppaal.util.ObservablePointer;
import com.uppaal.util.StringUtils;
import com.uppaal.util.files.FileHandle;
import com.uppaal.util.files.GUIFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTEditorTrimmer
extends ModePanel {
    private ObservablePointer<Document> currentDocument;
    private ObservablePointer<Element> selectedElement;
    private PTEditorControl control;
    private DomTextArea textEditor = new DomTextArea();
    private JScrollPane textEditorPane;
    private JToggleButton selectButton;
    private JToggleButton locationButton;
    private JToggleButton transButton;
    private JToggleButton nailButton;
    private DomTextField processField;
    private DomTextField parameterField;
    private FileHandle psFile;
    private JPanel main;
    private JSplitPane mainSplit;
    private ProblemModel problems;
    private JTable problemTable;
    private ToggleAction selectToolAction;
    private ToggleAction locationToolAction;
    private ToggleAction transitionToolAction;
    private ToggleAction nailToolAction;

    public PTEditorTrimmer(JFrame frame, ObservablePointer<Document> document, ObservablePointer<Element> element) {
        this.selectedElement = element;
        this.currentDocument = document;
        this.textEditorPane = new JScrollPane(this.textEditor);
        this.currentDocument.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                PTEditorTrimmer.this.currentDocumentChanged((Document)arg);
            }
        });
        this.selectedElement.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                PTEditorTrimmer.this.selectedElementChanged((Element)arg);
            }
        });
        this.psFile = new FileHandle(frame, "Encapsulated Postscript File");
        this.psFile.addFilter(new GUIFileFilter("eps", "Encapsulated PS File"));
        this.selectToolAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                PTEditorTrimmer.this.control.setTool("select-select-tool", true);
            }
        };
        this.transitionToolAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                PTEditorTrimmer.this.control.setTool("select-transition-tool", true);
            }
        };
        this.locationToolAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                PTEditorTrimmer.this.control.setTool("select-location-tool", true);
            }
        };
        this.nailToolAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                PTEditorTrimmer.this.control.setTool("select-nail-tool", true);
            }
        };
        this.control = new PTEditorControl();
        this.control.getTool().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                String id = PTEditorTrimmer.this.control.getToolId();
                if ("select-select-tool".equals(id)) {
                    PTEditorTrimmer.this.selectToolAction.setSelected(true);
                } else if ("select-location-tool".equals(id)) {
                    PTEditorTrimmer.this.locationToolAction.setSelected(true);
                } else if ("select-transition-tool".equals(id)) {
                    PTEditorTrimmer.this.transitionToolAction.setSelected(true);
                } else if ("select-nail-tool".equals(id)) {
                    PTEditorTrimmer.this.nailToolAction.setSelected(true);
                }
            }
        });
        DomTree tree = new DomTree(this.currentDocument, this.selectedElement);
        JScrollPane pane = new JScrollPane(tree, 20, 30);
        pane.setPreferredSize(new Dimension(180, 0));
        this.setLeftComponent(pane, "Navigation Tree");
        FlowLayout flow = new FlowLayout();
        flow.setVgap(0);
        this.main = new JPanel(new BorderLayout());
        JPanel west = new JPanel(flow);
        JPanel center = new JPanel(new BorderLayout());
        JPanel top = new JPanel(new BorderLayout());
        this.processField = new DomTextField(10);
        this.parameterField = new DomTextField(15);
        west.add(new JLabel("Name:", 2));
        west.add(this.processField);
        west.add(new JLabel("Parameters:", 2));
        center.add(this.parameterField);
        top.setBorder(new EmptyBorder(2, 0, 2, 0));
        top.add((Component)west, "West");
        top.add((Component)center, "Center");
        this.main.add((Component)top, "North");
        this.main.add(this.control);
        this.problems = new ProblemModel();
        this.problemTable = new JTable(this.problems){

            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        this.problemTable.setSelectionMode(0);
        this.problemTable.setCellSelectionEnabled(false);
        this.problemTable.setColumnSelectionAllowed(false);
        this.problemTable.setRowSelectionAllowed(true);
        this.problemTable.setRequestFocusEnabled(false);
        TableColumnModel columnModel = this.problemTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer(new PositionRenderer());
        columnModel.getColumn(1).setCellRenderer(new DescriptionRenderer());
        JScrollPane errorPane = new JScrollPane(this.problemTable);
        this.mainSplit = new JSplitPane(0, this.main, errorPane);
        this.mainSplit.setOneTouchExpandable(true);
        this.mainSplit.setResizeWeight(1.0);
        this.setMainArea(this.mainSplit);
    }

    private void addAction(Collection list, String key, Action action) {
        action.putValue("ActionCommandKey", key);
        list.add(action);
    }

    public Collection getActions() {
        ArrayList list = new ArrayList();
        this.addAction(list, "selectToolAction", this.selectToolAction);
        this.addAction(list, "transitionToolAction", this.transitionToolAction);
        this.addAction(list, "locationToolAction", this.locationToolAction);
        this.addAction(list, "nailToolAction", this.nailToolAction);
        return list;
    }

    public void normalZoom() {
        this.control.normalZoom();
    }

    public void increaseZoom() {
        this.control.increaseZoom();
    }

    public void decreaseZoom() {
        this.control.decreaseZoom();
    }

    public void setZoom(float zoom) {
        this.control.setZoom(zoom);
    }

    public void zoomToFit() {
        this.control.zoomToFit();
    }

    public double getZoom() {
        return this.control.getZoom();
    }

    public void saveCurrentTemplatePostscript() {
        Template template = this.getCurrentTemplate();
        if (template != null) {
            this.saveTemplatePostscript(template);
        }
    }

    private static boolean completePostscriptFileName(FileHandle file) {
        if (!StringUtils.endsWithIgnoreCase(file.fullName(), ".eps") && !StringUtils.endsWithIgnoreCase(file.fullName(), ".ps")) {
            file.setNew(file.getDirName(), file.getName() + ".eps");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTemplatePostscript(Template template) {
        if (this.psFile.ask("Save Postscript") && PTEditorTrimmer.completePostscriptFileName(this.psFile) && (!this.psFile.exists() || Main.choiceError.errorMessage("Overwrite " + this.psFile.getName() + "?"))) {
            try {
                Rectangle2D bnds = this.control.getModelBounds();
                FileOutputStream stream = this.psFile.outStream();
                try {
                    template.accept(new FIGWriter(stream, this.getFileName()));
                }
                finally {
                    ((OutputStream)stream).close();
                }
            }
            catch (Exception e) {
                Main.infoError.errorMessage("Error Saving Templates as Postscript: " + e.getMessage());
            }
        }
    }

    private String generateNewTemplateName() {
        Node node;
        Document document = this.getDocument();
        int i = -1;
        do {
            ++i;
            for (node = document.getFirst(); node != null && !node.getPropertyValue("name").equals("P" + i); node = node.getNext()) {
            }
        } while (node != null);
        return "P" + i;
    }

    public void addTemplate() {
        String name = this.generateNewTemplateName();
        Document document = this.getDocument();
        Template template = document.createTemplate();
        template.setProperty("name", name);
        document.execute((Command)new InsertElementCommand(document, document.getLast(), template));
        this.selectedElement.set(template);
    }

    protected Template getCurrentTemplate() {
        Element e;
        for (e = this.selectedElement.get(); e != null && !(e instanceof Template); e = e.getParent()) {
        }
        return (Template)e;
    }

    public void deleteCurrentTemplate() {
        Template template = this.getCurrentTemplate();
        if (template != null) {
            this.getDocument().execute((Command)new RemoveElementCommand(template));
            this.selectedElement.set(this.getDocument().getFirst());
        }
    }

    public void deleteTemplate(Template template) {
        boolean isCurrent = this.getCurrentTemplate() == template;
        this.getDocument().execute((Command)new RemoveElementCommand(template));
        if (isCurrent) {
            this.selectedElement.set(this.getDocument().getFirst());
        }
    }

    private void currentDocumentChanged(Document old) {
        this.control.setDocument(this.getDocument());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PTEditorTrimmer.this.selectedElement.set((Template)PTEditorTrimmer.this.getDocument().getFirst());
                PTEditorTrimmer.this.mainSplit.setDividerLocation(1.0);
            }
        });
    }

    private String getFileName() {
        return this.getDocument().getPropertyValue("#name").toString();
    }

    private JToggleButton createToolBarButton(String key, ItemListener listener) {
        URL url = Main.getResource(key + "Image");
        JToggleButton b = url == null ? new JToggleButton(Main.getResourceString(key + "Label")){

            public float getAlignmentY() {
                return 0.5f;
            }
        } : new JToggleButton((Icon)new ImageIcon(url)){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        String astr = Main.getResourceString(key + "Action");
        if (astr == null) {
            astr = key;
        }
        b.setActionCommand(astr);
        b.addItemListener(listener);
        String tip = Main.getResourceString(key + "Tip");
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    private void selectedElementChanged(Element old) {
        Template template;
        Element element = this.selectedElement.get();
        if (element == null || element == this.getDocument()) {
            this.control.setTemplate(null);
            return;
        }
        int pos = this.mainSplit.getDividerLocation();
        this.main.remove(this.control);
        this.main.remove(this.textEditorPane);
        if (element instanceof Template) {
            this.main.add(this.control);
            template = (Template)element;
            this.control.setTemplate(template);
        } else {
            assert (element instanceof Property);
            Property property = (Property)element;
            Element parent = property.getParent();
            this.control.setTemplate(null);
            this.textEditor.setElement(this.getDocument(), parent, property.getName());
            if (parent instanceof Template) {
                this.main.add(this.textEditorPane);
                template = (Template)parent;
            } else {
                this.mainSplit.setTopComponent(this.textEditorPane);
                this.mainSplit.setDividerLocation(pos);
                return;
            }
        }
        this.mainSplit.setTopComponent(this.main);
        this.mainSplit.setDividerLocation(pos);
        this.processField.setElement(this.getDocument(), template, "name");
        this.parameterField.setElement(this.getDocument(), template, "parameter");
    }

    private Document getDocument() {
        return this.currentDocument.get();
    }

    public void setGridOn(boolean value) {
        this.control.setGridOn(value);
    }

    public void setSnapToGrid(boolean value) {
        this.control.setSnapToGrid(value);
    }

    public void coarserGrid() {
        this.control.coarserGrid();
    }

    public void tighterGrid() {
        this.control.tighterGrid();
    }

    public void snapify() {
        this.control.snapify();
    }

    public void purgeTextEditor() {
        this.textEditor.updateElement();
        this.processField.updateElement();
        this.parameterField.updateElement();
    }

    private int offset(String s, int line, int column) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (line == 1) {
                if (column == 1 || s.charAt(i) == '\n') {
                    return i;
                }
                --column;
                continue;
            }
            if (s.charAt(i) != '\n') continue;
            --line;
        }
        return length;
    }

    public void setProblems(Vector<Problem> value) {
        int count = value.size();
        this.getDocument().acceptSafe(new ClearErrors());
        HashMap<Element, Vector<ParseError>> errors = new HashMap<Element, Vector<ParseError>>();
        for (Problem problem : value) {
            ParseError error;
            Element element = problem.getElement();
            if (element == null) continue;
            if (element instanceof Property) {
                String s = (String)((Property)element).getValue();
                error = new ParseError(this.offset(s, problem.getFirstLine(), problem.getFirstColumn()), this.offset(s, problem.getLastLine(), problem.getLastColumn()), problem.getMessage());
            } else {
                error = new ParseError(0, 0, problem.getMessage());
            }
            Vector<ParseError> list = (Vector<ParseError>)errors.get(element);
            if (list == null) {
                list = new Vector<ParseError>();
                errors.put(element, list);
            }
            list.add(error);
        }
        for (Map.Entry entry : errors.entrySet()) {
            ((Element)entry.getKey()).setProperty("errors", entry.getValue());
        }
        this.problems.setProblems(value, this.getDocument());
        if (count > 0 && this.mainSplit.getDividerLocation() >= this.mainSplit.getMaximumDividerLocation()) {
            int height = this.mainSplit.getHeight() - this.mainSplit.getDividerSize();
            count = Math.min(count + 1, 7);
            this.mainSplit.setDividerLocation(height - count * (this.problemTable.getRowHeight() + this.problemTable.getRowMargin()) - 1);
        }
    }
}

