/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.gui.Main;
import com.uppaal.gui.canvas.EdgeViewHandler;
import com.uppaal.gui.canvas.EndNailViewHandler;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.gui.canvas.LabelViewHandler;
import com.uppaal.gui.canvas.LocationViewHandler;
import com.uppaal.gui.canvas.NailViewHandler;
import com.uppaal.gui.canvas.StartNailViewHandler;
import com.uppaal.gui.canvas.TemplateView;
import com.uppaal.gui.canvas.TemplateViewHandler;
import com.uppaal.gui.canvas.TransitionPointEnumeration;
import com.uppaal.gui.editor.ControlMode;
import com.uppaal.gui.editor.EditorBase;
import com.uppaal.gui.editor.LineEditor;
import com.uppaal.gui.editor.LocationEditor;
import com.uppaal.gui.editor.LocationPopupMenu;
import com.uppaal.gui.editor.MultiLineEditor;
import com.uppaal.gui.editor.PopupMenuBase;
import com.uppaal.gui.editor.TransitionEditor;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.InsertEdgeCommand;
import com.uppaal.model.core2.InsertElementCommand;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.RemoveElementCommand;
import com.uppaal.model.core2.SetEndPointCommand;
import com.uppaal.model.core2.SetPropertyCommand;
import com.uppaal.model.core2.SetSourceCommand;
import com.uppaal.model.core2.SetTargetCommand;
import com.uppaal.model.core2.SnapCommand;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.TranslationCommand;
import com.uppaal.util.ObservablePointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PTEditorControl
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener {
    private Template currentTemplate = null;
    private TemplateView view;
    private JScrollPane scrollpane;
    private boolean snapToGrid = true;
    private static final int LOCATION = 0;
    private static final int STATENAME = 1;
    private static final int INVARIANT = 2;
    private static final int TRANSITION = 3;
    private static final int GUARD = 4;
    private static final int SYNC = 5;
    private static final int ASSIGNMENT = 6;
    private static final int NAIL = 7;
    private static final int START = 8;
    private static final int END = 9;
    private ObservablePointer<ControlMode> mode = new ObservablePointer();
    public static final String SELECT_TOOL = "select-select-tool";
    public static final String TRANSITION_TOOL = "select-transition-tool";
    public static final String NAIL_TOOL = "select-nail-tool";
    public static final String LOCATION_TOOL = "select-location-tool";
    private boolean sticky = false;
    private String prevTool = null;
    private boolean prevSticky = false;
    private Selection selection = new Selection();
    private Action deleteAction;
    private Point2D translatedPos = new Point2D.Double();

    public PTEditorControl() {
        super(new BorderLayout());
        TemplateViewHandler[] handlers = new TemplateViewHandler[10];
        handlers[0] = new LocationViewHandler(12, 2, 1);
        handlers[1] = new LabelViewHandler(10, "#location", "name", 0);
        handlers[2] = new LabelViewHandler(10, "#location", "invariant", 0);
        handlers[3] = new EdgeViewHandler(6, 5, 4, 6, 8, 9, 7);
        handlers[4] = new LabelViewHandler(10, "#edge", "guard", 3);
        handlers[6] = new LabelViewHandler(10, "#edge", "assignment", 3);
        handlers[5] = new LabelViewHandler(10, "#edge", "synchronisation", 3);
        handlers[7] = new NailViewHandler(4);
        handlers[8] = new StartNailViewHandler(4);
        handlers[9] = new EndNailViewHandler(4);
        this.view = new TemplateView(handlers);
        this.view.addMouseMotionListener(this);
        this.view.addMouseListener(this);
        this.scrollpane = new JScrollPane(this.view);
        this.scrollpane.getViewport().setScrollMode(1);
        this.scrollpane.getVerticalScrollBar().setUnitIncrement(32);
        this.scrollpane.getHorizontalScrollBar().setUnitIncrement(32);
        this.add((Component)this.scrollpane, "Center");
        this.deleteAction = new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                PTEditorControl.this.getMode().actionPerformed(e);
            }
        };
        this.deleteAction.putValue("ActionCommandKey", "Delete");
        this.registerKeyboardAction(this.deleteAction, "Delete", KeyStroke.getKeyStroke(8, 0), 0);
        this.registerKeyboardAction(this.deleteAction, "Delete", KeyStroke.getKeyStroke(127, 0), 0);
        this.setTool(SELECT_TOOL, true);
        this.setFocusable(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PTEditorControl.this.view.center();
                PTEditorControl.this.view.repaint();
            }
        });
    }

    public void setDocument(Document document) {
        this.setTemplate(null);
        this.view.setDocument(document);
    }

    public void setTemplate(Template template) {
        this.selection.clear();
        this.view.setTemplate(template);
        this.currentTemplate = template;
        this.setTool(SELECT_TOOL, true);
    }

    public void setSnapToGrid(boolean v) {
        this.snapToGrid = v;
    }

    public boolean getSnapToGrid() {
        return this.snapToGrid;
    }

    public void coarserGrid() {
        this.view.setGridSize(this.view.getGridSize() + 32);
    }

    public void tighterGrid() {
        this.view.setGridSize(this.view.getGridSize() - 32);
    }

    private int getSnapDiameter() {
        return this.view.getGridSize() / 4;
    }

    public void setGridOn(boolean b) {
        this.view.setGridOn(b);
    }

    public boolean getGridOn() {
        return this.view.getGridOn();
    }

    private int snapValue(double i) {
        int snapDiameter = this.getSnapDiameter();
        if (snapDiameter > 0) {
            return (int)((double)(snapDiameter / 2) + i) / snapDiameter * snapDiameter;
        }
        return 1;
    }

    public void snapify() {
        if (this.currentTemplate != null) {
            Document doc = this.currentTemplate.getDocument();
            doc.execute((Command)new SnapCommand(this.currentTemplate, this.getSnapDiameter()));
        }
    }

    public void normalZoom() {
        this.setZoom(Main.defaultEditorZoom);
    }

    public void increaseZoom() {
        this.setZoom((8.0 * this.getZoom() + 2.0) / 8.0);
    }

    public void decreaseZoom() {
        this.setZoom(Math.max((8.0 * this.getZoom() - 2.0) / 8.0, 0.25));
    }

    public void setZoom(double zoom) {
        this.view.setZoom(zoom);
    }

    public double getZoom() {
        return this.view.getZoom();
    }

    public void zoomToFit() {
        if (this.view.getEntryCount() != 0) {
            Dimension bnds = this.scrollpane.getViewport().getExtentSize();
            Dimension pref = this.view.getRealSize();
            double x = (bnds.getWidth() - 20.0) / pref.getWidth();
            double y = (bnds.getHeight() - 20.0) / pref.getHeight();
            this.setZoom(Math.min(x, y));
        }
    }

    public ObservablePointer getTool() {
        return this.mode;
    }

    public String getToolId() {
        return this.getMode().getId();
    }

    public void setSticky(boolean value) {
        this.sticky = value;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    private void autoSelectTool(Point2D pos) {
        int idx;
        if (this.prevTool == null) {
            this.prevTool = this.getToolId();
            this.prevSticky = this.isSticky();
        }
        if ((idx = this.view.getEntryAt(pos.getX(), pos.getY())) == -1) {
            this.setTool(LOCATION_TOOL, false);
        } else {
            int type = this.view.getType(idx);
            if (type == 3) {
                this.setTool(NAIL_TOOL, false);
            } else if (type == 0) {
                this.setTool(TRANSITION_TOOL, false);
            } else {
                this.setTool(SELECT_TOOL, false);
            }
        }
    }

    public void setTool(String id, boolean isSticky) {
        this.setSticky(isSticky);
        if (this.mode.get() != null) {
            this.getMode().deactivate();
        }
        if (SELECT_TOOL.equals(id)) {
            this.mode.set(new SelectMode());
        } else if (NAIL_TOOL.equals(id)) {
            this.mode.set(new NailMode());
        } else if (TRANSITION_TOOL.equals(id)) {
            this.mode.set(new TransitionMode());
        } else if (LOCATION_TOOL.equals(id)) {
            this.mode.set(new LocationMode());
        }
        this.getMode().activate();
    }

    public void selectDefaultTool() {
        if (this.prevTool != null) {
            this.setTool(this.prevTool, this.prevSticky);
            this.prevTool = null;
            this.prevSticky = false;
        } else if (!this.sticky) {
            this.setTool(SELECT_TOOL, true);
        }
    }

    private ControlMode getMode() {
        return this.mode.get();
    }

    private boolean isCreationTrigger(MouseEvent e) {
        return e.isAltDown() && (e.getModifiers() & 0x10) != 0 || (e.getModifiers() & 8) != 0;
    }

    public void actionPerformed(ActionEvent e) {
        this.getMode().actionPerformed(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.getMode().isIdle()) {
            if (e.isAltDown()) {
                this.autoSelectTool(this.translate(e.getPoint()));
            } else if (this.prevTool != null) {
                this.selectDefaultTool();
            }
        }
        this.getMode().mouseMoved(e, this.translate(e.getPoint()));
    }

    public void mouseExited(MouseEvent e) {
        this.getMode().mouseExited(e, this.translate(e.getPoint()));
    }

    private Point2D translate(Point2D pos) {
        try {
            this.view.getTransform().inverseTransform(pos, this.translatedPos);
            return this.translatedPos;
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        if (this.getMode().isIdle()) {
            if (this.isCreationTrigger(e)) {
                this.autoSelectTool(this.translate(e.getPoint()));
            } else if (this.prevTool != null) {
                this.selectDefaultTool();
            }
        }
        this.getMode().mousePressed(e, this.translate(e.getPoint()));
    }

    public void mouseDragged(MouseEvent e) {
        this.getMode().mouseDragged(e, this.translate(e.getPoint()));
    }

    public void mouseReleased(MouseEvent e) {
        this.getMode().mouseReleased(e, this.translate(e.getPoint()));
    }

    public void mouseClicked(MouseEvent e) {
        this.getMode().mouseClicked(e, this.translate(e.getPoint()));
    }

    public void mouseEntered(MouseEvent e) {
        this.getMode().mouseEntered(e, this.translate(e.getPoint()));
    }

    public Rectangle2D getModelBounds() {
        return this.view.getModelBounds();
    }

    class TransitionMode
    extends ControlMode {
        private InsertEdgeCommand command;

        TransitionMode() {
        }

        public String getId() {
            return PTEditorControl.TRANSITION_TOOL;
        }

        public void activate() {
            PTEditorControl.this.selection.clear();
        }

        public void deactivate() {
            if (this.command != null) {
                this.command.cancel();
                this.command = null;
            }
        }

        private boolean isPotentialTarget(int target) {
            return target > -1 && PTEditorControl.this.view.getType(target) == 0 && (PTEditorControl.this.view.getElement(target) != this.command.getSource() || this.command.hasNails());
        }

        private void moveEnd(Point2D pos) {
            int idx = PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY(), 0);
            if (this.isPotentialTarget(idx)) {
                PTEditorControl.this.view.setHover(idx);
            } else {
                PTEditorControl.this.view.setHover(-1);
            }
            double x = pos.getX();
            double y = pos.getY();
            if (PTEditorControl.this.getSnapToGrid()) {
                x = PTEditorControl.this.snapValue(x);
                y = PTEditorControl.this.snapValue(y);
            }
            this.command.move((int)x, (int)y);
        }

        public void mouseMoved(MouseEvent e, Point2D pos) {
            if (this.command == null) {
                int idx = PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY(), 0);
                PTEditorControl.this.view.setHover(idx);
            } else {
                this.moveEnd(pos);
            }
        }

        public void mousePressed(MouseEvent e, Point2D pos) {
            if (this.command == null) {
                int idx = PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY(), 0);
                if (idx > -1) {
                    Location source = (Location)PTEditorControl.this.view.getElement(idx);
                    double x = pos.getX();
                    double y = pos.getY();
                    if (PTEditorControl.this.getSnapToGrid()) {
                        x = PTEditorControl.this.snapValue(x);
                        y = PTEditorControl.this.snapValue(y);
                    }
                    this.command = new InsertEdgeCommand(source, (int)x, (int)y);
                    PTEditorControl.this.view.setHover(-1);
                }
            } else if ((e.getModifiers() & 4) != 0) {
                this.command.cancel();
                this.command = null;
                PTEditorControl.this.selectDefaultTool();
            }
        }

        public void mouseDragged(MouseEvent e, Point2D pos) {
            if (this.command != null) {
                this.moveEnd(pos);
            }
        }

        public void mouseReleased(MouseEvent e, Point2D pos) {
            if (this.command != null) {
                int idx = PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY(), 0);
                boolean creation = PTEditorControl.this.isCreationTrigger(e);
                double x = pos.getX();
                double y = pos.getY();
                if (PTEditorControl.this.getSnapToGrid()) {
                    x = PTEditorControl.this.snapValue(x);
                    y = PTEditorControl.this.snapValue(y);
                }
                if (idx == -1 && !creation) {
                    this.command.addNail((int)x, (int)y);
                } else {
                    if (idx == -1 && creation) {
                        this.command.commit((int)x, (int)y);
                    } else {
                        if (!this.isPotentialTarget(idx)) {
                            return;
                        }
                        this.command.commit((Location)PTEditorControl.this.view.getElement(idx));
                    }
                    this.command = null;
                    PTEditorControl.this.selectDefaultTool();
                }
            }
        }

        public boolean isIdle() {
            return this.command == null;
        }
    }

    class LocationMode
    extends ControlMode {
        private InsertElementCommand command;

        LocationMode() {
        }

        public String getId() {
            return PTEditorControl.LOCATION_TOOL;
        }

        public void activate() {
            PTEditorControl.this.selection.clear();
        }

        public void mousePressed(MouseEvent e, Point2D pos) {
            if (e.getClickCount() == 1) {
                double x = pos.getX();
                double y = pos.getY();
                if (PTEditorControl.this.getSnapToGrid()) {
                    x = PTEditorControl.this.snapValue(x);
                    y = PTEditorControl.this.snapValue(y);
                }
                Document doc = PTEditorControl.this.currentTemplate.getDocument();
                Location location = PTEditorControl.this.currentTemplate.createLocation();
                location.setProperty("x", (int)x);
                location.setProperty("y", (int)y);
                this.command = new InsertElementCommand(PTEditorControl.this.currentTemplate, null, location);
                PTEditorControl.this.selection.select(PTEditorControl.this.view.findEntry(location, 0));
            }
        }

        public void mouseDragged(MouseEvent e, Point2D pos) {
            if (this.command != null) {
                double x = pos.getX();
                double y = pos.getY();
                if (PTEditorControl.this.getSnapToGrid()) {
                    x = PTEditorControl.this.snapValue(x);
                    y = PTEditorControl.this.snapValue(y);
                }
                this.command.move((int)x, (int)y);
            }
        }

        public void mouseReleased(MouseEvent e, Point2D pos) {
            if (this.command != null) {
                this.command.commit();
                this.command = null;
                PTEditorControl.this.selection.clear();
                PTEditorControl.this.selectDefaultTool();
            }
        }

        public boolean isIdle() {
            return this.command == null;
        }
    }

    class NailMode
    extends ControlMode {
        private InsertElementCommand command;
        private TransitionPointEnumeration enumeration = new TransitionPointEnumeration();

        public NailMode() {
            PTEditorControl.this.selection.clear();
        }

        public void activate() {
            PTEditorControl.this.selection.clear();
        }

        public String getId() {
            return PTEditorControl.NAIL_TOOL;
        }

        public void mouseMoved(MouseEvent e, Point2D pos) {
            int idx = PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY(), 3);
            PTEditorControl.this.view.setHover(idx);
        }

        private Node getNailBeforeTouchedSegment(Edge edge, double x, double y) {
            this.enumeration.reset(edge);
            Node nail = null;
            Point2D start = this.enumeration.nextElement();
            while (this.enumeration.hasMoreElements()) {
                Point2D end = this.enumeration.nextElement();
                double limit = GraphicsElement.TRANS_TOUCH_DISTANCE * GraphicsElement.TRANS_TOUCH_DISTANCE;
                if (Line2D.ptSegDistSq(start.getX(), start.getY(), end.getX(), end.getY(), x, y) <= limit) {
                    return nail;
                }
                start = end;
                nail = nail == null ? edge.getFirst() : nail.getNext();
            }
            assert (false) : "Point touches no segment";
            return null;
        }

        public void mousePressed(MouseEvent e, Point2D pos) {
            int idx = PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY(), 3);
            if (idx == -1 || e.getClickCount() > 1) {
                return;
            }
            double x = pos.getX();
            double y = pos.getY();
            if (PTEditorControl.this.getSnapToGrid()) {
                x = PTEditorControl.this.snapValue(x);
                y = PTEditorControl.this.snapValue(y);
            }
            Edge edge = (Edge)PTEditorControl.this.view.getElement(idx);
            Node position = this.getNailBeforeTouchedSegment(edge, pos.getX(), pos.getY());
            Nail nail = edge.createNail();
            nail.setProperty("x", (int)x);
            nail.setProperty("y", (int)y);
            this.command = new InsertElementCommand(edge, position, nail);
            PTEditorControl.this.selection.select(PTEditorControl.this.view.findEntry(nail, 7));
        }

        public void mouseDragged(MouseEvent e, Point2D pos) {
            if (this.command == null) {
                return;
            }
            double x = pos.getX();
            double y = pos.getY();
            if (PTEditorControl.this.getSnapToGrid()) {
                x = PTEditorControl.this.snapValue(x);
                y = PTEditorControl.this.snapValue(y);
            }
            this.command.move((int)x, (int)y);
        }

        public void mouseReleased(MouseEvent e, Point2D pos) {
            if (this.command != null) {
                this.command.commit();
                this.command = null;
                PTEditorControl.this.selection.clear();
                PTEditorControl.this.view.setHover(PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY(), 7));
                PTEditorControl.this.selectDefaultTool();
            }
        }

        public boolean isIdle() {
            return this.command != null;
        }
    }

    class SelectMode
    extends ControlMode {
        private boolean idle = true;
        private Mode current;
        private Mode onDrag;

        SelectMode() {
        }

        boolean hasNails(Edge t) {
            return t.getFirst() != null;
        }

        void select(int index) {
            PTEditorControl.this.selection.select(index);
            Element element = (Element)PTEditorControl.this.view.getElement(index);
            element.acceptSafe(new MarkRelatedVisitor(){

                public boolean isMarked(int index) {
                    return PTEditorControl.this.selection.get(index);
                }

                public void mark(int index) {
                    if (index != -1 && !PTEditorControl.this.selection.get(index)) {
                        SelectMode.this.select(index);
                    }
                }
            });
        }

        private int getElementAt(Point2D pos) {
            return PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY());
        }

        private boolean canEdit(int idx) {
            int type = PTEditorControl.this.view.getType(idx);
            return type == 0 || type == 3 || PTEditorControl.this.view.getElement(idx) instanceof Property;
        }

        private void edit(int idx) {
            EditorBase editor;
            Element element = (Element)PTEditorControl.this.view.getElement(idx);
            Element parent = element.getParent();
            JFrame frame = (JFrame)SwingUtilities.windowForComponent(PTEditorControl.this);
            switch (PTEditorControl.this.view.getType(idx)) {
                case 0: {
                    editor = new LocationEditor(frame, element);
                    break;
                }
                case 3: {
                    editor = new TransitionEditor(frame, element);
                    break;
                }
                case 1: {
                    editor = new LineEditor(frame, parent, "Edit Location Name", "name");
                    break;
                }
                case 2: {
                    editor = new MultiLineEditor(frame, parent, "Edit Invariant", "invariant");
                    break;
                }
                case 4: {
                    editor = new MultiLineEditor(frame, parent, "Edit Guard", "guard");
                    break;
                }
                case 5: {
                    editor = new MultiLineEditor(frame, parent, "Edit Synchronisation", "synchronisation");
                    break;
                }
                case 6: {
                    editor = new MultiLineEditor(frame, parent, "Edit Assignment", "assignment");
                    break;
                }
                default: {
                    return;
                }
            }
            editor.setVisible(true);
        }

        private void popup(MouseEvent e, final int idx) {
            PopupMenuBase menu;
            Element element = (Element)PTEditorControl.this.view.getElement(idx);
            AbstractAction editAction = new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    SelectMode.this.edit(idx);
                }
            };
            editAction.setEnabled(this.canEdit(idx));
            switch (PTEditorControl.this.view.getType(idx)) {
                case 0: {
                    menu = new LocationPopupMenu((Location)element, editAction, PTEditorControl.this.deleteAction);
                    break;
                }
                case 3: {
                    menu = new PopupMenuBase(element, "Edge", editAction, PTEditorControl.this.deleteAction);
                    break;
                }
                case 7: {
                    menu = new PopupMenuBase(element, "Nail", editAction, PTEditorControl.this.deleteAction);
                    break;
                }
                case 1: {
                    menu = new PopupMenuBase(element, "Name", editAction, PTEditorControl.this.deleteAction);
                    break;
                }
                case 2: {
                    menu = new PopupMenuBase(element, "Invariant", editAction, PTEditorControl.this.deleteAction);
                    break;
                }
                case 4: {
                    menu = new PopupMenuBase(element, "Guard", editAction, PTEditorControl.this.deleteAction);
                    break;
                }
                case 5: {
                    menu = new PopupMenuBase(element, "Synchronisation", editAction, PTEditorControl.this.deleteAction);
                    break;
                }
                case 6: {
                    menu = new PopupMenuBase(element, "Assignment", editAction, PTEditorControl.this.deleteAction);
                    break;
                }
                default: {
                    return;
                }
            }
            menu.show(PTEditorControl.this.view, (int)e.getPoint().getX(), (int)e.getPoint().getY());
        }

        public void mousePressed(MouseEvent e, Point2D pos) {
            if (e.getClickCount() > 1) {
                return;
            }
            this.idle = false;
            int element = this.getElementAt(pos);
            if (e.isPopupTrigger()) {
                if (element > -1) {
                    if (!PTEditorControl.this.selection.get(element)) {
                        PTEditorControl.this.selection.clear();
                    }
                    PTEditorControl.this.selection.select(element);
                    this.popup(e, element);
                } else {
                    PTEditorControl.this.selection.clear();
                }
                return;
            }
            if (element == -1) {
                if (!e.isControlDown()) {
                    PTEditorControl.this.selection.clear();
                }
                this.onDrag = new Band(pos);
                return;
            }
            int type = PTEditorControl.this.view.getType(element);
            switch (type) {
                case 8: 
                case 9: {
                    this.onDrag = new ChangeTransitionEnd(element, pos);
                    return;
                }
                case 3: {
                    this.onDrag = null;
                    break;
                }
                default: {
                    this.onDrag = new Move(element, pos);
                }
            }
            if (PTEditorControl.this.selection.get(element)) {
                this.current = e.isControlDown() ? new Deselect(element) : new DeselectAllAndSelect(element);
            } else {
                if (!e.isControlDown()) {
                    PTEditorControl.this.selection.clear();
                }
                this.select(element);
            }
        }

        public void mouseDragged(MouseEvent e, Point2D pos) {
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            if (this.onDrag != null) {
                this.current = this.onDrag;
                this.onDrag = null;
            }
            if (this.current != null) {
                this.current.mouseDragged(e, pos);
            }
        }

        public void mouseReleased(MouseEvent e, Point2D pos) {
            if (e.isPopupTrigger()) {
                int element = this.getElementAt(pos);
                if (element > -1) {
                    this.popup(e, element);
                }
                return;
            }
            if (this.current != null) {
                this.current.mouseReleased(e, pos);
            }
            this.current = null;
            this.onDrag = null;
            this.idle = true;
        }

        public void mouseEntered(MouseEvent e, Point2D pos) {
        }

        public void mouseExited(MouseEvent e, Point2D pos) {
            PTEditorControl.this.view.setHover(-1);
        }

        public void mouseMoved(MouseEvent e, Point2D pos) {
            PTEditorControl.this.view.setHover(PTEditorControl.this.view.getEntryAt(pos.getX(), pos.getY()));
        }

        public void mouseClicked(MouseEvent e, Point2D pos) {
            int idx;
            if (e.getClickCount() == 2 && (idx = this.getElementAt(pos)) > -1) {
                this.edit(idx);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if ("Delete".equals(e.getActionCommand())) {
                final HashSet<Element> elements = new HashSet<Element>();
                final Vector commands = new Vector();
                AbstractVisitor visitor = new AbstractVisitor(){

                    public void visitProperty(Property property) throws Exception {
                        if (elements.contains(property)) {
                            commands.add(new SetPropertyCommand(property.getParent(), property.getName(), null));
                        } else {
                            super.visitProperty(property);
                        }
                    }

                    public void visitNode(Node node) throws Exception {
                        if (elements.contains(node)) {
                            commands.add(new RemoveElementCommand(node));
                        } else {
                            super.visitNode(node);
                        }
                    }

                    public void visitEdge(Edge edge) throws Exception {
                        if (elements.contains(edge) || elements.contains(edge.getSource()) || elements.contains(edge.getTarget())) {
                            commands.add(new RemoveElementCommand(edge));
                        } else {
                            super.visitEdge(edge);
                        }
                    }
                };
                for (int i = 0; i < PTEditorControl.this.view.getEntryCount(); ++i) {
                    if (!PTEditorControl.this.selection.get(i)) continue;
                    elements.add((Element)PTEditorControl.this.view.getElement(i));
                }
                PTEditorControl.this.currentTemplate.acceptSafe(visitor);
                Command[] command = commands.toArray(new Command[commands.size()]);
                PTEditorControl.this.currentTemplate.getDocument().execute(command);
            }
        }

        public boolean isIdle() {
            return this.idle;
        }

        public String getId() {
            return PTEditorControl.SELECT_TOOL;
        }

        class ChangeTransitionEnd
        extends Mode {
            private int element;
            private int type;
            private Edge edge;
            private SetEndPointCommand command;
            private boolean hasNails;

            ChangeTransitionEnd(int e, Point2D pos) {
                this.element = e;
                this.type = PTEditorControl.this.view.getType(e);
                this.edge = (Edge)PTEditorControl.this.view.getElement(this.element);
                this.hasNails = this.edge.getFirst() != null;
            }

            void mouseDragged(MouseEvent e, Point2D pos) {
                if (this.command == null) {
                    Document doc = PTEditorControl.this.currentTemplate.getDocument();
                    Edge edge = (Edge)PTEditorControl.this.view.getElement(this.element);
                    this.command = this.type == 8 ? new SetSourceCommand(doc, edge) : new SetTargetCommand(doc, edge);
                }
                double x = pos.getX();
                double y = pos.getY();
                if (PTEditorControl.this.getSnapToGrid()) {
                    x = PTEditorControl.this.snapValue(x);
                    y = PTEditorControl.this.snapValue(y);
                }
                PTEditorControl.this.view.scrollUserSpaceRectToVisible(x, y, 0.0, 0.0);
                int idx = PTEditorControl.this.view.getEntryAt(x, y, 0);
                if (idx > -1) {
                    Location location = (Location)PTEditorControl.this.view.getElement(idx);
                    if ((this.type == 8 && this.edge.getTarget() == location || this.type == 9 && this.edge.getSource() == location) && !this.hasNails) {
                        return;
                    }
                    this.command.setEndPoint(location);
                    this.element = PTEditorControl.this.view.findEntry(this.edge, this.type);
                    PTEditorControl.this.view.setHover(this.element);
                    return;
                }
                if (PTEditorControl.this.view.getType(this.element) != 7) {
                    Nail nail = this.command.convertToNail((int)x, (int)y);
                    this.element = PTEditorControl.this.view.findEntry(nail, 7);
                    PTEditorControl.this.view.setHover(this.element);
                } else {
                    this.command.moveNailTo((int)x, (int)y);
                }
            }

            void mouseReleased(MouseEvent e, Point2D pos) {
                this.command.commit();
            }
        }

        class DeselectAllAndSelect
        extends Mode {
            private int element;

            DeselectAllAndSelect(int e) {
                this.element = e;
            }

            void mouseReleased(MouseEvent e, Point2D pos) {
                PTEditorControl.this.selection.clear();
                SelectMode.this.select(this.element);
            }
        }

        class Deselect
        extends Mode {
            private int element;

            Deselect(int e) {
                this.element = e;
            }

            void mouseReleased(MouseEvent e, Point2D pos) {
                PTEditorControl.this.selection.unselect(this.element);
            }
        }

        class Move
        extends Mode {
            private double diffX;
            private double diffY;
            private Element element;
            private TranslationCommand command;

            Move(int e, Point2D pos) {
                this.element = (Element)PTEditorControl.this.view.getElement(e);
                this.diffX = pos.getX() - (double)((Integer)this.element.getPropertyValue("x")).intValue();
                this.diffY = pos.getY() - (double)((Integer)this.element.getPropertyValue("y")).intValue();
            }

            private void move(Element element, int xd, int yd) {
                Integer x = (Integer)element.getPropertyValue("x");
                Integer y = (Integer)element.getPropertyValue("y");
                if (x != null && y != null) {
                    element.setProperty("x", x + xd);
                    element.setProperty("y", y + yd);
                }
            }

            void mouseDragged(MouseEvent e, Point2D pos) {
                if (this.command == null) {
                    Document doc = PTEditorControl.this.currentTemplate.getDocument();
                    Vector<Element> elements = new Vector<Element>();
                    int count = PTEditorControl.this.view.getEntryCount();
                    for (int i = 0; i < count; ++i) {
                        Element element = (Element)PTEditorControl.this.view.getElement(i);
                        if (!PTEditorControl.this.selection.get(i) || element.getPropertyValue("x") == null || element.getPropertyValue("y") == null) continue;
                        elements.add(element);
                    }
                    this.command = new TranslationCommand(doc, elements);
                }
                double x = pos.getX() - this.diffX;
                double y = pos.getY() - this.diffY;
                if (PTEditorControl.this.getSnapToGrid()) {
                    x = PTEditorControl.this.snapValue(x);
                    y = PTEditorControl.this.snapValue(y);
                }
                PTEditorControl.this.view.scrollUserSpaceRectToVisible(x, y, 0.0, 0.0);
                int xd = (int)x - (Integer)this.element.getPropertyValue("x");
                int yd = (int)y - (Integer)this.element.getPropertyValue("y");
                if (xd == 0 && yd == 0) {
                    return;
                }
                this.command.move(xd, yd);
            }

            void mouseReleased(MouseEvent e, Point2D pos) {
                this.command.commit();
            }
        }

        class Band
        extends Mode {
            private boolean[] set;
            private boolean[] old;
            private int count;
            private Point2D down;

            Band(Point2D pos) {
                this.down = (Point2D)pos.clone();
                this.count = PTEditorControl.this.view.getEntryCount();
            }

            boolean willBeSelected(int index) {
                return this.set[index] && PTEditorControl.this.selection.get(index) == this.old[index];
            }

            void mark(int index) {
                if (index > -1) {
                    this.set[index] = PTEditorControl.this.selection.get(index) ? this.old[index] : !this.old[index];
                    this.markRelated(index);
                }
            }

            void markRelated(int index) {
                Element element = (Element)PTEditorControl.this.view.getElement(index);
                element.acceptSafe(new MarkRelatedVisitor(){

                    public boolean isMarked(int index) {
                        return Band.this.willBeSelected(index);
                    }

                    public void mark(int index) {
                        Band.this.mark(index);
                    }
                });
            }

            void mouseDragged(MouseEvent e, Point2D pos) {
                int i;
                double x = Math.min(this.down.getX(), pos.getX());
                double y = Math.min(this.down.getY(), pos.getY());
                double width = Math.abs(pos.getX() - this.down.getX());
                double height = Math.abs(pos.getY() - this.down.getY());
                if (this.set == null) {
                    this.set = new boolean[this.count];
                    this.old = new boolean[this.count];
                }
                PTEditorControl.this.view.setBand(x, y, width, height);
                PTEditorControl.this.view.getEntriesIn(x, y, width, height, this.set);
                for (i = 0; i < this.count; ++i) {
                    int type = PTEditorControl.this.view.getType(i);
                    if (type == 8 || type == 9) {
                        this.set[i] = false;
                    }
                    if (!this.willBeSelected(i)) continue;
                    this.markRelated(i);
                }
                for (i = 0; i < this.count; ++i) {
                    if (this.set[i] != this.old[i]) {
                        PTEditorControl.this.selection.toogle(i);
                    }
                    this.old[i] = this.set[i];
                }
            }

            void mouseReleased(MouseEvent e, Point2D pos) {
                PTEditorControl.this.view.clearBand();
            }
        }

        abstract class MarkRelatedVisitor
        extends AbstractVisitor {
            MarkRelatedVisitor() {
            }

            public abstract void mark(int var1);

            public abstract boolean isMarked(int var1);

            public void visitLocation(Location location) throws Exception {
                this.mark(PTEditorControl.this.view.findEntry(location.getProperty("name"), 1));
                this.mark(PTEditorControl.this.view.findEntry(location.getProperty("invariant"), 2));
                Template template = location.getTemplate();
                for (Node node = template.getFirst(); node != null; node = node.getNext()) {
                    int index;
                    if (!(node instanceof Edge)) continue;
                    Edge edge = (Edge)node;
                    Location source = edge.getSource();
                    Location target = edge.getTarget();
                    if (source != location && target != location || !this.isMarked(index = PTEditorControl.this.view.findEntry(source, 0)) || !this.isMarked(index = PTEditorControl.this.view.findEntry(target, 0))) continue;
                    this.mark(PTEditorControl.this.view.findEntry(edge, 3));
                }
            }

            public void visitEdge(Edge edge) throws Exception {
                this.mark(PTEditorControl.this.view.findEntry(edge.getProperty("guard"), 4));
                this.mark(PTEditorControl.this.view.findEntry(edge.getProperty("synchronisation"), 5));
                this.mark(PTEditorControl.this.view.findEntry(edge.getProperty("assignment"), 6));
                for (Node node = edge.getFirst(); node != null; node = node.getNext()) {
                    this.mark(PTEditorControl.this.view.findEntry(node, 7));
                }
            }
        }

        class Mode {
            Mode() {
            }

            void mouseDragged(MouseEvent e, Point2D pos) {
            }

            void mouseReleased(MouseEvent e, Point2D pos) {
            }
        }
    }

    class Selection {
        Selection() {
        }

        private void clear() {
            int count = PTEditorControl.this.view.getEntryCount();
            for (int i = 0; i < count; ++i) {
                this.unselect(i);
            }
        }

        public void unselect(int index) {
            this.set(index, false);
        }

        public void select(int index) {
            this.set(index, true);
        }

        public void toogle(int index) {
            this.set(index, !PTEditorControl.this.view.isSelected(index));
        }

        public boolean get(int index) {
            return index > -1 ? PTEditorControl.this.view.isSelected(index) : false;
        }

        public void set(int index, boolean value) {
            PTEditorControl.this.view.setSelected(index, value);
        }

        public void set(boolean[] flags) {
            assert (flags.length == PTEditorControl.this.view.getEntryCount());
            for (int i = 0; i < flags.length; ++i) {
                this.set(i, flags[i]);
            }
        }

        public void toogle(boolean[] flags) {
            assert (flags.length == PTEditorControl.this.view.getEntryCount());
            for (int i = 0; i < flags.length; ++i) {
                if (!flags[i]) continue;
                this.toogle(i);
            }
        }
    }
}

