/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.gui.editor.PopupMenuBase;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.SetPropertyCommand;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;

public class LocationPopupMenu
extends PopupMenuBase {
    public LocationPopupMenu(final Location location, Action editAction, Action deleteAction) {
        super(location, "Location", editAction, deleteAction);
        this.addSeparator();
        JCheckBoxMenuItem initial = new JCheckBoxMenuItem("Initial", this.element.hasFlag("init"));
        initial.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                Document doc = location.getDocument();
                boolean selected = ie.getStateChange() == 1;
                doc.execute((Command)new SetPropertyCommand(location, "init", selected));
            }
        });
        this.add(initial);
        JCheckBoxMenuItem urgent = new JCheckBoxMenuItem("Urgent", this.element.hasFlag("urgent"));
        urgent.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                Document doc = location.getDocument();
                boolean selected = ie.getStateChange() == 1;
                doc.execute(new SetPropertyCommand(location, "committed", false), new SetPropertyCommand(location, "urgent", selected));
            }
        });
        this.add(urgent);
        JCheckBoxMenuItem committed = new JCheckBoxMenuItem("Committed", this.element.hasFlag("committed"));
        committed.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                Document doc = location.getDocument();
                boolean selected = ie.getStateChange() == 1;
                doc.execute(new SetPropertyCommand(location, "committed", selected), new SetPropertyCommand(location, "urgent", false));
            }
        });
        this.add(committed);
    }
}

