/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.gui.editor.EditorBase;
import com.uppaal.model.core2.Element;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LocationEditor
extends EditorBase {
    private JTextField nameControl;
    private JTextArea invariantControl;
    private JCheckBox initialCheckbox;
    private JCheckBox urgentCheckbox;
    private JCheckBox commitCheckbox;

    public LocationEditor(JFrame frame, Element theElement) {
        super(frame, theElement);
        this.insertFields(frame);
    }

    public LocationEditor(JFrame frame, Element element, String title) {
        super(frame, element, title);
        this.insertFields(frame);
    }

    private void insertFields(JFrame frame) {
        this.nameControl = new JTextField(this.getLabel("name"), 30);
        this.nameControl.setCaretColor(Color.black);
        JLabel nameLabel = new JLabel("Name: ", 2);
        nameLabel.setLabelFor(this.nameControl);
        nameLabel.setDisplayedMnemonic('N');
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add((Component)nameLabel, "West");
        namePanel.add((Component)this.nameControl, "Center");
        namePanel.setAlignmentX(0.0f);
        this.invariantControl = new JTextArea(4, 30);
        this.invariantControl.setCaretColor(Color.black);
        this.invariantControl.setText(this.getLabel("invariant"));
        JLabel invariantLabel = new JLabel("Invariant:", 2);
        invariantLabel.setAlignmentX(0.0f);
        invariantLabel.setLabelFor(this.invariantControl);
        invariantLabel.setDisplayedMnemonic('i');
        JScrollPane invariantScrollPane = new JScrollPane(this.invariantControl, 20, 30);
        invariantScrollPane.setAlignmentX(0.0f);
        this.initialCheckbox = new JCheckBox("Initial");
        this.initialCheckbox.setSelected(this.element.hasFlag("init"));
        this.initialCheckbox.setAlignmentX(0.0f);
        this.initialCheckbox.setMnemonic('t');
        this.urgentCheckbox = new JCheckBox("Urgent");
        this.urgentCheckbox.setSelected(this.element.hasFlag("urgent"));
        this.urgentCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (LocationEditor.this.commitCheckbox.isSelected() && LocationEditor.this.urgentCheckbox.isSelected()) {
                    LocationEditor.this.commitCheckbox.setSelected(false);
                }
            }
        });
        this.urgentCheckbox.setAlignmentX(0.0f);
        this.urgentCheckbox.setMnemonic('u');
        this.commitCheckbox = new JCheckBox("Committed");
        this.commitCheckbox.setSelected(this.element.hasFlag("committed"));
        this.commitCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (LocationEditor.this.urgentCheckbox.isSelected() && LocationEditor.this.commitCheckbox.isSelected()) {
                    LocationEditor.this.urgentCheckbox.setSelected(false);
                }
            }
        });
        this.commitCheckbox.setAlignmentX(0.0f);
        this.commitCheckbox.setMnemonic('c');
        Box box = new Box(1);
        this.editorPanel.add((Component)namePanel, "North");
        box.add(invariantLabel);
        box.add(invariantScrollPane);
        box.add(this.initialCheckbox);
        box.add(this.urgentCheckbox);
        box.add(this.commitCheckbox);
        this.editorPanel.add((Component)box, "Center");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void okPressed() {
        this.getDocument().execute(this.setPropertyCommand("name", this.nameControl.getText().trim(), -10, -30), this.setPropertyCommand("invariant", this.invariantControl.getText().trim(), -10, 15), this.setPropertyCommand("init", this.initialCheckbox.isSelected()), this.setPropertyCommand("urgent", this.urgentCheckbox.isSelected()), this.setPropertyCommand("committed", this.commitCheckbox.isSelected()));
        this.dispose();
    }
}

