/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;

class ElementPositionVisitor
implements Visitor {
    protected StringBuffer path;

    public ElementPositionVisitor(StringBuffer path) {
        this.path = path;
    }

    public void visitElement(Element element) {
        Element parent = element.getParent();
        if (parent != null) {
            parent.acceptSafe(this);
        }
    }

    public void visitNode(Node node) throws Exception {
        this.visitElement(node);
    }

    public void visitProperty(Property property) throws Exception {
        this.visitElement(property);
        this.path.append('/').append(property.getName());
    }

    public void visitDocument(Document document) throws Exception {
    }

    public void visitTemplate(Template template) throws Exception {
        this.path.append((String)template.getPropertyValue("name"));
    }

    public void visitLocation(Location location) throws Exception {
        this.visitNode(location);
        this.path.append('/').append((String)location.getPropertyValue("name"));
    }

    public void visitEdge(Edge edge) throws Exception {
        this.visitNode(edge);
        this.path.append('/').append((String)edge.getSource().getPropertyValue("name")).append("->").append((String)edge.getTarget().getPropertyValue("name"));
    }

    public void visitNail(Nail nail) throws Exception {
    }
}

