/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.CompoundCommand;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.SetPropertyCommand;
import com.uppaal.model.core2.SetPropertyWithPositionCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class EditorBase
extends JDialog {
    protected Element element;
    protected JPanel editorPanel = new JPanel(new BorderLayout());
    private Action okAction = new AbstractAction("ok"){

        public void actionPerformed(ActionEvent ae) {
            EditorBase.this.okPressed();
        }
    };
    private Action cancelAction = new AbstractAction("cancel"){

        public void actionPerformed(ActionEvent ae) {
            EditorBase.this.cancelPressed();
        }
    };

    public EditorBase(JFrame frame, Element element) {
        this(frame, element, "Edit");
    }

    public EditorBase(JFrame frame, Element theElement, String title) {
        super(frame, title, true);
        this.element = theElement;
        JButton okTextButton = new JButton("OK");
        okTextButton.addActionListener(this.okAction);
        JButton cancelTextButton = new JButton("Cancel");
        cancelTextButton.addActionListener(this.cancelAction);
        okTextButton.setMnemonic('o');
        this.getRootPane().setDefaultButton(okTextButton);
        JPanel panel = new JPanel(new GridLayout(1, 2, 5, 5));
        panel.add(okTextButton);
        panel.add(cancelTextButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(panel);
        this.editorPanel.add((Component)buttonPanel, "South");
        this.editorPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.editorPanel);
        this.editorPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), this.cancelAction);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EditorBase.this.cancelPressed();
            }
        });
        this.setDefaultCloseOperation(0);
    }

    protected void okPressed() {
        this.dispose();
    }

    protected void cancelPressed() {
        this.dispose();
    }

    protected Document getDocument() {
        return this.element.getDocument();
    }

    protected int getReferenceX() {
        return this.element.getX();
    }

    protected int getReferenceY() {
        return this.element.getY();
    }

    protected String getLabel(String kind) {
        String s = (String)this.element.getPropertyValue(kind);
        return s == null ? "" : s;
    }

    protected Command setPropertyCommand(String name, boolean value) {
        return new SetPropertyCommand(this.element, name, value);
    }

    protected Command setPropertyCommand(String name, String value, int dx, int dy) {
        if (value.length() == 0) {
            value = null;
        }
        int x = this.getReferenceX() + dx;
        int y = this.getReferenceY() + dy;
        return new CompoundCommand(new SetPropertyCommand(this.element, "errors", null), new SetPropertyWithPositionCommand(this.element, name, value, x, y));
    }
}

