/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.gui.Main;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.Command;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.SetPropertyCommand;
import com.uppaal.syntax.core.ParseError;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class DomTextField
extends JTextField {
    private Document document;
    private Element element;
    private String property;
    private JPopupMenu popup;
    private JMenuItem item;
    EventListener listener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            DomTextField.this.setText(value.toString());
        }
    };

    public DomTextField(int columns) {
        super(columns);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DomTextField.this.updateElement();
            }
        });
        this.popup = new JPopupMenu();
        this.item = new JMenuItem("Show error(s)");
        this.item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DomTextField.this.showErrors();
            }
        });
        this.popup.add(this.item);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DomTextField.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(listener);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DomTextField.this.updateElement();
            }
        });
    }

    private Vector getErrors() {
        return (Vector)this.element.getProperty(this.property).getPropertyValue("#errors");
    }

    public void setElement(Document aDocument, Element anElement, String aProperty) {
        this.updateElement();
        if (this.element != null) {
            this.element.getProperty(this.property).removeListener(this.listener);
        }
        this.document = aDocument;
        this.element = anElement;
        this.property = aProperty;
        if (this.element != null) {
            if (!this.element.isPropertyLocal(this.property)) {
                this.element.setProperty(this.property, "");
            }
            this.element.getProperty(this.property).addListener(this.listener);
            this.setText(this.element.getPropertyValue(this.property).toString());
        }
    }

    public void updateElement() {
        Object old;
        String text;
        if (this.element != null && !(text = this.getText()).equals(old = this.element.getPropertyValue(this.property))) {
            this.document.execute((Command)new SetPropertyCommand(this.element, this.property, text));
        }
    }

    private void showErrors() {
        Vector errors = this.getErrors();
        StringBuffer sb = new StringBuffer();
        sb.append("ParseErrors:\n");
        for (int i = 0; i < errors.size(); ++i) {
            ParseError err = (ParseError)errors.get(i);
            sb.append(err.begin() + " - " + err.end() + ":   " + err.message() + "\n");
        }
        Main.showInfo(sb.toString());
    }
}

