/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.editor;

import com.uppaal.gui.Main;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.SetPropertyCommand;
import com.uppaal.syntax.core.ParseError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomTextArea
extends JTextPane {
    private Document document;
    private Element element;
    private String property;
    private Style normal;
    private Style erroneous;
    private JPopupMenu popup;
    private JMenuItem item;
    EventListener listener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            DomTextArea.this.updateText();
        }
    };
    private EventListener errorListener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object oldValue, Object newValue) {
            DomTextArea.this.updateErrors();
        }
    };

    public DomTextArea() {
        this.normal = this.addStyle("normal", null);
        this.erroneous = this.addStyle("error", this.normal);
        StyleConstants.setFontFamily(this.normal, "Monospaced");
        StyleConstants.setFontSize(this.normal, 12);
        StyleConstants.setUnderline(this.erroneous, true);
        StyleConstants.setForeground(this.erroneous, Color.red);
        this.setLogicalStyle(this.normal);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DomTextArea.this.updateElement();
            }
        });
        this.popup = new JPopupMenu();
        this.item = new JMenuItem("Show error(s)");
        this.item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DomTextArea.this.showErrors();
            }
        });
        this.popup.add(this.item);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DomTextArea.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(listener);
    }

    private void updateText() {
        String text = this.element.getPropertyValue(this.property).toString();
        if (!text.equals(this.getText())) {
            this.setText(text);
        }
    }

    private void updateErrors() {
        Vector<ParseError> errors = this.getErrors();
        StyledDocument doc = this.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), this.normal, true);
        for (int i = 0; i < errors.size(); ++i) {
            ParseError pe = errors.get(i);
            doc.setCharacterAttributes(pe.begin(), pe.end() - pe.begin(), this.erroneous, true);
        }
        this.item.setEnabled(errors.size() > 0);
    }

    private Vector<ParseError> getErrors() {
        return (Vector)this.element.getProperty(this.property).getPropertyValue("errors");
    }

    public void setElement(Document aDocument, Element anElement, String aProperty) {
        Element prototype;
        this.updateElement();
        if (this.element != null) {
            prototype = this.element.getPrototype();
            prototype.getProperty(this.property).removeListener(this.listener);
            prototype.getProperty(this.property).getProperty("errors").removeListener(this.errorListener);
        }
        this.document = aDocument;
        this.element = anElement;
        this.property = aProperty;
        if (this.element != null) {
            prototype = this.element.getPrototype();
            prototype.getProperty(this.property).addListener(this.listener);
            prototype.getProperty(this.property).getProperty("errors").addListener(this.errorListener);
            this.updateText();
            this.updateErrors();
        }
    }

    public void updateElement() {
        Object old;
        String text;
        if (this.element != null && !(text = this.getText()).equals(old = this.element.getPropertyValue(this.property))) {
            SetPropertyCommand command1 = new SetPropertyCommand(this.element.getProperty(this.property), "errors", null);
            SetPropertyCommand command2 = new SetPropertyCommand(this.element, this.property, text);
            this.document.execute(command1, command2);
        }
    }

    private void showErrors() {
        Vector<ParseError> errors = this.getErrors();
        StringBuffer sb = new StringBuffer();
        sb.append("ParseErrors:\n");
        for (ParseError e : errors) {
            sb.append(e.begin() + " - " + e.end() + ":   " + e.message() + "\n");
        }
        Main.showInfo(sb.toString());
    }

    @Override
    public void setSize(Dimension d) {
        if (d.width < 4000) {
            d.width = 4000;
        }
        if (d.width < this.getParent().getSize().width) {
            d.width = this.getParent().getSize().width;
        }
        super.setSize(d);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }
}

