/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.canvas.AbstractNailViewHandler;
import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.model.core2.AbstractEventListener;
import com.uppaal.model.core2.AbstractVisitor;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.EventListener;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;

public abstract class VirtualNailViewHandler
extends AbstractNailViewHandler {
    protected EventListener edgeListener = new AbstractEventListener(){

        public void afterInsertion(Node parent, Node element) {
            VirtualNailViewHandler.this.add(element);
        }

        public void beforeRemoval(Node parent, Node element) {
            VirtualNailViewHandler.this.remove(element);
        }

        public void edgeSourceChanged(Edge edge, Location oldSource, Location newSource) {
            VirtualNailViewHandler.this.update(edge);
        }

        public void edgeTargetChanged(Edge edge, Location oldTarget, Location newTarget) {
            VirtualNailViewHandler.this.update(edge);
        }
    };
    protected EventListener nailListener = new AbstractEventListener(){

        public void propertyChanged(Property source, String property, Object old, Object value) {
            Element edge = source.getParent().getParent();
            VirtualNailViewHandler.this.update(edge);
        }

        public void afterInsertion(Node edge, Node element) {
            VirtualNailViewHandler.this.update(edge);
        }

        public void beforeRemoval(Node edge, Node element) {
            VirtualNailViewHandler.this.update(edge);
        }
    };
    protected EventListener locationListener = new AbstractEventListener(){
        Element location;
        Visitor updateVisitor = new AbstractVisitor(){

            public void visitEdge(Edge edge) throws Exception {
                if (VirtualNailViewHandler.this.getEndPoint(edge) == location || VirtualNailViewHandler.this.getDirectionPoint(edge) == location) {
                    VirtualNailViewHandler.this.update(edge);
                }
            }
        };

        public void propertyChanged(Property source, String property, Object old, Object value) {
            this.location = source.getParent();
            this.location.getTemplate().acceptSafe(this.updateVisitor);
        }
    };

    public VirtualNailViewHandler(int anOrder) {
        super(anOrder);
    }

    protected abstract Element getEndPoint(Edge var1);

    protected abstract Element getDirectionPoint(Edge var1);

    public int getPosX(Element element) {
        int y2;
        double yd;
        Edge edge = (Edge)element;
        Element direction = this.getDirectionPoint(edge);
        Element endpoint = this.getEndPoint(edge);
        int x1 = endpoint.getX();
        int y1 = endpoint.getY();
        int x2 = direction.getX();
        double xd = x2 - x1;
        double d = Math.sqrt(xd * xd + (yd = (double)((y2 = direction.getY()) - y1)) * yd);
        if (d > 0.0) {
            double f = (double)(GraphicsElement.STATE_RADIUS + GraphicsElement.NAIL_RADIUS + 1) / d;
            return (int)((double)x1 + f * xd);
        }
        return x1;
    }

    public int getPosY(Element element) {
        int y2;
        double yd;
        Edge edge = (Edge)element;
        Element direction = this.getDirectionPoint(edge);
        Element endpoint = this.getEndPoint(edge);
        int x1 = endpoint.getX();
        int y1 = endpoint.getY();
        int x2 = direction.getX();
        double xd = x2 - x1;
        double d = Math.sqrt(xd * xd + (yd = (double)((y2 = direction.getY()) - y1)) * yd);
        if (d > 0.0) {
            double f = (double)(GraphicsElement.STATE_RADIUS + GraphicsElement.NAIL_RADIUS + 1) / d;
            return (int)((double)y1 + f * yd);
        }
        return y1;
    }

    public void populate(Template template) {
        template.acceptSafe(new AbstractVisitor(){

            public void visitEdge(Edge edge) throws Exception {
                VirtualNailViewHandler.this.add(edge);
            }
        });
    }

    void register(Element template) {
        Element location = (Element)template.getPropertyValue("#location");
        Element edge = (Element)template.getPropertyValue("#edge");
        Element nail = (Element)edge.getPropertyValue("#nail");
        edge.addListener(this.edgeListener);
        nail.addListener(this.nailListener);
        nail.getProperty("x").addListener(this.nailListener);
        nail.getProperty("y").addListener(this.nailListener);
        location.getProperty("x").addListener(this.locationListener);
        location.getProperty("y").addListener(this.locationListener);
    }

    void unregister(Element template) {
        Element location = (Element)template.getPropertyValue("#location");
        Element edge = (Element)template.getPropertyValue("#edge");
        Element nail = (Element)edge.getPropertyValue("#nail");
        edge.removeListener(this.edgeListener);
        nail.removeListener(this.nailListener);
        nail.getProperty("x").removeListener(this.nailListener);
        nail.getProperty("y").removeListener(this.nailListener);
        location.getProperty("x").removeListener(this.locationListener);
        location.getProperty("y").removeListener(this.locationListener);
    }
}

