/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import com.uppaal.gui.canvas.GraphicsElement;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Node;
import java.awt.geom.Point2D;

public class TransitionPointEnumeration {
    protected Edge edge;
    protected Node nail;
    protected Point2D current;
    protected boolean atEnd;

    private void shift(Point2D direction) {
        double yd;
        double xd = direction.getX() - this.current.getX();
        double d = Math.sqrt(xd * xd + (yd = direction.getY() - this.current.getY()) * yd);
        if (d > 0.0) {
            double f = (double)(GraphicsElement.STATE_RADIUS + 1) / d;
            this.current = new Point2D.Double(this.current.getX() + f * xd, this.current.getY() + f * yd);
        }
    }

    public void reset(Edge edge) {
        Location source = edge.getSource();
        Location target = edge.getTarget();
        this.edge = edge;
        this.current = new Point2D.Float(source.getX(), source.getY());
        this.nail = edge.getFirst();
        if (this.nail != null) {
            this.shift(new Point2D.Float(this.nail.getX(), this.nail.getY()));
        } else if (target != null) {
            this.shift(new Point2D.Float(target.getX(), target.getY()));
        } else {
            this.current = null;
        }
        this.atEnd = false;
    }

    public boolean hasMoreElements() {
        return this.current != null;
    }

    public Point2D nextElement() {
        Point2D prev = this.current;
        if (this.nail != null) {
            this.current = new Point2D.Float(this.nail.getX(), this.nail.getY());
            this.nail = this.nail.getNext();
        } else if (!this.atEnd) {
            this.atEnd = true;
            Location target = this.edge.getTarget();
            if (target != null) {
                this.current = new Point2D.Float(target.getX(), target.getY());
                this.shift(prev);
            } else {
                this.current = null;
            }
        } else {
            this.current = null;
        }
        return prev;
    }
}

