/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.gui.canvas;

import java.awt.geom.Rectangle2D;

class TemplateViewRegistry {
    public static final int HOVER = 1;
    public static final int HOVER_RELATED = 2;
    public static final int SELECTED = 4;
    public static final int VISIBLE = 8;
    Object[] elements = new Object[8];
    float[] bounds = new float[4 * this.elements.length];
    int[] states = new int[this.elements.length];
    int[] hash = new int[1024];
    int[] depth = new int[this.elements.length];
    int[] order = new int[this.elements.length];
    int count = 0;
    double x;
    double y;
    double width;
    double height;
    boolean empty = true;
    boolean boundsInvalid;
    private boolean invalid = false;

    public TemplateViewRegistry() {
        for (int i = 0; i < this.hash.length; ++i) {
            this.hash[i] = -1;
        }
    }

    private int pair(int a, int b) {
        return Math.abs(((a + b) * (a + b + 1) >> 1) + a);
    }

    private void resizeTables() {
        Object[] e = this.elements;
        float[] b = this.bounds;
        int[] s = this.states;
        int[] d = this.depth;
        int[] o = this.order;
        this.elements = new Object[e.length << 1];
        this.bounds = new float[e.length << 3];
        this.states = new int[e.length << 1];
        this.depth = new int[e.length << 1];
        this.order = new int[e.length << 1];
        System.arraycopy(e, 0, this.elements, 0, this.count);
        System.arraycopy(b, 0, this.bounds, 0, this.count << 2);
        System.arraycopy(s, 0, this.states, 0, this.count);
        System.arraycopy(d, 0, this.depth, 0, this.count);
        System.arraycopy(o, 0, this.order, 0, this.count);
    }

    public int addEntry(Object element, int type, int dpth) {
        int bucket = this.pair(element.hashCode(), type) % this.hash.length;
        int index = this.getIndex(element, type, bucket);
        if (index > -1) {
            this.depth[index] = dpth;
            return index;
        }
        if (this.count == this.elements.length) {
            this.resizeTables();
        }
        index = this.count;
        this.elements[index] = element;
        this.bounds[4 * index + 3] = 0.0f;
        this.bounds[4 * index + 2] = 0.0f;
        this.bounds[4 * index + 1] = 0.0f;
        this.bounds[4 * index] = 0.0f;
        this.states[index] = 0;
        this.depth[index] = dpth;
        this.hash[bucket] = index;
        this.order[index] = index;
        this.setType(index, type);
        this.invalid |= index > 0 && this.depth[this.order[index - 1]] < dpth;
        ++this.count;
        return index;
    }

    int getIndex(Object element, int type) {
        return this.getIndex(element, type, this.pair(element.hashCode(), type) % this.hash.length);
    }

    private int getIndex(Object element, int type, int bucket) {
        if (this.hash[bucket] > -1 && this.getElement(this.hash[bucket]) == element && this.getType(this.hash[bucket]) == type) {
            return this.hash[bucket];
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.elements[i] != element || this.getType(i) != type) continue;
            this.hash[bucket] = i;
            return i;
        }
        return -1;
    }

    private void move(int source, int dest) {
        int n = this.count - source;
        System.arraycopy(this.elements, source, this.elements, dest, n);
        System.arraycopy(this.bounds, 4 * source, this.bounds, 4 * dest, 4 * n);
        System.arraycopy(this.states, source, this.states, dest, n);
        System.arraycopy(this.depth, source, this.depth, dest, n);
        int i = 0;
        for (int j = 0; j < this.count; ++j) {
            if (this.order[j] >= source) {
                this.order[i++] = this.order[j] + dest - source;
                continue;
            }
            if (this.order[j] >= dest) continue;
            this.order[i++] = this.order[j];
        }
        for (i = 0; i < this.hash.length; ++i) {
            if (this.hash[i] < Math.min(source, dest)) continue;
            this.hash[i] = this.hash[i] >= source ? this.hash[i] + dest - source : -1;
        }
        this.count += dest - source;
    }

    public void removeEntry(int idx) {
        this.move(idx + 1, idx);
        this.empty |= this.count == 0;
    }

    public int getState(int idx) {
        return this.states[idx] & 0xFFFF;
    }

    public void setState(int idx, int state) {
        this.states[idx] = this.states[idx] & 0xFFFF0000 | state;
    }

    private void setFlag(int idx, boolean value, int flag) {
        this.states[idx] = value ? this.states[idx] | flag : this.states[idx] & ~flag;
    }

    private boolean isSet(int idx, int flag) {
        return (this.getState(idx) & flag) == flag;
    }

    private boolean isSetAny(int idx, int flag) {
        return (this.getState(idx) & flag) > 0;
    }

    public void setVisible(int idx, boolean visible) {
        this.setFlag(idx, visible, 8);
    }

    public void setHover(int idx, boolean hover) {
        this.setFlag(idx, hover, 1);
    }

    public void setHoverRelated(int idx, boolean hover) {
        this.setFlag(idx, hover, 2);
    }

    public void setSelected(int idx, boolean selected) {
        this.setFlag(idx, selected, 4);
    }

    public boolean isHover(int idx) {
        return this.isSet(idx, 1);
    }

    public boolean isVisible(int idx) {
        return this.isSet(idx, 8);
    }

    public boolean isHoverRelated(int idx) {
        return this.isSet(idx, 2);
    }

    public boolean isSelected(int idx) {
        return this.isSet(idx, 4);
    }

    public boolean isShowing(int idx) {
        return this.isSetAny(idx, 15);
    }

    public void setType(int idx, int type) {
        this.states[idx] = this.states[idx] & 0xFFFF | type << 16;
    }

    public Object getElement(int idx) {
        return this.elements[idx];
    }

    public int getType(int idx) {
        return this.states[idx] >> 16;
    }

    public int getDepth(int idx) {
        return this.depth[idx];
    }

    public void setBounds(int idx, double x1, double y1, double x2, double y2) {
        this.bounds[idx *= 4] = (float)x1;
        this.bounds[idx + 1] = (float)y1;
        this.bounds[idx + 2] = (float)x2;
        this.bounds[idx + 3] = (float)y2;
        if (this.empty) {
            this.empty = false;
            this.boundsInvalid = false;
            this.x = x1;
            this.y = y1;
            this.width = x2 - x1;
            this.height = y2 - y1;
        } else {
            this.x = Math.min(this.x, x1);
            this.width = Math.max(this.x + this.width, x2) - this.x;
            this.y = Math.min(this.y, y1);
            this.height = Math.max(this.y + this.height, y2) - this.y;
            this.boundsInvalid = true;
        }
    }

    public void recomputeBounds() {
        if (!this.empty && this.boundsInvalid) {
            this.x = this.bounds[0];
            this.y = this.bounds[1];
            this.width = (double)this.bounds[2] - this.x;
            this.height = (double)this.bounds[3] - this.y;
            for (int i = 1; i < this.count; ++i) {
                this.x = Math.min(this.x, (double)this.bounds[4 * i]);
                this.width = Math.max(this.x + this.width, (double)this.bounds[4 * i + 2]) - this.x;
                this.y = Math.min(this.y, (double)this.bounds[4 * i + 1]);
                this.height = Math.max(this.y + this.height, (double)this.bounds[4 * i + 3]) - this.y;
            }
            this.boundsInvalid = false;
        }
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    private void sort(int start, int end) {
        if (end > start) {
            int p = this.partition(start, end);
            this.sort(start, p - 1);
            this.sort(p + 1, end);
        }
    }

    private int partition(int start, int end) {
        int partitionElement = this.depth[this.order[end]];
        int left = start - 1;
        int right = end;
        while (true) {
            if (partitionElement < this.depth[this.order[++left]] && left != end) {
                continue;
            }
            while (partitionElement > this.depth[this.order[--right]] && right != start) {
            }
            if (left >= right) break;
            this.swap(left, right);
        }
        this.swap(left, end);
        return left;
    }

    private void swap(int i, int j) {
        int temp = this.order[i];
        this.order[i] = this.order[j];
        this.order[j] = temp;
    }

    void sort() {
        if (this.invalid) {
            this.sort(0, this.count - 1);
            this.invalid = false;
        }
    }
}

